/*
 * Decompiled with CFR 0.152.
 */
package com.volmit.adapt.util.arcane.spatial.hunk.view;

import com.volmit.adapt.util.arcane.spatial.hunk.Hunk;
import com.volmit.adapt.util.arcane.spatial.util.Function;

public class FunctionalHunkView<R, T>
implements Hunk<T> {
    private final Hunk<R> src;
    private final Function.One<R, T> converter;
    private final Function.One<T, R> backConverter;

    public FunctionalHunkView(Hunk<R> src, Function.One<R, T> converter, Function.One<T, R> backConverter) {
        this.src = src;
        this.converter = converter;
        this.backConverter = backConverter;
    }

    @Override
    public void setRaw(int x, int y, int z, T t) {
        if (this.backConverter == null) {
            throw new UnsupportedOperationException("You cannot write to this hunk (Read Only)");
        }
        this.src.setRaw(x, y, z, this.backConverter.apply(t));
    }

    @Override
    public T getRaw(int x, int y, int z) {
        if (this.converter == null) {
            throw new UnsupportedOperationException("You cannot read this hunk (Write Only)");
        }
        return this.converter.apply(this.src.getRaw(x, y, z));
    }

    @Override
    public int getWidth() {
        return this.src.getWidth();
    }

    @Override
    public int getDepth() {
        return this.src.getDepth();
    }

    @Override
    public int getHeight() {
        return this.src.getHeight();
    }

    @Override
    public Hunk<T> getSource() {
        throw new UnsupportedOperationException("You cannot read this hunk's source because it's a different type.");
    }
}

