/*
 * Decompiled with CFR 0.152.
 */
package com.volmit.adapt.util.arcane.spatial.mantle;

import com.volmit.adapt.util.arcane.spatial.matter.Matter;
import com.volmit.adapt.util.arcane.spatial.matter.MatterSlice;
import com.volmit.adapt.util.arcane.spatial.matter.SpatialMatter;
import com.volmit.adapt.util.arcane.spatial.util.Consume;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicReferenceArray;

public class MantleChunk {
    private final int x;
    private final int z;
    private final AtomicReferenceArray<Matter> sections;

    public MantleChunk(int sectionHeight, int x, int z) {
        this.sections = new AtomicReferenceArray(sectionHeight);
        this.x = x;
        this.z = z;
    }

    public MantleChunk(int sectionHeight, DataInputStream din) throws IOException, ClassNotFoundException {
        this(sectionHeight, din.readByte(), din.readByte());
        int s = din.readByte();
        for (int i = 0; i < s; ++i) {
            if (!din.readBoolean()) continue;
            this.sections.set(i, Matter.readDin(din));
        }
    }

    public boolean exists(int section) {
        return this.get(section) != null;
    }

    public Matter get(int section) {
        return this.sections.get(section);
    }

    public void clear() {
        for (int i = 0; i < this.sections.length(); ++i) {
            this.delete(i);
        }
    }

    public void delete(int section) {
        this.sections.set(section, null);
    }

    public Matter getOrCreate(int section) {
        Matter matter = this.get(section);
        if (matter == null) {
            matter = new SpatialMatter(16, 16, 16);
            this.sections.set(section, matter);
        }
        return matter;
    }

    public void write(DataOutputStream dos) throws IOException {
        dos.writeByte(this.x);
        dos.writeByte(this.z);
        dos.writeByte(this.sections.length());
        for (int i = 0; i < this.sections.length(); ++i) {
            this.trimSlice(i);
            if (this.exists(i)) {
                dos.writeBoolean(true);
                Matter matter = this.get(i);
                matter.writeDos(dos);
                continue;
            }
            dos.writeBoolean(false);
        }
    }

    private void trimSlice(int i) {
        if (this.exists(i)) {
            Matter m = this.get(i);
            if (m.getSliceMap().isEmpty()) {
                this.sections.set(i, null);
            } else {
                m.trimSlices();
                if (m.getSliceMap().isEmpty()) {
                    this.sections.set(i, null);
                }
            }
        }
    }

    public <T> void iterate(Class<T> type, Consume.Four<Integer, Integer, Integer, T> iterator) {
        for (int i = 0; i < this.sections.length(); ++i) {
            MatterSlice<Object> t;
            int bs = i << 4;
            Matter matter = this.get(i);
            if (matter == null || (t = matter.getSlice(type)) == null) continue;
            t.iterateSync((a2, b, c, f) -> iterator.accept((Integer)a2, b + bs, (Integer)c, (Object)f));
        }
    }

    public void deleteSlices(Class<?> c) {
        for (int i = 0; i < this.sections.length(); ++i) {
            Matter m = this.sections.get(i);
            if (m == null || !m.hasSlice(c)) continue;
            m.deleteSlice(c);
        }
    }

    public void trimSlices() {
        for (int i = 0; i < this.sections.length(); ++i) {
            if (!this.exists(i)) continue;
            this.trimSlice(i);
        }
    }

    public int getX() {
        return this.x;
    }

    public int getZ() {
        return this.z;
    }
}

