/*
 * Decompiled with CFR 0.152.
 */
package com.volmit.adapt.util.arcane.spatial.matter;

import com.volmit.adapt.util.arcane.spatial.container.DataPalette;
import com.volmit.adapt.util.arcane.spatial.matter.MatterSlice;
import com.volmit.adapt.util.arcane.spatial.util.IOAdapter;
import com.volmit.adapt.util.arcane.spatial.util.Varint;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class MatterPalette<T>
implements IOAdapter<T> {
    private final MatterSlice<T> slice;
    private final DataPalette<T> palette;

    public MatterPalette(MatterSlice<T> slice) {
        this.slice = slice;
        this.palette = new DataPalette();
    }

    public MatterPalette(MatterSlice<T> slice, DataInputStream din) throws IOException {
        this.slice = slice;
        this.palette = DataPalette.getPalette(this, din);
    }

    public void writeNode(T t, DataOutputStream dos) throws IOException {
        Varint.writeUnsignedVarInt(this.palette.getIndex(t), dos);
    }

    public T readNode(DataInputStream din) throws IOException {
        return this.palette.get(Varint.readUnsignedVarInt(din));
    }

    public void writePalette(DataOutputStream dos) throws IOException {
        this.palette.write(this, dos);
    }

    @Override
    public void write(T t, DataOutputStream dos) throws IOException {
        this.slice.writeNode(t, dos);
    }

    @Override
    public T read(DataInputStream din) throws IOException {
        return this.slice.readNode(din);
    }

    public void assign(T b) {
        this.palette.getIndex(b);
    }
}

