/*
 * Decompiled with CFR 0.152.
 */
package com.volmit.adapt.util.arcane.spatial.matter.slices;

import com.volmit.adapt.util.arcane.spatial.hunk.storage.MappedHunk;
import com.volmit.adapt.util.arcane.spatial.hunk.storage.PaletteOrHunk;
import com.volmit.adapt.util.arcane.spatial.matter.MatterReader;
import com.volmit.adapt.util.arcane.spatial.matter.MatterSlice;
import com.volmit.adapt.util.arcane.spatial.matter.MatterWriter;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public abstract class RawMatter<T>
extends PaletteOrHunk<T>
implements MatterSlice<T> {
    protected final Map<Class<?>, MatterWriter<?, T>> writers = new HashMap();
    protected final Map<Class<?>, MatterReader<?, T>> readers = new HashMap();
    private final Class<T> type;

    public RawMatter(int width, int height, int depth, Class<T> type) {
        super(width, height, depth, true, () -> new MappedHunk(width, height, depth));
        this.type = type;
    }

    protected <W> void registerWriter(Class<W> mediumType, MatterWriter<W, T> injector) {
        this.writers.put(mediumType, injector);
    }

    protected <W> void registerReader(Class<W> mediumType, MatterReader<W, T> injector) {
        this.readers.put(mediumType, injector);
    }

    @Override
    public <W> MatterWriter<W, T> writeInto(Class<W> mediumType) {
        return this.writers.get(mediumType);
    }

    @Override
    public <W> MatterReader<W, T> readFrom(Class<W> mediumType) {
        return this.readers.get(mediumType);
    }

    @Override
    public abstract void writeNode(T var1, DataOutputStream var2) throws IOException;

    @Override
    public abstract T readNode(DataInputStream var1) throws IOException;

    @Override
    public Class<T> getType() {
        return this.type;
    }
}

