/*
 * Decompiled with CFR 0.152.
 */
package com.volmit.adapt.util.command;

import com.volmit.adapt.Adapt;
import com.volmit.adapt.util.C;
import com.volmit.adapt.util.command.SoundFeedback;
import com.volmit.adapt.util.manifold.rt.api.IBootstrap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class Feedback {
    private List<SoundFeedback> sounds;
    private List<TextComponent> messages;

    public void send(CommandSender serverOrPlayer) {
        if (serverOrPlayer instanceof Player) {
            Player p = (Player)serverOrPlayer;
            for (SoundFeedback i : this.sounds) {
                i.play(p);
            }
        }
        for (TextComponent i : this.messages) {
            String prefix = C.GRAY + "[" + C.DARK_RED + "Adapt" + C.GRAY + "]:";
            Adapt.audiences.sender(serverOrPlayer).sendMessage((Component)i.content(prefix + " " + i.content()));
        }
    }

    Feedback(List<SoundFeedback> sounds, List<TextComponent> messages) {
        this.sounds = sounds;
        this.messages = messages;
    }

    public static FeedbackBuilder builder() {
        return new FeedbackBuilder();
    }

    public List<SoundFeedback> sounds() {
        return this.sounds;
    }

    public List<TextComponent> messages() {
        return this.messages;
    }

    public Feedback sounds(List<SoundFeedback> sounds) {
        this.sounds = sounds;
        return this;
    }

    public Feedback messages(List<TextComponent> messages) {
        this.messages = messages;
        return this;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Feedback)) {
            return false;
        }
        Feedback other = (Feedback)o;
        if (!other.canEqual(this)) {
            return false;
        }
        List<SoundFeedback> this$sounds = this.sounds();
        List<SoundFeedback> other$sounds = other.sounds();
        if (this$sounds == null ? other$sounds != null : !((Object)this$sounds).equals(other$sounds)) {
            return false;
        }
        List<TextComponent> this$messages = this.messages();
        List<TextComponent> other$messages = other.messages();
        return !(this$messages == null ? other$messages != null : !((Object)this$messages).equals(other$messages));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Feedback;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<SoundFeedback> $sounds = this.sounds();
        result = result * 59 + ($sounds == null ? 43 : ((Object)$sounds).hashCode());
        List<TextComponent> $messages = this.messages();
        result = result * 59 + ($messages == null ? 43 : ((Object)$messages).hashCode());
        return result;
    }

    public String toString() {
        return "Feedback(sounds=" + this.sounds() + ", messages=" + this.messages() + ")";
    }

    static {
        IBootstrap.dasBoot();
    }

    public static class FeedbackBuilder {
        private ArrayList<SoundFeedback> sounds;
        private ArrayList<TextComponent> messages;

        FeedbackBuilder() {
        }

        public FeedbackBuilder sound(SoundFeedback sound) {
            if (this.sounds == null) {
                this.sounds = new ArrayList();
            }
            this.sounds.add(sound);
            return this;
        }

        public FeedbackBuilder sounds(Collection<? extends SoundFeedback> sounds) {
            if (sounds == null) {
                throw new NullPointerException("sounds cannot be null");
            }
            if (this.sounds == null) {
                this.sounds = new ArrayList();
            }
            this.sounds.addAll(sounds);
            return this;
        }

        public FeedbackBuilder clearSounds() {
            if (this.sounds != null) {
                this.sounds.clear();
            }
            return this;
        }

        public FeedbackBuilder message(TextComponent message) {
            if (this.messages == null) {
                this.messages = new ArrayList();
            }
            this.messages.add(message);
            return this;
        }

        public FeedbackBuilder messages(Collection<? extends TextComponent> messages) {
            if (messages == null) {
                throw new NullPointerException("messages cannot be null");
            }
            if (this.messages == null) {
                this.messages = new ArrayList();
            }
            this.messages.addAll(messages);
            return this;
        }

        public FeedbackBuilder clearMessages() {
            if (this.messages != null) {
                this.messages.clear();
            }
            return this;
        }

        public Feedback build() {
            return new Feedback(switch (this.sounds == null ? 0 : this.sounds.size()) {
                case 0 -> Collections.emptyList();
                case 1 -> Collections.singletonList(this.sounds.get(0));
                default -> Collections.unmodifiableList(new ArrayList<SoundFeedback>(this.sounds));
            }, switch (this.messages == null ? 0 : this.messages.size()) {
                case 0 -> Collections.emptyList();
                case 1 -> Collections.singletonList(this.messages.get(0));
                default -> Collections.unmodifiableList(new ArrayList<TextComponent>(this.messages));
            });
        }

        public String toString() {
            return "Feedback.FeedbackBuilder(sounds=" + this.sounds + ", messages=" + this.messages + ")";
        }

        static {
            IBootstrap.dasBoot();
        }
    }
}

