/*
 * Decompiled with CFR 0.152.
 */
package com.volmit.adapt.util.extensions.java.lang.Math;

import com.volmit.adapt.util.manifold.ext.rt.api.Extension;
import com.volmit.adapt.util.manifold.rt.api.IBootstrap;
import java.util.regex.Matcher;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;

@Extension
public class XMath {
    private static final int precision = 128;
    private static final int modulus = 46080;
    private static final float[] sin;
    public static int tick;

    @Extension
    public static double rangeScale(double amin, double amax, double bmin, double bmax, double b) {
        return amin + (amax - amin) * ((b - bmin) / (bmax - bmin));
    }

    @Extension
    public static double lerpInverse(double from, double to, double at) {
        return XMath.rangeScale(0.0, 1.0, from, to, at);
    }

    @Extension
    public static double lerp(double a2, double b, double f) {
        return a2 + f * (b - a2);
    }

    @Extension
    public static double bilerp(double a2, double b, double c, double d, double x, double y) {
        return XMath.lerp(XMath.lerp(a2, b, x), XMath.lerp(c, d, x), y);
    }

    @Extension
    public static double trilerp(double a2, double b, double c, double d, double e, double f, double g, double h, double x, double y, double z) {
        return XMath.lerp(XMath.bilerp(a2, b, c, d, x, y), XMath.bilerp(e, f, g, h, x, y), z);
    }

    @Extension
    public static double dclip(double value, double min, double max) {
        return Math.min(max, Math.max(min, value));
    }

    @Extension
    public static boolean r(Double d) {
        if (d == null) {
            return Math.random() < 0.5;
        }
        return Math.random() < d;
    }

    @Extension
    public static double tps(long ns, int rad) {
        return 20.0 * ((double)ns / 5.0E7) / (double)rad;
    }

    @Extension
    public static double ticksFromNS(long ns) {
        return (double)ns / 5.0E7;
    }

    @Extension
    public static long ns() {
        return System.nanoTime();
    }

    @Extension
    public static long ms() {
        return System.currentTimeMillis();
    }

    @Extension
    public static double evaluate(String expression, Double ... args) throws ScriptException, IndexOutOfBoundsException {
        for (int i = 0; i < args.length; ++i) {
            String current = "$" + i;
            if (!expression.contains(current)) continue;
            expression = expression.replaceAll(Matcher.quoteReplacement(current), "" + args[i]);
        }
        return XMath.evaluate(expression);
    }

    @Extension
    public static double evaluate(String expression) throws ScriptException {
        ScriptEngineManager mgr = new ScriptEngineManager();
        ScriptEngine scriptEngine = mgr.getEngineByName("JavaScript");
        return Double.parseDouble(scriptEngine.eval(expression).toString());
    }

    @Extension
    public static boolean within(int from, int to, int is) {
        return is >= from && is <= to;
    }

    @Extension
    public static long epochDays() {
        return XMath.epochDays(XMath.ms());
    }

    @Extension
    public static long epochDays(long ms) {
        return ms / 1000L / 60L / 60L / 24L;
    }

    @Extension
    public static double constrainToRange(double value, double min, double max) {
        return Math.min(Math.max(value, min), max);
    }

    @Extension
    public static double sq(double a2) {
        return a2 * a2;
    }

    @Extension
    public static int sq(int a2) {
        return a2 * a2;
    }

    @Extension
    public static float sq(float a2) {
        return a2 * a2;
    }

    @Extension
    public static float sinLookup(int a2) {
        return a2 >= 0 ? sin[a2 % 46080] : -sin[-a2 % 46080];
    }

    @Extension
    public static boolean interval(int tickInterval) {
        return tick % (tickInterval <= 0 ? 1 : tickInterval) == 0;
    }

    static {
        IBootstrap.dasBoot();
        sin = new float[46080];
        tick = 0;
        for (int i = 0; i < sin.length; ++i) {
            XMath.sin[i] = (float)Math.sin((double)i * Math.PI / 23040.0);
        }
    }
}

