/*
 * Decompiled with CFR 0.152.
 */
package com.volmit.adapt.util.extensions.java.util.Map;

import com.volmit.adapt.util.arcane.amulet.functional.Consume;
import com.volmit.adapt.util.extensions.java.util.List.XList;
import com.volmit.adapt.util.extensions.java.util.Set.XSet;
import com.volmit.adapt.util.extensions.java.util.stream.Stream.XStream;
import com.volmit.adapt.util.manifold.ext.rt.api.Extension;
import com.volmit.adapt.util.manifold.ext.rt.api.Self;
import com.volmit.adapt.util.manifold.ext.rt.api.This;
import com.volmit.adapt.util.manifold.rt.api.IBootstrap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Predicate;
import java.util.function.Supplier;

@Extension
public class XMap {
    public static <K, V> List<K> sortK(@This Map<K, V> self, Comparator<V> comparator) {
        ArrayList<K> k = new ArrayList<K>();
        List<V> v = XMap.v(self);
        List<K> sk = XMap.k(self);
        v.sort(comparator);
        for (V i : v) {
            for (K j : sk) {
                if (!self.get(j).equals(i)) continue;
                k.add(j);
            }
        }
        return k;
    }

    public static <K, V> List<K> sortKNumber(@This Map<K, V> self) {
        ArrayList<K> k = new ArrayList<K>();
        List<V> v = XMap.v(self);
        Collections.sort(v, (v1, t1) -> {
            Number n1 = (Number)v1;
            Number n2 = (Number)t1;
            return (int)((n1.doubleValue() - n2.doubleValue()) * 1000.0);
        });
        for (V i : v) {
            for (K j : XMap.k(self)) {
                if (!self.get(j).equals(i)) continue;
                k.add(j);
            }
        }
        return XList.withoutDuplicates(k);
    }

    @Self
    public static <K, V> Map<K, V> unmodifiable(@This Map<K, V> self) {
        return Collections.unmodifiableMap(self);
    }

    public static <K, V> List<K> sortK(@This Map<K, V> self) {
        return XMap.sortK(self, Comparator.comparing(Object::toString));
    }

    @Self
    public static <K, V> Map<K, V> plus(@This Map<K, V> self, Map<K, V> map) {
        return XMap.put(XMap.copy(self), map);
    }

    @Self
    public static <K, V> Map<K, V> removeWhere(@This Map<K, V> self, Predicate<K> predicate) {
        XSet.removeWhere(self.keySet(), predicate);
        return self;
    }

    @Extension
    public static <K, V> Map<K, V> from(Object ... collection) {
        return XStream.splitInterlace(Arrays.stream(collection), (e, o) -> XMap.from(e.map(i -> i).toList(), o.map(i -> i).toList()));
    }

    @Extension
    public static <K, V> Map<K, V> from(List<K> k, List<V> v) {
        HashMap map = new HashMap();
        XList.forEachIndex(k, (m, i) -> map.put(m.get((int)i), v.get((int)i)));
        return map;
    }

    @Extension
    public static <K, V> ConcurrentHashMap<K, V> concurrent() {
        return new ConcurrentHashMap();
    }

    @Extension
    public static <K, V> HashMap<K, V> hash() {
        return new HashMap();
    }

    @Extension
    public static <K, V> LinkedHashMap<K, V> linked() {
        return new LinkedHashMap();
    }

    @Extension
    public static <K, V> WeakHashMap<K, V> weak() {
        return new WeakHashMap();
    }

    @Extension
    public static <K, V> IdentityHashMap<K, V> identityHash() {
        return new IdentityHashMap();
    }

    @Self
    public static <K, V> Map<K, V> keepWhere(@This Map<K, V> self, Predicate<K> predicate) {
        XSet.keepWhere(self.keySet(), predicate);
        return self;
    }

    @Self
    public static <K, V> Map<K, V> minus(@This Map<K, V> self, Map<K, V> map) {
        return XMap.removeWhere(XMap.copy(self), map::containsKey);
    }

    @Self
    public static <K, V> Map<K, V> minus(@This Map<K, V> self, Collection<K> collection) {
        return XMap.removeWhere(XMap.copy(self), collection::contains);
    }

    @Self
    public static <K, V> Map<K, V> minus(@This Map<K, V> self, K v) {
        return XMap.qremove(XMap.copy(self), v);
    }

    @Self
    public static <K, V> Map<V, K> unaryMinus(@This Map<K, V> self) {
        return XMap.flipFlatten(XMap.copy(self));
    }

    @Self
    public static <K, V> Map<K, V> put(@This Map<K, V> self, Map<K, V> m) {
        self.putAll(m);
        return self;
    }

    @Self
    public static <K, V> Map<K, V> copy(@This Map<K, V> self, Supplier<Map<K, V>> factory) {
        return XMap.put(factory.get(), self);
    }

    @Self
    public static <K, V> Map<K, V> copy(@This Map<K, V> self) {
        return XMap.copy(self, HashMap::new);
    }

    @Self
    public static <K, V> Map<K, V> rewrite(@This Map<K, V> self, Consume.Three<K, V, Map<K, V>> f) {
        Map<K, V> m = XMap.copy(self);
        for (K i : XMap.k(m)) {
            f.accept(i, self.get(i), self);
        }
        return self;
    }

    @Self
    public static <K, V> Map<K, V> each(@This Map<K, V> self, Consume.Two<K, V> f) {
        for (K i : XMap.k(self)) {
            f.accept(i, self.get(i));
        }
        return self;
    }

    public static <K, V> Map<V, K> flipFlatten(@This Map<K, V> self) {
        Map<V, List<K>> f = XMap.flip(self);
        HashMap m = new HashMap();
        for (V i : XMap.k(f)) {
            XMap.putNonNull(m, i, m.isEmpty() ? null : (V)f.get(i).get(0));
        }
        return m;
    }

    public static <K, V> Map<V, List<K>> flip(@This Map<K, V> self) {
        HashMap<Object, List> flipped = new HashMap<Object, List>();
        for (K i : self.keySet()) {
            if (i == null) continue;
            flipped.computeIfAbsent(self.get(i), __ -> new ArrayList()).add(i);
        }
        return flipped;
    }

    public static <K, V> List<V> sortV(@This Map<K, V> self, Comparator<K> comparator) {
        ArrayList<V> v = new ArrayList<V>();
        List<K> k = XMap.k(self);
        List<V> vs = XMap.v(self);
        k.sort(comparator);
        for (K i : k) {
            for (V j : vs) {
                if (!self.get(i).equals(j)) continue;
                v.add(j);
            }
        }
        return v;
    }

    public static <K, V> List<V> sortV(@This Map<K, V> self) {
        return XMap.sortV(self, Comparator.comparing(Object::toString));
    }

    public static <K, V> List<K> k(@This Map<K, V> self) {
        return XList.from(self.keySet());
    }

    public static <K, V> List<V> v(@This Map<K, V> self) {
        return XList.from(self.values());
    }

    @Self
    public static <K, V> Map<K, V> qput(@This Map<K, V> self, K key, V value) {
        self.put(key, value);
        return self;
    }

    @Self
    public static <K, V> Map<K, V> qremove(@This Map<K, V> self, K key) {
        self.remove(key);
        return self;
    }

    @Self
    public static <K, V> Map<K, V> putNonNull(@This Map<K, V> self, K key, V value) {
        if (key != null && value != null) {
            self.put(key, value);
        }
        return self;
    }

    @Self
    public static <K, V> Map<K, V> qclear(@This Map<K, V> self) {
        self.clear();
        return self;
    }

    static {
        IBootstrap.dasBoot();
    }
}

