/*
 * Decompiled with CFR 0.152.
 */
package com.volmit.adapt.util.extensions.java.util.Set;

import com.volmit.adapt.util.extensions.java.util.List.XList;
import com.volmit.adapt.util.extensions.java.util.stream.Stream.XStream;
import com.volmit.adapt.util.manifold.ext.rt.api.Extension;
import com.volmit.adapt.util.manifold.ext.rt.api.Self;
import com.volmit.adapt.util.manifold.ext.rt.api.This;
import com.volmit.adapt.util.manifold.rt.api.IBootstrap;
import com.volmit.adapt.util.manifold.util.concurrent.ConcurrentHashSet;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;

@Extension
public class XSet {
    @Self
    public static <E> Set<E> copy(@This Set<E> self) {
        return XSet.copy(self, HashSet::new);
    }

    @Self
    public static <E> Set<E> unmodifiable(@This Set<E> self) {
        return Collections.unmodifiableSet(self);
    }

    @Self
    public static <E> Set<E> copy(@This Set<E> self, Supplier<Set<E>> factory) {
        Set<E> t = factory.get();
        t.addAll(self);
        return t;
    }

    public static <E> boolean isNotEmpty(@This Set<E> self) {
        return !self.isEmpty();
    }

    @SafeVarargs
    @Self
    public static <E> Set<E> add(@This Set<E> self, E ... o) {
        Collections.addAll(self, o);
        return self;
    }

    @Self
    public static <E> Set<E> add(@This Set<E> self, Set<E> o) {
        self.addAll(o);
        return self;
    }

    @SafeVarargs
    @Self
    public static <E> Set<E> remove(@This Set<E> self, E ... o) {
        for (E i : o) {
            self.remove(i);
        }
        return self;
    }

    @Self
    public static <E> Set<E> remove(@This Set<E> self, Set<E> o) {
        for (E i : o) {
            self.remove(i);
        }
        return self;
    }

    @Self
    public static <E> Set<E> removeWhere(@This Set<E> self, Predicate<E> predicate) {
        if (self.isEmpty()) {
            return self;
        }
        Set s = XStream.toSet(self.stream().filter(predicate.negate()));
        self.clear();
        self.addAll(s);
        return self;
    }

    @Self
    public static <E> Set<E> keepWhere(@This Set<E> self, Predicate<E> predicate) {
        return XSet.removeWhere(self, predicate.negate());
    }

    @Self
    public static <E, R> Set<R> convert(@This Set<E> self, Function<E, R> converter) {
        HashSet<R> f = new HashSet<R>();
        for (E i : self) {
            R r = converter.apply(i);
            if (r == null) continue;
            f.add(r);
        }
        return f;
    }

    public static <E> E pop(@This Set<E> self) {
        if (self.isEmpty()) {
            return null;
        }
        Iterator<E> it = self.iterator();
        E o = it.next();
        it.remove();
        return o;
    }

    public static <E> E getFirst(@This Set<E> self) {
        if (self.isEmpty()) {
            return null;
        }
        return self.iterator().next();
    }

    @Extension
    public static <E> ConcurrentHashSet<E> concurrent() {
        return new ConcurrentHashSet();
    }

    @Extension
    public static <E> HashSet<E> hash() {
        return new HashSet();
    }

    @Extension
    public static <E> LinkedHashSet<E> linked() {
        return new LinkedHashSet();
    }

    @Extension
    public static <E> CopyOnWriteArraySet<E> copyOnWriteArraySet() {
        return new CopyOnWriteArraySet();
    }

    @Extension
    public static <E> Set<E> from(Collection<E> collection) {
        return XSet.from(collection, HashSet::new);
    }

    @Extension
    public static <E> Set<E> from(Collection<E> collection, Supplier<Set<E>> factory) {
        Set<E> l = factory.get();
        l.addAll(collection);
        return l;
    }

    @SafeVarargs
    @Extension
    public static <E> Set<E> from(E ... collection) {
        return XSet.from(HashSet::new, collection);
    }

    @SafeVarargs
    public static <E> Set<E> from(Supplier<Set<E>> factory, E ... collection) {
        Set<E> l = factory.get();
        XSet.add(l, collection);
        return l;
    }

    @Self
    public static <E> Set<E> qclear(@This Set<E> self) {
        self.clear();
        return self;
    }

    public static <E> List<E> list(@This Set<E> self) {
        return XList.from(self);
    }

    @Self
    public static <E> Set<E> minus(@This Set<E> self, E that) {
        Set<E> s = XSet.from(self);
        s.remove(that);
        return s;
    }

    @Self
    public static <E> Set<E> minus(@This Set<E> self, Collection<E> that) {
        Set<E> s = XSet.from(self);
        s.removeAll(that);
        return s;
    }

    public static <E> String toString(@This Set<E> self, String split) {
        if (self.isEmpty()) {
            return "";
        }
        if (self.size() == 1) {
            return "" + XSet.getFirst(self);
        }
        Iterator<E> it = self.iterator();
        StringBuilder b = new StringBuilder();
        while (it.hasNext()) {
            E e = it.next();
            b.append(split).append(e);
        }
        return b.substring(split.length());
    }

    static {
        IBootstrap.dasBoot();
    }
}

