/*
 * Decompiled with CFR 0.152.
 */
package com.volmit.adapt.util.manifold.util.concurrent;

import com.volmit.adapt.util.manifold.util.ILogger;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;

public class Cache<K, V> {
    private ConcurrentLinkedHashMap<K, V> _cacheImlp;
    private final Loader<K, V> _loader;
    private final String _name;
    private final int _size;
    private final AtomicInteger _requests = new AtomicInteger();
    private final AtomicInteger _misses = new AtomicInteger();
    private final AtomicInteger _hits = new AtomicInteger();
    private ScheduledFuture<?> _loggingTask;

    public Cache(String name, int size, Loader<K, V> loader) {
        this._name = name;
        this._size = size;
        this.clearCacheImpl();
        this._loader = loader;
    }

    private void clearCacheImpl() {
        this._cacheImlp = new ConcurrentLinkedHashMap(ConcurrentLinkedHashMap.EvictionPolicy.SECOND_CHANCE, this._size, new ConcurrentLinkedHashMap.EvictionListener[0]);
    }

    public V evict(K key) {
        return this._cacheImlp.remove(key);
    }

    public V put(K key, V value) {
        return this._cacheImlp.put(key, value);
    }

    public V get(K key) {
        V value = this._cacheImlp.get(key);
        this._requests.incrementAndGet();
        if (value == null) {
            value = this._loader.load(key);
            this._cacheImlp.put(key, value);
            this._misses.incrementAndGet();
        } else {
            this._hits.incrementAndGet();
        }
        return value;
    }

    public Iterable<V> getCachedValues() {
        return this._cacheImlp.values();
    }

    public int getConfiguredSize() {
        return this._size;
    }

    public int getUtilizedSize() {
        return this._cacheImlp.size();
    }

    public int getRequests() {
        return this._requests.get();
    }

    public int getMisses() {
        return this._misses.get();
    }

    public int getHits() {
        return this._hits.get();
    }

    public double getHitRate() {
        int requests = this.getRequests();
        int hits = this.getHits();
        if (requests == 0) {
            return 0.0;
        }
        return (double)hits / (double)requests;
    }

    public synchronized Cache<K, V> logEveryNSeconds(int seconds, final ILogger logger) {
        if (this._loggingTask != null) {
            throw new IllegalStateException("Logging for " + this + " is already enabled");
        }
        ScheduledExecutorService service = Executors.newScheduledThreadPool(1);
        this._loggingTask = service.scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                logger.info(Cache.this);
            }
        }, seconds, seconds, TimeUnit.SECONDS);
        return this;
    }

    public synchronized void stopLogging() {
        if (this._loggingTask != null) {
            this._loggingTask.cancel(false);
        }
    }

    public void clear() {
        this.clearCacheImpl();
        this._hits.set(0);
        this._misses.set(0);
        this._requests.set(0);
    }

    public String toString() {
        return "Cache \"" + this._name + "\"( Hits:" + this.getHits() + ", Misses:" + this.getMisses() + ", Requests:" + this.getRequests() + ", Hit rate:" + BigDecimal.valueOf(this.getHitRate() * 100.0).setScale(2, 1) + "% )";
    }

    public static <K, V> Cache<K, V> make(String name, int size, Loader<K, V> handler) {
        return new Cache<K, V>(name, size, handler);
    }

    static class ConcurrentLinkedHashMap<K, V>
    extends AbstractMap<K, V>
    implements ConcurrentMap<K, V>,
    Serializable {
        private static final long serialVersionUID = 8350170357874293408L;
        final List<EvictionListener<K, V>> listeners;
        final ConcurrentMap<K, Node<K, V>> data;
        final AtomicInteger capacity;
        final EvictionPolicy policy;
        final AtomicInteger length;
        final Node<K, V> head;
        final Node<K, V> tail;

        public ConcurrentLinkedHashMap(EvictionPolicy policy, int maximumCapacity, EvictionListener<K, V> ... listeners) {
            this(policy, maximumCapacity, 16, listeners);
        }

        public ConcurrentLinkedHashMap(EvictionPolicy policy, int maximumCapacity, int concurrencyLevel, EvictionListener<K, V> ... listeners) {
            if (policy == null || maximumCapacity < 0 || concurrencyLevel <= 0) {
                throw new IllegalArgumentException();
            }
            this.listeners = listeners == null ? Collections.emptyList() : Arrays.asList(listeners);
            this.data = new ConcurrentHashMap<K, Node<K, V>>(maximumCapacity, 0.75f, concurrencyLevel);
            this.capacity = new AtomicInteger(maximumCapacity);
            this.length = new AtomicInteger();
            this.head = new Node();
            this.tail = new Node();
            this.policy = policy;
            this.head.setPrev(this.head);
            this.head.setNext(this.tail);
            this.tail.setPrev(this.head);
            this.tail.setNext(this.tail);
        }

        private boolean isOverflow() {
            return this.length.get() > this.capacity();
        }

        public void setCapacity(int capacity) {
            if (capacity < 0) {
                throw new IllegalArgumentException();
            }
            this.capacity.set(capacity);
            while (this.isOverflow()) {
                this.evict();
            }
        }

        public int capacity() {
            return this.capacity.get();
        }

        @Override
        public int size() {
            return this.data.size();
        }

        @Override
        public void clear() {
            for (Object key : this.keySet()) {
                this.remove(key);
            }
        }

        @Override
        public boolean containsKey(Object key) {
            return this.data.containsKey(key);
        }

        @Override
        public boolean containsValue(Object value) {
            return this.data.containsValue(new Node<Object, Object>(null, value));
        }

        private void evict() {
            while (this.isOverflow()) {
                Node<K, V> node = this.poll();
                if (node == null) {
                    return;
                }
                if (this.policy.onEvict(this, node)) {
                    V value = node.getValue();
                    if (value != null) {
                        K key = node.getKey();
                        this.data.remove(key);
                        this.notifyEviction(key, value);
                    }
                    this.length.decrementAndGet();
                    return;
                }
                this.offer(node);
            }
        }

        private void notifyEviction(K key, V value) {
            for (int i = 0; i < this.listeners.size(); ++i) {
                EvictionListener<K, V> listener = this.listeners.get(i);
                listener.onEviction(key, value);
            }
        }

        private Node<K, V> poll() {
            Node.State state;
            Node<K, V> node;
            while (!this.head.casNext(node = this.head.getNext(), node.getNext())) {
            }
            do {
                if (!node.casState(Node.State.LINKED, Node.State.UNLINKING)) continue;
                node.getNext().setPrev(this.head);
                node.setState(Node.State.UNLINKED);
                return node;
            } while ((state = node.getState()) != Node.State.SENTINEL);
            return null;
        }

        private void offer(Node<K, V> node) {
            Node<K, V> prev;
            node.setState(Node.State.LINKING);
            node.setNext(this.tail);
            do {
                prev = this.tail.getPrev();
                node.setPrev(prev);
            } while (!prev.casNext(this.tail, node));
            Node<K, V> next = this.tail;
            while (true) {
                if (next.casPrev(prev, node)) {
                    node.setState(Node.State.LINKED);
                    return;
                }
                next = next.getPrev();
            }
        }

        private Node<K, V> putIfAbsent(Node<K, V> node) {
            Node<K, V> old = this.data.putIfAbsent(node.getKey(), node);
            if (old == null) {
                this.length.incrementAndGet();
                this.offer(node);
                this.evict();
            }
            return old;
        }

        @Override
        public V get(Object key) {
            Node node = (Node)this.data.get(key);
            if (node != null) {
                Object value = node.getValue();
                this.policy.onGet(this, node);
                return value;
            }
            return null;
        }

        @Override
        public V put(K key, V value) {
            if (value == null) {
                throw new IllegalArgumentException();
            }
            Node<K, V> old = this.putIfAbsent(new Node<K, V>(key, value));
            return old == null ? null : (V)old.getAndSetValue(value);
        }

        @Override
        public V putIfAbsent(K key, V value) {
            if (value == null) {
                throw new IllegalArgumentException();
            }
            Node<K, V> old = this.putIfAbsent(new Node<K, V>(key, value));
            return old == null ? null : (V)old.getValue();
        }

        @Override
        public V remove(Object key) {
            Node node = (Node)this.data.remove(key);
            if (node != null) {
                Object value = node.getValue();
                this.policy.onRemove(this, node);
                return value;
            }
            return null;
        }

        @Override
        public boolean remove(Object key, Object value) {
            Node node = (Node)this.data.get(key);
            if (node != null && node.value.equals(value) && this.data.remove(key, node)) {
                this.policy.onRemove(this, node);
                return true;
            }
            return false;
        }

        @Override
        public V replace(K key, V value) {
            if (value == null) {
                throw new IllegalArgumentException();
            }
            Node node = (Node)this.data.get(key);
            return node == null ? null : (V)node.getAndSetValue(value);
        }

        @Override
        public boolean replace(K key, V oldValue, V newValue) {
            if (newValue == null) {
                throw new IllegalArgumentException();
            }
            Node node = (Node)this.data.get(key);
            return node != null && node.casValue(oldValue, newValue);
        }

        @Override
        public Set<Map.Entry<K, V>> entrySet() {
            return new EntrySetAdapter();
        }

        private static final class SimpleEntry<K, V>
        implements Map.Entry<K, V> {
            private final K key;
            private V value;

            public SimpleEntry(K key, V value) {
                this.key = key;
                this.value = value;
            }

            @Override
            public K getKey() {
                return this.key;
            }

            @Override
            public V getValue() {
                return this.value;
            }

            @Override
            public V setValue(V value) {
                V oldValue = this.value;
                this.value = value;
                return oldValue;
            }

            @Override
            public boolean equals(Object obj) {
                if (obj == this) {
                    return true;
                }
                if (!(obj instanceof Map.Entry)) {
                    return false;
                }
                Map.Entry entry = (Map.Entry)obj;
                return SimpleEntry.eq(this.key, entry.getKey()) && SimpleEntry.eq(this.value, entry.getValue());
            }

            @Override
            public int hashCode() {
                return (this.key == null ? 0 : this.key.hashCode()) ^ (this.value == null ? 0 : this.value.hashCode());
            }

            public String toString() {
                return this.key + "=" + this.value;
            }

            private static boolean eq(Object o1, Object o2) {
                return o1 == null ? o2 == null : o1.equals(o2);
            }
        }

        private final class EntryIteratorAdapter
        implements Iterator<Map.Entry<K, V>> {
            private final Iterator<Map.Entry<K, Node<K, V>>> iterator;
            private Map.Entry<K, Node<K, V>> current;

            public EntryIteratorAdapter(Iterator<Map.Entry<K, Node<K, V>>> iterator) {
                this.iterator = iterator;
            }

            @Override
            public boolean hasNext() {
                return this.iterator.hasNext();
            }

            @Override
            public Map.Entry<K, V> next() {
                this.current = this.iterator.next();
                Object key = this.current.getKey();
                Node node = this.current.getValue();
                Object value = node == null ? null : (Object)node.getValue();
                return new SimpleEntry(key, value);
            }

            @Override
            public void remove() {
                if (this.current == null) {
                    throw new IllegalStateException();
                }
                ConcurrentLinkedHashMap.this.remove(this.current.getKey(), this.current.getValue());
                this.current = null;
            }
        }

        private final class EntrySetAdapter
        extends AbstractSet<Map.Entry<K, V>> {
            private final ConcurrentLinkedHashMap<K, V> map;

            private EntrySetAdapter() {
                this.map = ConcurrentLinkedHashMap.this;
            }

            @Override
            public void clear() {
                this.map.clear();
            }

            @Override
            public int size() {
                return this.map.size();
            }

            @Override
            public Iterator<Map.Entry<K, V>> iterator() {
                return new EntryIteratorAdapter(this.map.data.entrySet().iterator());
            }

            @Override
            public boolean contains(Object obj) {
                if (!(obj instanceof Map.Entry)) {
                    return false;
                }
                Map.Entry entry = (Map.Entry)obj;
                Node node = (Node)this.map.data.get(entry.getKey());
                return node != null && node.value.equals(entry.getValue());
            }

            @Override
            public boolean add(Map.Entry<K, V> entry) {
                return this.map.putIfAbsent(entry.getKey(), entry.getValue()) == null;
            }

            @Override
            public boolean remove(Object obj) {
                if (!(obj instanceof Map.Entry)) {
                    return false;
                }
                Map.Entry entry = (Map.Entry)obj;
                return this.map.remove(entry.getKey(), entry.getValue());
            }
        }

        static final class Node<K, V>
        implements Serializable {
            private static final long serialVersionUID = 1461281468985304519L;
            private static final AtomicReferenceFieldUpdater<Node, Object> valueUpdater = AtomicReferenceFieldUpdater.newUpdater(Node.class, Object.class, "value");
            private static final AtomicReferenceFieldUpdater<Node, State> stateUpdater = AtomicReferenceFieldUpdater.newUpdater(Node.class, State.class, "state");
            private static final AtomicReferenceFieldUpdater<Node, Node> prevUpdater = AtomicReferenceFieldUpdater.newUpdater(Node.class, Node.class, "prev");
            private static final AtomicReferenceFieldUpdater<Node, Node> nextUpdater = AtomicReferenceFieldUpdater.newUpdater(Node.class, Node.class, "next");
            private final K key;
            private volatile V value;
            private volatile State state;
            private volatile boolean marked;
            private volatile Node<K, V> prev = null;
            private volatile Node<K, V> next = null;

            public Node() {
                this.key = null;
                this.state = State.SENTINEL;
            }

            public Node(K key, V value) {
                this.key = key;
                this.value = value;
                this.state = State.UNLINKED;
            }

            public K getKey() {
                return this.key;
            }

            public V getValue() {
                return this.value;
            }

            public void setValue(V value) {
                valueUpdater.set(this, value);
            }

            public V getAndSetValue(V value) {
                return (V)valueUpdater.getAndSet(this, value);
            }

            public boolean casValue(V expect, V update) {
                return valueUpdater.compareAndSet(this, expect, update);
            }

            public Node<K, V> getPrev() {
                return this.prev;
            }

            public void setPrev(Node<K, V> node) {
                prevUpdater.set(this, node);
            }

            public boolean casPrev(Node<K, V> expect, Node<K, V> update) {
                return prevUpdater.compareAndSet(this, expect, update);
            }

            public Node<K, V> getNext() {
                return this.next;
            }

            public void setNext(Node<K, V> node) {
                nextUpdater.set(this, node);
            }

            public boolean casNext(Node<K, V> expect, Node<K, V> update) {
                return nextUpdater.compareAndSet(this, expect, update);
            }

            public boolean isMarked() {
                return this.marked;
            }

            public void setMarked(boolean marked) {
                this.marked = marked;
            }

            public State getState() {
                return this.state;
            }

            public void setState(State state) {
                stateUpdater.set(this, state);
            }

            public boolean casState(State expect, State update) {
                return stateUpdater.compareAndSet(this, expect, update);
            }

            public boolean equals(Object obj) {
                if (obj == this) {
                    return true;
                }
                if (!(obj instanceof Node)) {
                    return false;
                }
                V value = this.getValue();
                Node node = (Node)obj;
                return value == null ? node.getValue() == null : value.equals(node.getValue());
            }

            public int hashCode() {
                return (this.key == null ? 0 : this.key.hashCode()) ^ (this.value == null ? 0 : this.value.hashCode());
            }

            public String toString() {
                return String.format("Node[state=%s, marked=%b, key=%s, value=%s]", new Object[]{this.getState(), this.isMarked(), this.getKey(), this.getValue()});
            }

            public static enum State {
                SENTINEL,
                UNLINKED,
                UNLINKING,
                LINKING,
                LINKED;

            }
        }

        public static enum EvictionPolicy {
            FIFO{

                @Override
                <K, V> void onGet(ConcurrentLinkedHashMap<K, V> map, Node<K, V> node) {
                }

                @Override
                <K, V> boolean onEvict(ConcurrentLinkedHashMap<K, V> map, Node<K, V> node) {
                    return true;
                }
            }
            ,
            SECOND_CHANCE{

                @Override
                <K, V> void onGet(ConcurrentLinkedHashMap<K, V> map, Node<K, V> node) {
                    node.setMarked(true);
                }

                @Override
                <K, V> void onRemove(ConcurrentLinkedHashMap<K, V> map, Node<K, V> node) {
                    super.onRemove(map, node);
                    node.setMarked(false);
                }

                @Override
                <K, V> boolean onEvict(ConcurrentLinkedHashMap<K, V> map, Node<K, V> node) {
                    if (node.isMarked()) {
                        node.setMarked(false);
                        return false;
                    }
                    return true;
                }
            }
            ,
            LRU{

                @Override
                <K, V> void onGet(ConcurrentLinkedHashMap<K, V> map, Node<K, V> node) {
                    Node<K, V> newNode = new Node<K, V>(node.getKey(), node.getValue());
                    if (map.data.replace(node.getKey(), node, newNode)) {
                        map.length.incrementAndGet();
                        this.onRemove(map, node);
                        ((ConcurrentLinkedHashMap)map).offer(newNode);
                        ((ConcurrentLinkedHashMap)map).evict();
                    }
                }

                @Override
                <K, V> boolean onEvict(ConcurrentLinkedHashMap<K, V> map, Node<K, V> node) {
                    return true;
                }
            };


            abstract <K, V> void onGet(ConcurrentLinkedHashMap<K, V> var1, Node<K, V> var2);

            <K, V> void onRemove(ConcurrentLinkedHashMap<K, V> map, Node<K, V> node) {
                node.setValue(null);
            }

            abstract <K, V> boolean onEvict(ConcurrentLinkedHashMap<K, V> var1, Node<K, V> var2);
        }

        public static interface EvictionListener<K, V> {
            public void onEviction(K var1, V var2);
        }
    }

    public static interface Loader<L, W> {
        public W load(L var1);
    }
}

