/*
 * Decompiled with CFR 0.152.
 */
package com.volmit.adapt.util.manifold.util.concurrent;

public abstract class LocklessLazyVar<T> {
    protected static final Object NULL = new Object();
    private volatile T _val = null;

    public T get() {
        T result = this._val;
        if (result == NULL) {
            return null;
        }
        if (result == null) {
            result = this.init();
            this._val = result == null ? NULL : result;
        }
        return result;
    }

    public T set(T value) {
        T prev = this.get();
        this._val = value == null ? NULL : value;
        return prev;
    }

    protected abstract T init();

    public final T clear() {
        T prev = this._val;
        this._val = null;
        return prev;
    }

    public boolean isLoaded() {
        return this._val != null;
    }

    public static <Q> LocklessLazyVar<Q> make(final LazyVarInit<Q> closure) {
        return new LocklessLazyVar<Q>(){

            @Override
            protected Q init() {
                return closure.init();
            }
        };
    }

    public static interface LazyVarInit<Q> {
        public Q init();
    }
}

