/*
 * Decompiled with CFR 0.152.
 */
package ru.abstractmenus;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.logging.Level;
import java.util.zip.GZIPOutputStream;
import javax.net.ssl.HttpsURLConnection;
import org.bukkit.Bukkit;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.RegisteredServiceProvider;
import org.bukkit.plugin.ServicePriority;

public class Metrics {
    public static final int B_STATS_VERSION = 1;
    private static final String URL = "https://bStats.org/submitData/bukkit";
    private boolean enabled;
    private static boolean logFailedRequests;
    private static boolean logSentData;
    private static boolean logResponseStatusText;
    private static String serverUUID;
    private final Plugin plugin;
    private final List<CustomChart> charts = new ArrayList<CustomChart>();

    public Metrics(Plugin plugin) {
        if (plugin == null) {
            throw new IllegalArgumentException("Plugin cannot be null!");
        }
        this.plugin = plugin;
        File file = new File(plugin.getDataFolder().getParentFile(), "bStats");
        YamlConfiguration yamlConfiguration = YamlConfiguration.loadConfiguration((File)(file = new File(file, "config.yml")));
        if (!yamlConfiguration.isSet("serverUuid")) {
            yamlConfiguration.addDefault("enabled", (Object)Boolean.TRUE);
            yamlConfiguration.addDefault("serverUuid", (Object)UUID.randomUUID().toString());
            yamlConfiguration.addDefault("logFailedRequests", (Object)Boolean.FALSE);
            yamlConfiguration.addDefault("logSentData", (Object)Boolean.FALSE);
            yamlConfiguration.addDefault("logResponseStatusText", (Object)Boolean.FALSE);
            yamlConfiguration.options().header("bStats collects some data for plugin authors like how many servers are using their plugins.\nTo honor their work, you should not disable it.\nThis has nearly no effect on the server performance!\nCheck out https://bStats.org/ to learn more :)").copyDefaults(true);
            try {
                yamlConfiguration.save(file);
            }
            catch (IOException iOException) {}
        }
        this.enabled = yamlConfiguration.getBoolean("enabled", true);
        serverUUID = yamlConfiguration.getString("serverUuid");
        logFailedRequests = yamlConfiguration.getBoolean("logFailedRequests", false);
        logSentData = yamlConfiguration.getBoolean("logSentData", false);
        logResponseStatusText = yamlConfiguration.getBoolean("logResponseStatusText", false);
        if (this.enabled) {
            boolean bl = false;
            for (Class clazz : Bukkit.getServicesManager().getKnownServices()) {
                try {
                    clazz.getField("B_STATS_VERSION");
                    bl = true;
                    break;
                }
                catch (NoSuchFieldException noSuchFieldException) {
                }
            }
            Bukkit.getServicesManager().register(Metrics.class, (Object)this, plugin, ServicePriority.Normal);
            if (!bl) {
                this.startSubmitting();
            }
        }
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void addCustomChart(CustomChart customChart) {
        if (customChart == null) {
            throw new IllegalArgumentException("Chart cannot be null!");
        }
        this.charts.add(customChart);
    }

    private void startSubmitting() {
        final Timer timer = new Timer(true);
        timer.scheduleAtFixedRate(new TimerTask(){

            @Override
            public void run() {
                if (!Metrics.this.plugin.isEnabled()) {
                    timer.cancel();
                    return;
                }
                Bukkit.getScheduler().runTask(Metrics.this.plugin, () -> Metrics.this.submitData());
            }
        }, 300000L, 1800000L);
    }

    public JsonObject getPluginData() {
        JsonObject jsonObject = new JsonObject();
        String string = this.plugin.getDescription().getName();
        String string2 = this.plugin.getDescription().getVersion();
        jsonObject.addProperty("pluginName", string);
        jsonObject.addProperty("pluginVersion", string2);
        string = new JsonArray();
        for (CustomChart customChart : this.charts) {
            if ((customChart = customChart.getRequestJsonObject()) == null) continue;
            string.add((JsonElement)customChart);
        }
        jsonObject.add("customCharts", (JsonElement)string);
        return jsonObject;
    }

    private JsonObject getServerData() {
        int n2;
        try {
            Method method = Class.forName("org.bukkit.Server").getMethod("getOnlinePlayers", new Class[0]);
            n2 = method.getReturnType().equals(Collection.class) ? ((Collection)method.invoke((Object)Bukkit.getServer(), new Object[0])).size() : ((Player[])method.invoke((Object)Bukkit.getServer(), new Object[0])).length;
        }
        catch (Exception exception) {
            n2 = Bukkit.getOnlinePlayers().size();
        }
        int n3 = Bukkit.getOnlineMode() ? 1 : 0;
        String string = Bukkit.getVersion();
        String string2 = Bukkit.getName();
        String string3 = System.getProperty("java.version");
        String string4 = System.getProperty("os.name");
        String string5 = System.getProperty("os.arch");
        String string6 = System.getProperty("os.version");
        int n4 = Runtime.getRuntime().availableProcessors();
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("serverUUID", serverUUID);
        jsonObject.addProperty("playerAmount", (Number)n2);
        jsonObject.addProperty("onlineMode", (Number)n3);
        jsonObject.addProperty("bukkitVersion", string);
        jsonObject.addProperty("bukkitName", string2);
        jsonObject.addProperty("javaVersion", string3);
        jsonObject.addProperty("osName", string4);
        jsonObject.addProperty("osArch", string5);
        jsonObject.addProperty("osVersion", string6);
        jsonObject.addProperty("coreCount", (Number)n4);
        return jsonObject;
    }

    private void submitData() {
        JsonObject jsonObject = this.getServerData();
        JsonArray jsonArray = new JsonArray();
        for (Object object : Bukkit.getServicesManager().getKnownServices()) {
            try {
                ((Class)object).getField("B_STATS_VERSION");
                object = Bukkit.getServicesManager().getRegistrations((Class)object).iterator();
                while (object.hasNext()) {
                    Object object2 = (RegisteredServiceProvider)object.next();
                    try {
                        object2 = object2.getService().getMethod("getPluginData", new Class[0]).invoke(object2.getProvider(), new Object[0]);
                        if (object2 instanceof JsonObject) {
                            jsonArray.add((JsonElement)((JsonObject)object2));
                            continue;
                        }
                        try {
                            GenericDeclaration genericDeclaration = Class.forName("org.json.simple.JSONObject");
                            if (!object2.getClass().isAssignableFrom((Class<?>)genericDeclaration)) continue;
                            genericDeclaration = ((Class)genericDeclaration).getDeclaredMethod("toJSONString", new Class[0]);
                            ((Method)genericDeclaration).setAccessible(true);
                            object2 = (String)((Method)genericDeclaration).invoke(object2, new Object[0]);
                            object2 = new JsonParser().parse((String)object2).getAsJsonObject();
                            jsonArray.add((JsonElement)object2);
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            if (!logFailedRequests) continue;
                            this.plugin.getLogger().log(Level.SEVERE, "Encountered unexpected exception", classNotFoundException);
                        }
                    }
                    catch (IllegalAccessException | NoSuchMethodException | NullPointerException | InvocationTargetException exception) {}
                }
            }
            catch (NoSuchFieldException noSuchFieldException) {
            }
        }
        jsonObject.add("plugins", (JsonElement)jsonArray);
        new Thread(() -> {
            try {
                Metrics.sendData(this.plugin, jsonObject);
                return;
            }
            catch (Exception exception) {
                if (logFailedRequests) {
                    this.plugin.getLogger().log(Level.WARNING, "Could not submit plugin stats of " + this.plugin.getName(), exception);
                }
                return;
            }
        }).start();
    }

    private static void sendData(Plugin plugin, JsonObject object) throws Exception {
        if (object == null) {
            throw new IllegalArgumentException("Data cannot be null!");
        }
        if (Bukkit.isPrimaryThread()) {
            throw new IllegalAccessException("This method must not be called from the main thread!");
        }
        if (logSentData) {
            plugin.getLogger().info("Sending data to bStats: " + object);
        }
        Object object2 = (HttpsURLConnection)new URL(URL).openConnection();
        object = Metrics.compress(object.toString());
        ((HttpURLConnection)object2).setRequestMethod("POST");
        ((URLConnection)object2).addRequestProperty("Accept", "application/json");
        ((URLConnection)object2).addRequestProperty("Connection", "close");
        ((URLConnection)object2).addRequestProperty("Content-Encoding", "gzip");
        ((URLConnection)object2).addRequestProperty("Content-Length", String.valueOf(((JsonObject)object).length));
        ((URLConnection)object2).setRequestProperty("Content-Type", "application/json");
        ((URLConnection)object2).setRequestProperty("User-Agent", "MC-Server/1");
        ((URLConnection)object2).setDoOutput(true);
        Object object3 = new DataOutputStream(((URLConnection)object2).getOutputStream());
        Object object4 = null;
        try {
            ((FilterOutputStream)object3).write((byte[])object);
        }
        catch (Throwable throwable) {
            object = throwable;
            object4 = throwable;
            throw object;
        }
        finally {
            if (object4 != null) {
                try {
                    ((FilterOutputStream)object3).close();
                }
                catch (Throwable throwable) {
                    ((Throwable)object4).addSuppressed(throwable);
                }
            } else {
                ((FilterOutputStream)object3).close();
            }
        }
        object3 = new StringBuilder();
        object4 = new BufferedReader(new InputStreamReader(((URLConnection)object2).getInputStream()));
        object = null;
        try {
            while ((object2 = ((BufferedReader)object4).readLine()) != null) {
                ((StringBuilder)object3).append((String)object2);
            }
        }
        catch (Throwable throwable) {
            object2 = throwable;
            object = throwable;
            throw object2;
        }
        finally {
            if (object != null) {
                try {
                    ((BufferedReader)object4).close();
                }
                catch (Throwable throwable) {
                    ((Throwable)object).addSuppressed(throwable);
                }
            } else {
                ((BufferedReader)object4).close();
            }
        }
        if (logResponseStatusText) {
            plugin.getLogger().info("Sent data to bStats and received response: " + object3);
        }
    }

    private static byte[] compress(String object) throws IOException {
        if (object == null) {
            return null;
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        Throwable throwable = null;
        try (GZIPOutputStream gZIPOutputStream = new GZIPOutputStream(byteArrayOutputStream);){
            gZIPOutputStream.write(((String)object).getBytes(StandardCharsets.UTF_8));
        }
        catch (Throwable throwable2) {
            object = throwable2;
            throwable = throwable2;
            throw object;
        }
        return byteArrayOutputStream.toByteArray();
    }

    static {
        if (System.getProperty("bstats.relocatecheck") == null || !System.getProperty("bstats.relocatecheck").equals("false")) {
            String string = new String(new byte[]{111, 114, 103, 46, 98, 115, 116, 97, 116, 115, 46, 98, 117, 107, 107, 105, 116});
            String string2 = new String(new byte[]{121, 111, 117, 114, 46, 112, 97, 99, 107, 97, 103, 101});
            if (Metrics.class.getPackage().getName().equals(string) || Metrics.class.getPackage().getName().equals(string2)) {
                throw new IllegalStateException("bStats Metrics class has not been relocated correctly!");
            }
        }
    }

    public static class AdvancedBarChart
    extends CustomChart {
        private final Callable<Map<String, int[]>> callable;

        public AdvancedBarChart(String string, Callable<Map<String, int[]>> callable) {
            super(string);
            this.callable = callable;
        }

        @Override
        protected JsonObject getChartData() throws Exception {
            JsonObject jsonObject = new JsonObject();
            JsonObject jsonObject2 = new JsonObject();
            Map<String, int[]> map = this.callable.call();
            if (map == null || map.isEmpty()) {
                return null;
            }
            boolean bl = true;
            for (Map.Entry entry : map.entrySet()) {
                if (((int[])entry.getValue()).length == 0) continue;
                bl = false;
                JsonArray jsonArray = new JsonArray();
                for (int n2 : (int[])entry.getValue()) {
                    jsonArray.add((JsonElement)new JsonPrimitive((Number)n2));
                }
                jsonObject2.add((String)entry.getKey(), (JsonElement)jsonArray);
            }
            if (bl) {
                return null;
            }
            jsonObject.add("values", (JsonElement)jsonObject2);
            return jsonObject;
        }
    }

    public static class SimpleBarChart
    extends CustomChart {
        private final Callable<Map<String, Integer>> callable;

        public SimpleBarChart(String string, Callable<Map<String, Integer>> callable) {
            super(string);
            this.callable = callable;
        }

        @Override
        protected JsonObject getChartData() throws Exception {
            JsonObject jsonObject = new JsonObject();
            JsonObject jsonObject2 = new JsonObject();
            Map<String, Integer> map = this.callable.call();
            if (map == null || map.isEmpty()) {
                return null;
            }
            for (Map.Entry entry : map.entrySet()) {
                JsonArray jsonArray = new JsonArray();
                jsonArray.add((JsonElement)new JsonPrimitive((Number)entry.getValue()));
                jsonObject2.add((String)entry.getKey(), (JsonElement)jsonArray);
            }
            jsonObject.add("values", (JsonElement)jsonObject2);
            return jsonObject;
        }
    }

    public static class MultiLineChart
    extends CustomChart {
        private final Callable<Map<String, Integer>> callable;

        public MultiLineChart(String string, Callable<Map<String, Integer>> callable) {
            super(string);
            this.callable = callable;
        }

        @Override
        protected JsonObject getChartData() throws Exception {
            JsonObject jsonObject = new JsonObject();
            JsonObject jsonObject2 = new JsonObject();
            Map<String, Integer> map = this.callable.call();
            if (map == null || map.isEmpty()) {
                return null;
            }
            boolean bl = true;
            for (Map.Entry entry : map.entrySet()) {
                if ((Integer)entry.getValue() == 0) continue;
                bl = false;
                jsonObject2.addProperty((String)entry.getKey(), (Number)entry.getValue());
            }
            if (bl) {
                return null;
            }
            jsonObject.add("values", (JsonElement)jsonObject2);
            return jsonObject;
        }
    }

    public static class SingleLineChart
    extends CustomChart {
        private final Callable<Integer> callable;

        public SingleLineChart(String string, Callable<Integer> callable) {
            super(string);
            this.callable = callable;
        }

        @Override
        protected JsonObject getChartData() throws Exception {
            JsonObject jsonObject = new JsonObject();
            int n2 = this.callable.call();
            if (n2 == 0) {
                return null;
            }
            jsonObject.addProperty("value", (Number)n2);
            return jsonObject;
        }
    }

    public static class DrilldownPie
    extends CustomChart {
        private final Callable<Map<String, Map<String, Integer>>> callable;

        public DrilldownPie(String string, Callable<Map<String, Map<String, Integer>>> callable) {
            super(string);
            this.callable = callable;
        }

        @Override
        public JsonObject getChartData() throws Exception {
            JsonObject jsonObject = new JsonObject();
            JsonObject jsonObject2 = new JsonObject();
            Map<String, Map<String, Integer>> map = this.callable.call();
            if (map == null || map.isEmpty()) {
                return null;
            }
            boolean bl = true;
            for (Map.Entry<String, Map<String, Integer>> entry : map.entrySet()) {
                JsonObject jsonObject3 = new JsonObject();
                boolean bl2 = true;
                for (Map.Entry<String, Integer> entry2 : map.get(entry.getKey()).entrySet()) {
                    jsonObject3.addProperty(entry2.getKey(), (Number)entry2.getValue());
                    bl2 = false;
                }
                if (bl2) continue;
                bl = false;
                jsonObject2.add(entry.getKey(), (JsonElement)jsonObject3);
            }
            if (bl) {
                return null;
            }
            jsonObject.add("values", (JsonElement)jsonObject2);
            return jsonObject;
        }
    }

    public static class AdvancedPie
    extends CustomChart {
        private final Callable<Map<String, Integer>> callable;

        public AdvancedPie(String string, Callable<Map<String, Integer>> callable) {
            super(string);
            this.callable = callable;
        }

        @Override
        protected JsonObject getChartData() throws Exception {
            JsonObject jsonObject = new JsonObject();
            JsonObject jsonObject2 = new JsonObject();
            Map<String, Integer> map = this.callable.call();
            if (map == null || map.isEmpty()) {
                return null;
            }
            boolean bl = true;
            for (Map.Entry entry : map.entrySet()) {
                if ((Integer)entry.getValue() == 0) continue;
                bl = false;
                jsonObject2.addProperty((String)entry.getKey(), (Number)entry.getValue());
            }
            if (bl) {
                return null;
            }
            jsonObject.add("values", (JsonElement)jsonObject2);
            return jsonObject;
        }
    }

    public static class SimplePie
    extends CustomChart {
        private final Callable<String> callable;

        public SimplePie(String string, Callable<String> callable) {
            super(string);
            this.callable = callable;
        }

        @Override
        protected JsonObject getChartData() throws Exception {
            JsonObject jsonObject = new JsonObject();
            String string = this.callable.call();
            if (string == null || string.isEmpty()) {
                return null;
            }
            jsonObject.addProperty("value", string);
            return jsonObject;
        }
    }

    public static abstract class CustomChart {
        final String chartId;

        CustomChart(String string) {
            if (string == null || string.isEmpty()) {
                throw new IllegalArgumentException("ChartId cannot be null or empty!");
            }
            this.chartId = string;
        }

        private JsonObject getRequestJsonObject() {
            JsonObject jsonObject = new JsonObject();
            jsonObject.addProperty("chartId", this.chartId);
            try {
                JsonObject jsonObject2 = this.getChartData();
                if (jsonObject2 == null) {
                    return null;
                }
                jsonObject.add("data", (JsonElement)jsonObject2);
            }
            catch (Throwable throwable) {
                if (logFailedRequests) {
                    Bukkit.getLogger().log(Level.WARNING, "Failed to get data for custom chart with id " + this.chartId, throwable);
                }
                return null;
            }
            return jsonObject;
        }

        protected abstract JsonObject getChartData() throws Exception;
    }
}

