/*
 * Decompiled with CFR 0.152.
 */
package ru.abstractmenus.api;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import ru.abstractmenus.api.Action;
import ru.abstractmenus.api.Activator;
import ru.abstractmenus.api.Catalog;
import ru.abstractmenus.api.Rule;
import ru.abstractmenus.api.inventory.ItemProperty;
import ru.abstractmenus.hocon.api.serialize.NodeSerializer;
import ru.abstractmenus.hocon.api.serialize.NodeSerializers;

public final class Types {
    private static final NodeSerializers SERIALIZERS = NodeSerializers.defaults();
    private static final BiMap<String, Class<? extends Action>> ACTION_TYPES = HashBiMap.create();
    private static final BiMap<String, Class<? extends Rule>> RULE_TYPES = HashBiMap.create();
    private static final BiMap<String, Class<? extends Activator>> ACTIVATOR_TYPES = HashBiMap.create();
    private static final BiMap<String, Class<? extends ItemProperty>> ITEM_PROPERTIES_TYPES = HashBiMap.create();
    private static final BiMap<String, Class<? extends Catalog<?>>> CATALOG_TYPES = HashBiMap.create();

    private Types() {
    }

    public static NodeSerializers serializers() {
        return SERIALIZERS;
    }

    public static String getActionName(Class<? extends Action> clazz) {
        return (String)ACTION_TYPES.inverse().get(clazz);
    }

    public static String getRuleName(Class<? extends Rule> clazz) {
        return (String)RULE_TYPES.inverse().get(clazz);
    }

    public static String getActivatorName(Class<? extends Activator> clazz) {
        return (String)ACTIVATOR_TYPES.inverse().get(clazz);
    }

    public static String getItemPropertyName(Class<? extends ItemProperty> clazz) {
        return (String)ITEM_PROPERTIES_TYPES.inverse().get(clazz);
    }

    public static String getCatalogName(Class<? extends Catalog> clazz) {
        return (String)CATALOG_TYPES.inverse().get(clazz);
    }

    public static <T extends Action> void registerAction(String string, Class<T> clazz, NodeSerializer<T> nodeSerializer) {
        Types.serializers().register(clazz, nodeSerializer);
        ACTION_TYPES.put((Object)string.toLowerCase(), clazz);
    }

    public static Class<? extends Action> getActionType(String string) {
        return (Class)ACTION_TYPES.get((Object)string.toLowerCase());
    }

    public static <T extends Rule> void registerRule(String string, Class<T> clazz, NodeSerializer<T> nodeSerializer) {
        Types.serializers().register(clazz, nodeSerializer);
        RULE_TYPES.put((Object)string.toLowerCase(), clazz);
    }

    public static Class<? extends Rule> getRuleType(String string) {
        return (Class)RULE_TYPES.get((Object)string.toLowerCase());
    }

    public static <T extends Activator> void registerActivator(String string, Class<T> clazz, NodeSerializer<T> nodeSerializer) {
        Types.serializers().register(clazz, nodeSerializer);
        ACTIVATOR_TYPES.put((Object)string.toLowerCase(), clazz);
    }

    public static Class<? extends Activator> getActivator(String string) {
        return (Class)ACTIVATOR_TYPES.get((Object)string.toLowerCase());
    }

    public static <T extends ItemProperty> void registerItemProperty(String string, Class<T> clazz, NodeSerializer<T> nodeSerializer) {
        Types.serializers().register(clazz, nodeSerializer);
        ITEM_PROPERTIES_TYPES.put((Object)string.toLowerCase(), clazz);
    }

    public static Class<? extends ItemProperty> getItemPropertyType(String string) {
        return (Class)ITEM_PROPERTIES_TYPES.get((Object)string.toLowerCase());
    }

    public static <T extends Catalog<?>> void registerCatalog(String string, Class<T> clazz, NodeSerializer<T> nodeSerializer) {
        Types.serializers().register(clazz, nodeSerializer);
        CATALOG_TYPES.put((Object)string.toLowerCase(), clazz);
    }

    public static Class<? extends Catalog<?>> getCatalogType(String string) {
        return (Class)CATALOG_TYPES.get((Object)string.toLowerCase());
    }
}

