/*
 * Decompiled with CFR 0.152.
 */
package ru.abstractmenus.hocon.api.serialize;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import ru.abstractmenus.hocon.api.serialize.NodeSerializeException;
import ru.abstractmenus.hocon.api.serialize.NodeSerializer;
import ru.abstractmenus.hocon.api.serialize.defaults.BooleanSerializer;
import ru.abstractmenus.hocon.api.serialize.defaults.DoubleSerializer;
import ru.abstractmenus.hocon.api.serialize.defaults.FloatSerializer;
import ru.abstractmenus.hocon.api.serialize.defaults.IntegerSerializer;
import ru.abstractmenus.hocon.api.serialize.defaults.ListSerializer;
import ru.abstractmenus.hocon.api.serialize.defaults.LongSerializer;
import ru.abstractmenus.hocon.api.serialize.defaults.StringSerializer;
import ru.abstractmenus.hocon.api.serialize.defaults.UuidSerializer;

public class NodeSerializers {
    private final Map<Class<?>, NodeSerializer<?>> serializers;

    public NodeSerializers(Map<Class<?>, NodeSerializer<?>> map) {
        this.serializers = map;
    }

    public NodeSerializers() {
        this(new HashMap());
    }

    public <T> NodeSerializer<T> getSerializer(Class<T> clazz) throws NodeSerializeException {
        NodeSerializer<?> nodeSerializer = this.serializers.get(clazz);
        if (nodeSerializer == null) {
            throw new NodeSerializeException("No serializer for type " + clazz.getName());
        }
        return nodeSerializer;
    }

    public <T> NodeSerializers register(Class<T> clazz, NodeSerializer<T> nodeSerializer) {
        this.serializers.put(clazz, nodeSerializer);
        return this;
    }

    public NodeSerializers merge(NodeSerializers nodeSerializers) {
        NodeSerializers nodeSerializers2 = new NodeSerializers();
        nodeSerializers2.serializers.putAll(this.serializers);
        nodeSerializers2.serializers.putAll(nodeSerializers.serializers);
        return nodeSerializers2;
    }

    public static NodeSerializers defaults() {
        HashMap hashMap = new HashMap();
        hashMap.put(Boolean.class, new BooleanSerializer());
        hashMap.put(Integer.class, new IntegerSerializer());
        hashMap.put(Long.class, new LongSerializer());
        hashMap.put(Float.class, new FloatSerializer());
        hashMap.put(Double.class, new DoubleSerializer());
        hashMap.put(String.class, new StringSerializer());
        hashMap.put(UUID.class, new UuidSerializer());
        hashMap.put(List.class, new ListSerializer());
        return new NodeSerializers(hashMap);
    }
}

