/*
 * Decompiled with CFR 0.152.
 */
package ru.abstractmenus.hocon.api.serialize.defaults;

import ru.abstractmenus.hocon.api.ConfigNode;
import ru.abstractmenus.hocon.api.Preconditions;
import ru.abstractmenus.hocon.api.serialize.NodeSerializeException;
import ru.abstractmenus.hocon.api.serialize.NodeSerializer;

public class FloatSerializer
implements NodeSerializer<Float> {
    @Override
    public Float deserialize(Class<Float> object, ConfigNode configNode) throws NodeSerializeException {
        Preconditions.checkNodeNull(configNode);
        object = configNode.rawValue();
        if (object instanceof Float) {
            return (Float)object;
        }
        try {
            return Float.valueOf(Float.parseFloat(object.toString()));
        }
        catch (NumberFormatException numberFormatException) {
            throw new NodeSerializeException(configNode, "Cannot parse float from '" + object + "'");
        }
    }
}

