/*
 * Decompiled with CFR 0.152.
 */
package ru.abstractmenus.hocon.api.serialize.defaults;

import ru.abstractmenus.hocon.api.ConfigNode;
import ru.abstractmenus.hocon.api.Preconditions;
import ru.abstractmenus.hocon.api.serialize.NodeSerializeException;
import ru.abstractmenus.hocon.api.serialize.NodeSerializer;

public class IntegerSerializer
implements NodeSerializer<Integer> {
    @Override
    public Integer deserialize(Class<Integer> object, ConfigNode configNode) throws NodeSerializeException {
        Preconditions.checkNodeNull(configNode);
        object = configNode.rawValue();
        if (object instanceof Integer) {
            return (Integer)object;
        }
        try {
            return Integer.parseInt(object.toString());
        }
        catch (NumberFormatException numberFormatException) {
            throw new NodeSerializeException(configNode, "Cannot parse int from '" + object + "'");
        }
    }
}

