/*
 * Decompiled with CFR 0.152.
 */
package ru.abstractmenus.hocon.api.serialize.defaults;

import ru.abstractmenus.hocon.api.ConfigNode;
import ru.abstractmenus.hocon.api.Preconditions;
import ru.abstractmenus.hocon.api.serialize.NodeSerializeException;
import ru.abstractmenus.hocon.api.serialize.NodeSerializer;

public class LongSerializer
implements NodeSerializer<Long> {
    @Override
    public Long deserialize(Class<Long> object, ConfigNode configNode) throws NodeSerializeException {
        Preconditions.checkNodeNull(configNode);
        object = configNode.rawValue();
        if (object instanceof Long) {
            return (Long)object;
        }
        try {
            return Long.parseLong(object.toString());
        }
        catch (NumberFormatException numberFormatException) {
            throw new NodeSerializeException(configNode, "Cannot parse long from '" + object + "'");
        }
    }
}

