/*
 * Decompiled with CFR 0.152.
 */
package ru.abstractmenus.hocon.api.serialize.defaults;

import java.util.UUID;
import ru.abstractmenus.hocon.api.ConfigNode;
import ru.abstractmenus.hocon.api.Preconditions;
import ru.abstractmenus.hocon.api.serialize.NodeSerializeException;
import ru.abstractmenus.hocon.api.serialize.NodeSerializer;

public class UuidSerializer
implements NodeSerializer<UUID> {
    @Override
    public UUID deserialize(Class<UUID> object, ConfigNode configNode) throws NodeSerializeException {
        Preconditions.checkNodeNull(configNode);
        object = configNode.rawValue();
        if (object instanceof UUID) {
            return (UUID)object;
        }
        try {
            return UUID.fromString(configNode.getString());
        }
        catch (Exception exception) {
            throw new NodeSerializeException(configNode, "Cannot parse UUID: " + exception.getMessage());
        }
    }
}

