/*
 * Decompiled with CFR 0.152.
 */
package com.volmit.adapt;

import com.google.common.collect.Maps;
import com.volmit.adapt.Adapt;
import com.volmit.adapt.api.world.PlayerAdaptation;
import com.volmit.adapt.api.world.PlayerData;
import com.volmit.adapt.api.world.PlayerSkillLine;
import com.volmit.adapt.util.Localizer;
import com.volmit.adapt.util.manifold.rt.api.IBootstrap;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Function;
import me.clip.placeholderapi.expansion.PlaceholderExpansion;
import org.bukkit.OfflinePlayer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PapiExpansion
extends PlaceholderExpansion {
    private final Map<String, Function<PlayerSkillLine, String>> skillMap = Maps.newHashMap();
    private final Map<String, Function<PlayerData, String>> playerMap = Maps.newHashMap();
    private final Map<String, BiFunction<PlayerSkillLine, PlayerAdaptation, String>> adaptationMap = Maps.newHashMap();

    public PapiExpansion() {
        this.skillMap.put("level", playerSkillLine -> String.valueOf(playerSkillLine.getLevel()).equals("-5000") ? "0" : String.valueOf(playerSkillLine.getLevel()));
        this.skillMap.put("knowledge", playerSkillLine -> String.valueOf(playerSkillLine.getKnowledge()).equals("-5000") ? "0" : String.valueOf(playerSkillLine.getKnowledge()));
        this.skillMap.put("xp", playerSkillLine -> String.format("%.2f", playerSkillLine.getXp()).equals("-5000.00") ? "0" : String.format("%.2f", playerSkillLine.getXp()));
        this.skillMap.put("freshness", playerSkillLine -> String.valueOf(playerSkillLine.getFreshness()).equals("-5000") ? "0" : String.valueOf(playerSkillLine.getFreshness()));
        this.skillMap.put("multiplier", playerSkillLine -> String.valueOf(playerSkillLine.getMultiplier()).equals("-5000") ? "0" : String.valueOf(playerSkillLine.getMultiplier()));
        this.skillMap.put("name", playerSkillLine -> Localizer.dLocalize("skill", playerSkillLine.getLine(), "name"));
        this.playerMap.put("level", playerData -> String.valueOf(playerData.getMultiplier()).equals("-5000") ? "0" : String.valueOf(playerData.getLevel()));
        this.playerMap.put("multiplier", playerData -> String.valueOf(playerData.getMultiplier()).equals("-5000") ? "0" : String.valueOf(playerData.getMultiplier()));
        this.playerMap.put("availablepower", playerData -> String.valueOf(playerData.getAvailablePower()).equals("-5000") ? "0" : String.valueOf(playerData.getAvailablePower()));
        this.playerMap.put("maxpower", playerData -> String.valueOf(playerData.getMaxPower()).equals("-5000") ? "0" : String.valueOf(playerData.getMaxPower()));
        this.playerMap.put("usedpower", playerData -> String.valueOf(playerData.getUsedPower()).equals("-5000") ? "0" : String.valueOf(playerData.getUsedPower()));
        this.playerMap.put("wisdom", playerData -> String.valueOf(playerData.getWisdom()).equals("-5000") ? "0" : String.valueOf(playerData.getWisdom()));
        this.playerMap.put("masterxp", playerData -> String.valueOf(playerData.getMasterXp()).equals("-5000") ? "0" : String.valueOf(playerData.getMasterXp()));
        this.playerMap.put("seenthings", playerData -> String.valueOf(playerData.getSeenBlocks().getSeen().size() + playerData.getSeenBiomes().getSeen().size() + playerData.getSeenEnchants().getSeen().size() + playerData.getSeenEnvironments().getSeen().size() + playerData.getSeenFoods().getSeen().size() + playerData.getSeenItems().getSeen().size() + playerData.getSeenMobs().getSeen().size() + playerData.getSeenPeople().getSeen().size() + playerData.getSeenPotionEffects().getSeen().size() + playerData.getSeenRecipes().getSeen().size() + playerData.getSeenPotionEffects().getSeen().size() + playerData.getSeenWorlds().getSeen().size()));
        this.adaptationMap.put("name", (playerSkillLine, playerAdaptation) -> Localizer.dLocalize(playerSkillLine.getLine(), playerAdaptation.getId(), "name"));
        this.adaptationMap.put("level", (playerSkillLine, playerAdaptation) -> String.valueOf(playerAdaptation.getLevel()).equals("-5000") ? "0" : String.valueOf(playerAdaptation.getLevel()));
    }

    @NotNull
    public String getIdentifier() {
        return Adapt.instance.getDescription().getName().toLowerCase();
    }

    @NotNull
    public String getAuthor() {
        return String.join((CharSequence)", ", Adapt.instance.getDescription().getAuthors());
    }

    @NotNull
    public String getVersion() {
        return Adapt.instance.getDescription().getVersion();
    }

    public boolean persist() {
        return true;
    }

    @Nullable
    public String onRequest(OfflinePlayer offlinePlayer, @NotNull String string) {
        block4: {
            PlayerData playerData;
            String[] stringArray;
            block3: {
                stringArray = string.split("_");
                playerData = Adapt.instance.getAdaptServer().peekData(offlinePlayer.getUniqueId());
                if (Adapt.instance.getAdaptServer().getSkillRegistry().getSkill(stringArray[0]) != null) break block3;
                for (String string2 : this.playerMap.keySet()) {
                    if (!string2.equalsIgnoreCase(stringArray[0])) continue;
                    return this.playerMap.get(string2).apply(playerData);
                }
                break block4;
            }
            PlayerSkillLine playerSkillLine = playerData.getSkillLine(stringArray[0]);
            for (String object2 : this.skillMap.keySet()) {
                if (!object2.equalsIgnoreCase(stringArray[1])) continue;
                return this.skillMap.get(object2).apply(playerSkillLine);
            }
            String string3 = stringArray[0] + "-" + stringArray[1];
            if (!playerSkillLine.getAdaptations().containsKey(string3)) break block4;
            PlayerAdaptation playerAdaptation = playerSkillLine.getAdaptation(string3);
            for (String string2 : this.adaptationMap.keySet()) {
                if (!string2.equalsIgnoreCase(stringArray[2])) continue;
                return this.adaptationMap.get(string2).apply(playerSkillLine, playerAdaptation);
            }
        }
        return null;
    }

    static {
        IBootstrap.dasBoot();
    }
}

