/*
 * Decompiled with CFR 0.152.
 */
package com.volmit.adapt.api.adaptation;

import com.google.gson.Gson;
import com.volmit.adapt.Adapt;
import com.volmit.adapt.AdaptConfig;
import com.volmit.adapt.api.adaptation.Adaptation;
import com.volmit.adapt.api.advancement.AdaptAdvancement;
import com.volmit.adapt.api.potion.BrewingRecipe;
import com.volmit.adapt.api.recipe.AdaptRecipe;
import com.volmit.adapt.api.skill.Skill;
import com.volmit.adapt.api.tick.TickedObject;
import com.volmit.adapt.util.C;
import com.volmit.adapt.util.IO;
import com.volmit.adapt.util.J;
import com.volmit.adapt.util.JSONObject;
import com.volmit.adapt.util.Localizer;
import com.volmit.adapt.util.advancements.advancement.AdvancementVisibility;
import com.volmit.adapt.util.arcane.amulet.io.FileWatcher;
import com.volmit.adapt.util.manifold.rt.api.IBootstrap;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.bukkit.Material;

public abstract class SimpleAdaptation<T>
extends TickedObject
implements Adaptation<T> {
    private int maxLevel;
    private int initialCost;
    private int baseCost;
    private double costFactor;
    private String displayName;
    private Skill<?> skill;
    private String description;
    private Material icon;
    private String name;
    private List<AdaptAdvancement> cachedAdvancements = new ArrayList<AdaptAdvancement>();
    private List<AdaptRecipe> recipes = new ArrayList<AdaptRecipe>();
    private List<BrewingRecipe> brewingRecipes = new ArrayList<BrewingRecipe>();
    private Class<T> configType;
    private T config;

    public SimpleAdaptation(String string) {
        super("adaptations", UUID.randomUUID() + "-" + string, 1000L);
        this.setMaxLevel(5);
        this.setCostFactor(0.35);
        this.setBaseCost(3);
        this.setIcon(Material.PAPER);
        this.setInitialCost(1);
        this.setDescription("No Description Provided");
        this.name = string;
        J.a(() -> {
            if (!this.isEnabled()) {
                this.unregister();
            }
        }, 1);
    }

    @Override
    public Class<T> getConfigurationClass() {
        return this.configType;
    }

    @Override
    public void registerConfiguration(Class<T> clazz) {
        this.configType = clazz;
        final File file = Adapt.instance.getDataFile(new String[]{"adapt", "adaptations", this.getName() + ".json"});
        final FileWatcher fileWatcher = new FileWatcher(file);
        fileWatcher.checkModified();
        J.a(() -> {
            fileWatcher.checkModified();
            Adapt.instance.getTicker().register(new TickedObject("config", "config-adaptation-" + this.getName(), 1000L){

                @Override
                public void onTick() {
                    try {
                        if (fileWatcher.checkModified() && file.exists()) {
                            SimpleAdaptation.this.config = null;
                            SimpleAdaptation.this.getConfig();
                            Adapt.info("Hotloaded " + file.getPath());
                            Adapt.hotloaded();
                            fileWatcher.checkModified();
                        }
                    }
                    catch (Throwable throwable) {
                        throwable.printStackTrace();
                    }
                }
            });
        }, 20);
    }

    @Override
    public T getConfig() {
        block7: {
            try {
                if (this.config != null) break block7;
                T t = this.getConfigurationClass().getConstructor(new Class[0]).newInstance(new Object[0]);
                File file = Adapt.instance.getDataFile(new String[]{"adapt", "adaptations", this.getName() + ".json"});
                if (!file.exists()) {
                    try {
                        IO.writeAll(file, new JSONObject(new Gson().toJson(t)).toString(4));
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                        this.config = t;
                        return this.config;
                    }
                }
                try {
                    this.config = new Gson().fromJson(IO.readAll(file), this.getConfigurationClass());
                    IO.writeAll(file, new JSONObject(new Gson().toJson(this.config)).toString(4));
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                    this.config = t;
                    return this.config;
                }
            }
            catch (Throwable throwable) {
                Adapt.verbose("Failed to load config for " + this.getName());
            }
        }
        return this.config;
    }

    public void registerRecipe(AdaptRecipe adaptRecipe) {
        this.recipes.add(adaptRecipe);
    }

    public void registerBrewingRecipe(BrewingRecipe brewingRecipe) {
        this.brewingRecipes.add(brewingRecipe);
    }

    @Override
    public String getDisplayName() {
        try {
            return this.displayName == null ? Adaptation.super.getDisplayName() : C.RESET + C.BOLD + this.getSkill().getColor().toString() + this.displayName;
        }
        catch (Exception exception) {
            Adapt.verbose("Failed to get display name for " + this.getName());
            return null;
        }
    }

    public void registerAdvancement(AdaptAdvancement adaptAdvancement) {
        this.cachedAdvancements.add(adaptAdvancement);
    }

    @Override
    public void onRegisterAdvancements(List<AdaptAdvancement> list) {
        list.addAll(this.cachedAdvancements);
    }

    @Override
    public AdaptAdvancement buildAdvancements() {
        ArrayList<AdaptAdvancement> arrayList = new ArrayList<AdaptAdvancement>();
        this.onRegisterAdvancements(arrayList);
        return AdaptAdvancement.builder().key("adaptation_" + this.getName()).title(C.WHITE + "[     " + this.getDisplayName() + C.WHITE + "     ]").description(this.getDescription() + ". " + Localizer.dLocalize("snippets", "gui", "unlockthisbyclicking") + " " + AdaptConfig.get().adaptActivatorBlockName).icon(this.getIcon()).children(arrayList).visibility(AdvancementVisibility.PARENT_GRANTED).build();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof SimpleAdaptation)) {
            return false;
        }
        SimpleAdaptation simpleAdaptation = (SimpleAdaptation)object;
        if (!simpleAdaptation.canEqual(this)) {
            return false;
        }
        if (this.getMaxLevel() != simpleAdaptation.getMaxLevel()) {
            return false;
        }
        if (this.getInitialCost() != simpleAdaptation.getInitialCost()) {
            return false;
        }
        if (this.getBaseCost() != simpleAdaptation.getBaseCost()) {
            return false;
        }
        if (Double.compare(this.getCostFactor(), simpleAdaptation.getCostFactor()) != 0) {
            return false;
        }
        String string = this.getDisplayName();
        String string2 = simpleAdaptation.getDisplayName();
        if (string == null ? string2 != null : !string.equals(string2)) {
            return false;
        }
        Skill<?> skill = this.getSkill();
        Skill<?> skill2 = simpleAdaptation.getSkill();
        if (skill == null ? skill2 != null : !skill.equals(skill2)) {
            return false;
        }
        String string3 = this.getDescription();
        String string4 = simpleAdaptation.getDescription();
        if (string3 == null ? string4 != null : !string3.equals(string4)) {
            return false;
        }
        Material material = this.getIcon();
        Material material2 = simpleAdaptation.getIcon();
        if (material == null ? material2 != null : !material.equals(material2)) {
            return false;
        }
        String string5 = this.getName();
        String string6 = simpleAdaptation.getName();
        if (string5 == null ? string6 != null : !string5.equals(string6)) {
            return false;
        }
        List<AdaptAdvancement> list = this.getCachedAdvancements();
        List<AdaptAdvancement> list2 = simpleAdaptation.getCachedAdvancements();
        if (list == null ? list2 != null : !((Object)list).equals(list2)) {
            return false;
        }
        List<AdaptRecipe> list3 = this.getRecipes();
        List<AdaptRecipe> list4 = simpleAdaptation.getRecipes();
        if (list3 == null ? list4 != null : !((Object)list3).equals(list4)) {
            return false;
        }
        List<BrewingRecipe> list5 = this.getBrewingRecipes();
        List<BrewingRecipe> list6 = simpleAdaptation.getBrewingRecipes();
        if (list5 == null ? list6 != null : !((Object)list5).equals(list6)) {
            return false;
        }
        Class<T> clazz = this.getConfigType();
        Class<T> clazz2 = simpleAdaptation.getConfigType();
        if (clazz == null ? clazz2 != null : !clazz.equals(clazz2)) {
            return false;
        }
        T t = this.getConfig();
        T t2 = simpleAdaptation.getConfig();
        return !(t == null ? t2 != null : !t.equals(t2));
    }

    protected boolean canEqual(Object object) {
        return object instanceof SimpleAdaptation;
    }

    public int hashCode() {
        int n = 59;
        int n2 = 1;
        n2 = n2 * 59 + this.getMaxLevel();
        n2 = n2 * 59 + this.getInitialCost();
        n2 = n2 * 59 + this.getBaseCost();
        long l = Double.doubleToLongBits(this.getCostFactor());
        n2 = n2 * 59 + (int)(l >>> 32 ^ l);
        String string = this.getDisplayName();
        n2 = n2 * 59 + (string == null ? 43 : string.hashCode());
        Skill<?> skill = this.getSkill();
        n2 = n2 * 59 + (skill == null ? 43 : skill.hashCode());
        String string2 = this.getDescription();
        n2 = n2 * 59 + (string2 == null ? 43 : string2.hashCode());
        Material material = this.getIcon();
        n2 = n2 * 59 + (material == null ? 43 : material.hashCode());
        String string3 = this.getName();
        n2 = n2 * 59 + (string3 == null ? 43 : string3.hashCode());
        List<AdaptAdvancement> list = this.getCachedAdvancements();
        n2 = n2 * 59 + (list == null ? 43 : ((Object)list).hashCode());
        List<AdaptRecipe> list2 = this.getRecipes();
        n2 = n2 * 59 + (list2 == null ? 43 : ((Object)list2).hashCode());
        List<BrewingRecipe> list3 = this.getBrewingRecipes();
        n2 = n2 * 59 + (list3 == null ? 43 : ((Object)list3).hashCode());
        Class<T> clazz = this.getConfigType();
        n2 = n2 * 59 + (clazz == null ? 43 : clazz.hashCode());
        T t = this.getConfig();
        n2 = n2 * 59 + (t == null ? 43 : t.hashCode());
        return n2;
    }

    @Override
    public int getMaxLevel() {
        return this.maxLevel;
    }

    @Override
    public int getInitialCost() {
        return this.initialCost;
    }

    @Override
    public int getBaseCost() {
        return this.baseCost;
    }

    @Override
    public double getCostFactor() {
        return this.costFactor;
    }

    @Override
    public Skill<?> getSkill() {
        return this.skill;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public Material getIcon() {
        return this.icon;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public List<AdaptAdvancement> getCachedAdvancements() {
        return this.cachedAdvancements;
    }

    @Override
    public List<AdaptRecipe> getRecipes() {
        return this.recipes;
    }

    @Override
    public List<BrewingRecipe> getBrewingRecipes() {
        return this.brewingRecipes;
    }

    public Class<T> getConfigType() {
        return this.configType;
    }

    public void setMaxLevel(int n) {
        this.maxLevel = n;
    }

    public void setInitialCost(int n) {
        this.initialCost = n;
    }

    public void setBaseCost(int n) {
        this.baseCost = n;
    }

    public void setCostFactor(double d) {
        this.costFactor = d;
    }

    public void setDisplayName(String string) {
        this.displayName = string;
    }

    @Override
    public void setSkill(Skill<?> skill) {
        this.skill = skill;
    }

    public void setDescription(String string) {
        this.description = string;
    }

    public void setIcon(Material material) {
        this.icon = material;
    }

    public void setName(String string) {
        this.name = string;
    }

    public void setCachedAdvancements(List<AdaptAdvancement> list) {
        this.cachedAdvancements = list;
    }

    public void setRecipes(List<AdaptRecipe> list) {
        this.recipes = list;
    }

    public void setBrewingRecipes(List<BrewingRecipe> list) {
        this.brewingRecipes = list;
    }

    public void setConfigType(Class<T> clazz) {
        this.configType = clazz;
    }

    public void setConfig(T t) {
        this.config = t;
    }

    public String toString() {
        return "SimpleAdaptation(maxLevel=" + this.getMaxLevel() + ", initialCost=" + this.getInitialCost() + ", baseCost=" + this.getBaseCost() + ", costFactor=" + this.getCostFactor() + ", displayName=" + this.getDisplayName() + ", skill=" + this.getSkill() + ", description=" + this.getDescription() + ", icon=" + this.getIcon() + ", name=" + this.getName() + ", cachedAdvancements=" + this.getCachedAdvancements() + ", recipes=" + this.getRecipes() + ", brewingRecipes=" + this.getBrewingRecipes() + ", configType=" + this.getConfigType() + ", config=" + this.getConfig() + ")";
    }

    static {
        IBootstrap.dasBoot();
    }
}

