/*
 * Decompiled with CFR 0.152.
 */
package com.volmit.adapt.api.data;

import com.volmit.adapt.Adapt;
import com.volmit.adapt.api.data.unit.Earnings;
import com.volmit.adapt.api.tick.TickedObject;
import com.volmit.adapt.util.J;
import com.volmit.adapt.util.arcane.spatial.mantle.Mantle;
import com.volmit.adapt.util.arcane.spatial.matter.SpatialMatter;
import com.volmit.adapt.util.extensions.java.util.Map.XMap;
import com.volmit.adapt.util.manifold.rt.api.IBootstrap;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.event.EventHandler;
import org.bukkit.event.world.WorldSaveEvent;
import org.bukkit.event.world.WorldUnloadEvent;

public class WorldData
extends TickedObject {
    private static final Map<World, WorldData> mantles;
    private final World world;
    private final Mantle mantle;

    public WorldData(World world) {
        super("world-data", world.getUID().toString(), 30000L);
        this.world = world;
        this.mantle = new Mantle(Adapt.instance.getDataFolder(new String[]{"data", "mantle"}), world.getMaxHeight());
    }

    public static void stop() {
        XMap.v(mantles).forEach(WorldData::unregister);
    }

    public static WorldData of(World world) {
        return mantles.computeIfAbsent(world, WorldData::new);
    }

    public double getEarningsMultiplier(Block block) {
        Earnings earnings = this.mantle.get(block.getX(), block.getY(), block.getZ(), Earnings.class);
        if (earnings == null) {
            return 1.0;
        }
        return 1.0 / (double)(earnings.getEarnings() == 0 ? 1 : earnings.getEarnings());
    }

    public double reportEarnings(Block block) {
        Earnings earnings = this.mantle.get(block.getX(), block.getY(), block.getZ(), Earnings.class);
        Earnings earnings2 = earnings = earnings == null ? new Earnings(0) : earnings;
        if (earnings.getEarnings() >= 127) {
            return 1.0 / (double)(earnings.getEarnings() == 0 ? 1 : earnings.getEarnings());
        }
        this.mantle.set(block.getX(), block.getY(), block.getZ(), earnings.increment());
        return 1.0 / (double)(earnings.getEarnings() == 0 ? 1 : earnings.getEarnings());
    }

    @Override
    public void unregister() {
        super.unregister();
        this.mantle.close();
        mantles.remove(this.world);
    }

    @EventHandler
    public void on(WorldSaveEvent worldSaveEvent) {
        J.a(this.mantle::saveAll);
    }

    @EventHandler
    public void on(WorldUnloadEvent worldUnloadEvent) {
        this.unregister();
    }

    @Override
    public void onTick() {
        this.mantle.trim(60000L);
    }

    public Mantle getMantle() {
        return this.mantle;
    }

    static {
        IBootstrap.dasBoot();
        mantles = new HashMap<World, WorldData>();
        SpatialMatter.registerSliceType(new Earnings.EarningsMatter());
    }
}

