/*
 * Decompiled with CFR 0.152.
 */
package com.volmit.adapt.api.potion;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.volmit.adapt.Adapt;
import com.volmit.adapt.api.potion.BrewingRecipe;
import com.volmit.adapt.api.potion.BrewingTask;
import com.volmit.adapt.api.world.AdaptPlayer;
import com.volmit.adapt.util.J;
import com.volmit.adapt.util.manifold.rt.api.IBootstrap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.BrewingStand;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.BrewEvent;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.BrewerInventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.PotionMeta;
import org.bukkit.potion.PotionType;

public class BrewingManager
implements Listener {
    private static final Map<BrewingRecipe, List<String>> recipes;
    private static final Map<Location, BrewingTask> activeTasks;

    public static void registerRecipe(String string, BrewingRecipe brewingRecipe2) {
        recipes.putIfAbsent(brewingRecipe2, Lists.newArrayList((Object[])new String[]{string}));
        recipes.computeIfPresent(brewingRecipe2, (brewingRecipe, list) -> {
            if (!list.contains(string)) {
                list.add(string);
            }
            return list;
        });
    }

    @EventHandler
    public void onInventoryClick(InventoryClickEvent inventoryClickEvent) {
        boolean bl;
        if (inventoryClickEvent.getView().getTopInventory().getType() != InventoryType.BREWING || inventoryClickEvent.getView().getTopInventory().getHolder() == null) {
            return;
        }
        Adapt.verbose("Brewing click: " + inventoryClickEvent.getRawSlot());
        BrewerInventory brewerInventory = (BrewerInventory)inventoryClickEvent.getInventory();
        boolean bl2 = bl = brewerInventory.getIngredient() == null && inventoryClickEvent.getCursor() != null && inventoryClickEvent.getRawSlot() == 3 && inventoryClickEvent.getClickedInventory() != null && inventoryClickEvent.getClickedInventory().getType().equals((Object)InventoryType.BREWING) && inventoryClickEvent.getClick() == ClickType.LEFT;
        if (bl) {
            Adapt.verbose("Brewing Stand Ingredient Clicked");
            inventoryClickEvent.setCancelled(true);
        }
        J.s(() -> {
            if (bl) {
                brewerInventory.setIngredient(inventoryClickEvent.getCursor());
                inventoryClickEvent.setCursor(null);
            }
            BrewingStand brewingStand = brewerInventory.getHolder();
            AdaptPlayer adaptPlayer = Adapt.instance.getAdaptServer().getPlayer((Player)inventoryClickEvent.getWhoClicked());
            Optional<BrewingRecipe> optional = recipes.keySet().stream().filter(brewingRecipe -> BrewingTask.isValid(brewingRecipe, brewingStand.getLocation())).findFirst();
            optional.ifPresent(brewingRecipe -> {
                if (activeTasks.containsKey(brewingStand.getLocation())) {
                    BrewingTask brewingTask = activeTasks.get(brewingStand.getLocation());
                    if (!brewingTask.getRecipe().getId().equals(brewingRecipe.getId())) {
                        activeTasks.remove(brewingStand.getLocation()).cancel();
                        if (recipes.get(brewingRecipe).stream().noneMatch(adaptPlayer::hasAdaptation)) {
                            return;
                        }
                        activeTasks.put(brewingStand.getLocation(), new BrewingTask((BrewingRecipe)brewingRecipe, brewingStand.getLocation()));
                    }
                } else {
                    if (recipes.get(brewingRecipe).stream().noneMatch(adaptPlayer::hasAdaptation)) {
                        return;
                    }
                    activeTasks.put(brewingStand.getLocation(), new BrewingTask((BrewingRecipe)brewingRecipe, brewingStand.getLocation()));
                }
            });
            if (optional.isEmpty() && activeTasks.containsKey(brewingStand.getLocation())) {
                activeTasks.remove(brewingStand.getLocation()).cancel();
            }
        });
    }

    @EventHandler
    public void onBrew(BrewEvent brewEvent) {
        Material material = brewEvent.getContents().getIngredient().getType();
        if (material != Material.GUNPOWDER && material != Material.DRAGON_BREATH) {
            return;
        }
        for (int i = 0; i < 3; ++i) {
            ItemStack itemStack = brewEvent.getContents().getItem(i);
            if (itemStack == null || ((PotionMeta)itemStack.getItemMeta()).getBasePotionData().getType() != PotionType.UNCRAFTABLE) continue;
            ItemStack itemStack2 = itemStack.clone();
            if (material == Material.GUNPOWDER) {
                itemStack2.setType(Material.SPLASH_POTION);
            } else {
                itemStack2.setType(Material.LINGERING_POTION);
            }
            brewEvent.getResults().set(i, itemStack2);
        }
    }

    static {
        IBootstrap.dasBoot();
        recipes = Maps.newHashMap();
        activeTasks = Maps.newHashMap();
    }
}

