/*
 * Decompiled with CFR 0.152.
 */
package com.volmit.adapt.api.skill;

import com.volmit.adapt.Adapt;
import com.volmit.adapt.AdaptConfig;
import com.volmit.adapt.api.Component;
import com.volmit.adapt.api.adaptation.Adaptation;
import com.volmit.adapt.api.advancement.AdaptAdvancement;
import com.volmit.adapt.api.recipe.AdaptRecipe;
import com.volmit.adapt.api.tick.Ticked;
import com.volmit.adapt.api.world.AdaptPlayer;
import com.volmit.adapt.api.world.AdaptStatTracker;
import com.volmit.adapt.api.world.PlayerData;
import com.volmit.adapt.api.xp.XP;
import com.volmit.adapt.content.gui.SkillsGui;
import com.volmit.adapt.util.C;
import com.volmit.adapt.util.Form;
import com.volmit.adapt.util.J;
import com.volmit.adapt.util.Localizer;
import com.volmit.adapt.util.MaterialBlock;
import com.volmit.adapt.util.UIElement;
import com.volmit.adapt.util.UIWindow;
import java.util.List;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.entity.Player;

public interface Skill<T>
extends Ticked,
Component {
    public AdaptAdvancement buildAdvancements();

    public Class<T> getConfigurationClass();

    public void registerConfiguration(Class<T> var1);

    public boolean isEnabled();

    public T getConfig();

    public String getName();

    public String getEmojiName();

    public Material getIcon();

    public String getDescription();

    public List<AdaptRecipe> getRecipes();

    public void registerAdaptation(Adaptation<?> var1);

    public void registerStatTracker(AdaptStatTracker var1);

    public List<AdaptStatTracker> getStatTrackers();

    default public void checkStatTrackers(AdaptPlayer player) {
        if (!this.isEnabled()) {
            this.unregister();
        }
        if (!player.getPlayer().getClass().getSimpleName().equals("CraftPlayer")) {
            return;
        }
        if (!player.getAdvancementHandler().isReady()) {
            return;
        }
        if (!AdaptConfig.get().isAdvancements()) {
            return;
        }
        PlayerData d = player.getData();
        for (AdaptStatTracker i : this.getStatTrackers()) {
            if (d.isGranted(i.getAdvancement()) || !(d.getStat(i.getStat()) >= i.getGoal())) continue;
            player.getAdvancementHandler().grant(i.getAdvancement());
            this.xp(player.getPlayer(), i.getReward());
        }
    }

    public List<Adaptation<?>> getAdaptations();

    public C getColor();

    public double getMinXp();

    public void onRegisterAdvancements(List<AdaptAdvancement> var1);

    default public boolean hasBlacklistPermission(Player p, Skill s) {
        if (p.isOp()) {
            return false;
        }
        String blacklistPermission = "adapt.blacklist." + s.getName().replaceAll("-", "");
        Adapt.verbose("Checking if player " + p.getName() + " has blacklist permission " + blacklistPermission);
        return p.hasPermission(blacklistPermission);
    }

    default public String getDisplayName() {
        if (!this.isEnabled()) {
            this.unregister();
        }
        return C.RESET + C.BOLD + this.getColor().toString() + this.getEmojiName() + " " + Form.capitalize(this.getName());
    }

    default public String getShortName() {
        if (!this.isEnabled()) {
            this.unregister();
        }
        return C.RESET + C.BOLD + this.getColor().toString() + this.getEmojiName();
    }

    default public String getDisplayName(int level) {
        if (!this.isEnabled()) {
            this.unregister();
        }
        return this.getDisplayName() + C.RESET + " " + C.UNDERLINE + C.WHITE + level + C.RESET;
    }

    default public void xp(Player p, double xp) {
        if (!p.getClass().getSimpleName().equals("CraftPlayer")) {
            return;
        }
        this.xp(p, p.getLocation(), xp);
    }

    default public void xp(Player p, Location at, double xp) {
        if (!p.getClass().getSimpleName().equals("CraftPlayer")) {
            return;
        }
        try {
            XP.xp(p, this, xp);
            if (xp > 50.0) {
                this.vfxXP(p, at, (int)xp);
            }
            Adapt.verbose("Gave " + p.getName() + " " + xp + " xp in " + this.getName() + " " + this.getClass());
        }
        catch (Exception e) {
            Adapt.verbose("Failed to give xp to " + p.getName() + " for " + this.getName() + " (" + xp + ")");
        }
    }

    default public void xpS(Player p, Location at, double xp) {
        if (!p.getClass().getSimpleName().equals("CraftPlayer")) {
            return;
        }
        try {
            XP.xpSilent(p, this, xp);
            if (xp > 50.0) {
                this.vfxXP(p, at, (int)xp);
            }
            Adapt.verbose("Gave " + p.getName() + " " + xp + " xp in " + this.getName() + " " + this.getClass());
        }
        catch (Exception e) {
            Adapt.verbose("Failed to give xp to " + p.getName() + " for " + this.getName() + " (" + xp + ")");
        }
    }

    default public void xpSilent(Player p, double xp) {
        if (!p.getClass().getSimpleName().equals("CraftPlayer")) {
            return;
        }
        try {
            XP.xpSilent(p, this, xp);
        }
        catch (Exception ignored) {
            Adapt.verbose("Player was Given XP (Likely Teleportation) before i can see it because some plugin has higher priority than me and moves a player. so im not going to throw an error, as i know why it's happening.");
        }
    }

    default public void xp(Location at, double xp, int rad, long duration) {
        XP.spatialXP(at, this, xp, rad, duration);
        this.vfxXP(at);
    }

    default public void knowledge(Player p, long k) {
        XP.knowledge(p, this, k);
    }

    default public boolean openGui(Player player, boolean checkPermissions) {
        if (this.hasBlacklistPermission(player, this)) {
            return false;
        }
        this.openGui(player);
        return true;
    }

    default public void openGui(Player player) {
        if (!this.isEnabled()) {
            this.unregister();
        }
        if (!player.getClass().getSimpleName().equals("CraftPlayer")) {
            return;
        }
        player.getWorld().playSound(player.getLocation(), Sound.ITEM_BOOK_PAGE_TURN, 1.1f, 1.255f);
        player.getWorld().playSound(player.getLocation(), Sound.ITEM_BOOK_PAGE_TURN, 0.7f, 1.455f);
        player.getWorld().playSound(player.getLocation(), Sound.ITEM_BOOK_PAGE_TURN, 0.3f, 1.855f);
        UIWindow w = new UIWindow(player);
        w.setTag("skill/" + this.getName());
        w.setDecorator((window, position, row) -> new UIElement("bg").setMaterial(new MaterialBlock(Material.BLACK_STAINED_GLASS_PANE)));
        int ind = 0;
        for (Adaptation<?> i : this.getAdaptations()) {
            if (i.hasBlacklistPermission(player, i)) continue;
            int pos = w.getPosition(ind);
            int row2 = w.getRow(ind);
            int lvl = this.getPlayer(player).getData().getSkillLine(this.getName()).getAdaptationLevel(i.getName());
            w.setElement(pos, row2, new UIElement("ada-" + i.getName()).setMaterial(new MaterialBlock(i.getIcon())).setName(i.getDisplayName(lvl)).addLore(Form.wrapWordsPrefixed(i.getDescription(), "" + C.GRAY, 45)).addLore(lvl == 0 ? C.DARK_GRAY + Localizer.dLocalize("snippets", "gui", "notlearned") : C.GRAY + Localizer.dLocalize("snippets", "gui", "level") + " " + C.WHITE + Form.toRoman(lvl)).setProgress(1.0).onLeftClick(e -> {
                w.close();
                i.openGui(player);
            }));
            ++ind;
        }
        if (AdaptConfig.get().isGuiBackButton()) {
            int backRow;
            int backPos = w.getResolution().getWidth() - 1;
            if (w.getElement(backPos, backRow = w.getViewportHeight() - 1) != null) {
                ++backRow;
            }
            w.setElement(backPos, backRow, new UIElement("back").setMaterial(new MaterialBlock(Material.RED_BED)).setName(C.RESET + C.GRAY + Localizer.dLocalize("snippets", "gui", "back")).onLeftClick(e -> {
                w.close();
                this.onGuiClose(player, true);
            }));
        }
        AdaptPlayer a = Adapt.instance.getAdaptServer().getPlayer(player);
        w.setTitle(this.getDisplayName(a.getSkillLine(this.getName()).getLevel()) + " " + Form.pc(XP.getLevelProgress(a.getSkillLine(this.getName()).getXp())) + " (" + Form.f((int)XP.getXpUntilLevelUp(a.getSkillLine(this.getName()).getXp())) + Localizer.dLocalize("snippets", "gui", "xp") + " " + (a.getSkillLine(this.getName()).getLevel() + 1) + ")");
        w.onClosed(vv -> J.s(() -> this.onGuiClose(player, !AdaptConfig.get().isEscClosesAllGuis())));
        w.open();
        Adapt.instance.getGuiLeftovers().put(player.getUniqueId().toString(), w);
    }

    private void onGuiClose(Player player, boolean openPrevGui) {
        player.getWorld().playSound(player.getLocation(), Sound.ITEM_BOOK_PAGE_TURN, 1.1f, 1.255f);
        player.getWorld().playSound(player.getLocation(), Sound.ITEM_BOOK_PAGE_TURN, 0.7f, 1.455f);
        player.getWorld().playSound(player.getLocation(), Sound.ITEM_BOOK_PAGE_TURN, 0.3f, 1.855f);
        if (openPrevGui) {
            SkillsGui.open(player);
        }
    }
}

