/*
 * Decompiled with CFR 0.152.
 */
package com.volmit.adapt.api.value;

import com.google.gson.Gson;
import com.volmit.adapt.Adapt;
import com.volmit.adapt.AdaptConfig;
import com.volmit.adapt.api.recipe.AdaptRecipe;
import com.volmit.adapt.api.value.MaterialCount;
import com.volmit.adapt.api.value.MaterialRecipe;
import com.volmit.adapt.util.Form;
import com.volmit.adapt.util.IO;
import com.volmit.adapt.util.JSONObject;
import com.volmit.adapt.util.PrecisionStopwatch;
import com.volmit.adapt.util.manifold.rt.api.IBootstrap;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.inventory.CookingRecipe;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.MerchantRecipe;
import org.bukkit.inventory.Recipe;
import org.bukkit.inventory.ShapedRecipe;
import org.bukkit.inventory.ShapelessRecipe;
import org.bukkit.inventory.StonecuttingRecipe;

public class MaterialValue {
    private static final Map<Material, Double> valueMultipliers;
    private static MaterialValue valueCache;
    private final Map<Material, Double> value = new HashMap<Material, Double>();

    public static void save() {
        if (valueCache == null) {
            return;
        }
        File file = Adapt.instance.getDataFile(new String[]{"data", "value-cache.json"});
        try {
            IO.writeAll(file, new JSONObject(new Gson().toJson((Object)valueCache)).toString(4));
        }
        catch (IOException iOException) {
            Adapt.verbose("Failed to save value cache");
        }
    }

    public static MaterialValue get() {
        if (valueCache == null) {
            MaterialValue materialValue = new MaterialValue();
            File file = Adapt.instance.getDataFile(new String[]{"data", "value-cache.json"});
            if (!file.exists()) {
                try {
                    IO.writeAll(file, new JSONObject(new Gson().toJson((Object)materialValue)).toString(4));
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                    valueCache = materialValue;
                    return materialValue;
                }
            }
            try {
                valueCache = (MaterialValue)new Gson().fromJson(IO.readAll(file), MaterialValue.class);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                valueCache = new MaterialValue();
            }
        }
        return valueCache;
    }

    public static void debugValue(Material material) {
        MaterialValue.debugValue(material, 0, 1, new HashSet<MaterialRecipe>());
    }

    private static void debugValue(Material material, int n, int n2, Set<MaterialRecipe> set) {
        PrecisionStopwatch precisionStopwatch = PrecisionStopwatch.start();
        Adapt.verbose(Form.repeat("  ", n) + material.name() + ": " + MaterialValue.getValue(material) + (String)(n2 == 1 ? "" : " (x" + n2 + ")"));
        int n3 = 0;
        for (MaterialRecipe materialRecipe : MaterialValue.getRecipes(material)) {
            if (set.contains(materialRecipe)) continue;
            set.add(materialRecipe);
            if (set.size() > AdaptConfig.get().getMaxRecipeListPrecaution()) {
                Adapt.verbose("Avoiding infinite loop");
                return;
            }
            int n4 = materialRecipe.getOutput().getAmount();
            Adapt.verbose(Form.repeat("  ", n) + "# Recipe [" + n + "x" + n3 + (String)(n4 == 1 ? "]" : "] (x" + n4 + ") "));
            for (MaterialCount materialCount : materialRecipe.getInput()) {
                MaterialValue.debugValue(materialCount.getMaterial(), n + 1, materialCount.getAmount(), set);
            }
            ++n3;
        }
        Adapt.verbose(Form.repeat("  ", n) + " took " + Form.duration(precisionStopwatch.getMilliseconds(), 0));
    }

    private static double getMultiplier(Material material) {
        Double d = AdaptConfig.get().getValue().getValueMutlipliers().get(material);
        return d == null ? 1.0 : d;
    }

    public static double getValue(Material material) {
        try {
            return MaterialValue.getValue(material, new HashSet<MaterialRecipe>());
        }
        catch (Exception exception) {
            return 1.0;
        }
    }

    private static double getValue(Material material, Set<MaterialRecipe> set) {
        if (MaterialValue.get().value.containsKey(material)) {
            if (material.isBlock() && material.getHardness() == 0.0f) {
                return 0.0;
            }
            return MaterialValue.get().value.get(material);
        }
        double d2 = AdaptConfig.get().getValue().getBaseValue();
        List<MaterialRecipe> list = MaterialValue.getRecipes(material);
        if (list.isEmpty()) {
            MaterialValue.get().value.put(material, d2 * MaterialValue.getMultiplier(material));
        } else {
            ArrayList<Double> arrayList = new ArrayList<Double>();
            for (MaterialRecipe materialRecipe : list) {
                if (set.contains(materialRecipe)) continue;
                set.add(materialRecipe);
                double d3 = d2;
                for (MaterialCount materialCount : materialRecipe.getInput()) {
                    d3 += MaterialValue.getValue(materialCount.getMaterial(), set);
                }
                arrayList.add(d3 / (double)materialRecipe.getOutput().getAmount());
            }
            if (arrayList.size() > 0) {
                d2 += arrayList.stream().mapToDouble(d -> d).average().getAsDouble();
            }
            if (d2 > (double)AdaptConfig.get().getMaxRecipeListPrecaution()) {
                MaterialValue.get().value.put(material, (d2 / 10.0 + 1.0) * MaterialValue.getMultiplier(material));
            } else {
                MaterialValue.get().value.put(material, d2);
            }
        }
        if (material.isBlock() && material.getHardness() == 0.0f) {
            return 0.0;
        }
        return MaterialValue.get().value.get(material);
    }

    private static List<MaterialRecipe> getRecipes(Material material) {
        ArrayList<MaterialRecipe> arrayList = new ArrayList<MaterialRecipe>();
        try {
            ItemStack itemStack = new ItemStack(material);
            try {
                itemStack.setDurability((short)-1);
            }
            catch (Throwable throwable) {
                Adapt.verbose("Failed to set durability of " + material.name());
            }
            Bukkit.getRecipesFor((ItemStack)itemStack).forEach(recipe -> {
                if (recipe instanceof AdaptRecipe) {
                    Adapt.verbose("Skipping Adapt Recipe to prevent duplicates, " + material.name() + " -> " + ((AdaptRecipe)recipe).getKey());
                    return;
                }
                MaterialRecipe materialRecipe = MaterialValue.toMaterial(recipe);
                if (materialRecipe != null) {
                    arrayList.add(materialRecipe);
                }
            });
        }
        catch (Throwable throwable) {
            Adapt.verbose("Failed to get recipes for " + material.name());
        }
        return arrayList;
    }

    private static MaterialRecipe toMaterial(Recipe recipe) {
        try {
            if (recipe instanceof ShapelessRecipe) {
                ShapelessRecipe shapelessRecipe = (ShapelessRecipe)recipe;
                return MaterialRecipe.builder().input(new ArrayList<MaterialCount>(shapelessRecipe.getIngredientList().stream().map(itemStack -> new MaterialCount(itemStack.getType(), 1)).toList())).output(new MaterialCount(shapelessRecipe.getResult().getType(), shapelessRecipe.getResult().getAmount())).build();
            }
            if (recipe instanceof ShapedRecipe) {
                ShapedRecipe shapedRecipe = (ShapedRecipe)recipe;
                MaterialRecipe materialRecipe = MaterialRecipe.builder().input(new ArrayList<MaterialCount>()).output(new MaterialCount(shapedRecipe.getResult().getType(), shapedRecipe.getResult().getAmount())).build();
                HashMap<Material, Integer> hashMap = new HashMap<Material, Integer>();
                for (ItemStack itemStack2 : shapedRecipe.getIngredientMap().values()) {
                    if (itemStack2 == null || itemStack2.getType().isAir()) continue;
                    hashMap.compute(itemStack2.getType(), (material, n) -> n == null ? 1 : n + 1);
                }
                hashMap.forEach((material, n) -> materialRecipe.getInput().add(new MaterialCount((Material)material, (int)n)));
                return materialRecipe;
            }
            if (recipe instanceof CookingRecipe) {
                CookingRecipe cookingRecipe = (CookingRecipe)recipe;
                ArrayList<MaterialCount> arrayList = new ArrayList<MaterialCount>();
                arrayList.add(new MaterialCount(cookingRecipe.getInput().getType(), 1));
                return MaterialRecipe.builder().input(arrayList).output(new MaterialCount(cookingRecipe.getResult().getType(), cookingRecipe.getResult().getAmount())).build();
            }
            if (recipe instanceof MerchantRecipe) {
                MerchantRecipe merchantRecipe = (MerchantRecipe)recipe;
                return MaterialRecipe.builder().input(new ArrayList<MaterialCount>(merchantRecipe.getIngredients().stream().map(itemStack -> new MaterialCount(itemStack.getType(), 1)).toList())).output(new MaterialCount(merchantRecipe.getResult().getType(), merchantRecipe.getResult().getAmount())).build();
            }
            if (recipe instanceof StonecuttingRecipe) {
                StonecuttingRecipe stonecuttingRecipe = (StonecuttingRecipe)recipe;
                ArrayList<MaterialCount> arrayList = new ArrayList<MaterialCount>();
                arrayList.add(new MaterialCount(stonecuttingRecipe.getInput().getType(), 1));
                return MaterialRecipe.builder().input(arrayList).output(new MaterialCount(stonecuttingRecipe.getResult().getType(), stonecuttingRecipe.getResult().getAmount())).build();
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        return null;
    }

    public Map<Material, Double> getValue() {
        return this.value;
    }

    static {
        IBootstrap.dasBoot();
        valueMultipliers = new HashMap<Material, Double>();
        valueCache = null;
        AdaptConfig.get().getValue().getValueMutlipliers().forEach((string, d) -> {
            try {
                Material material = Material.valueOf((String)string.toUpperCase());
                valueMultipliers.put(material, (Double)d);
            }
            catch (Exception exception) {
                Adapt.verbose("Invalid material value multiplier: " + string);
            }
        });
    }
}

