/*
 * Decompiled with CFR 0.152.
 */
package com.volmit.adapt.content.adaptation.blocking;

import com.volmit.adapt.api.adaptation.SimpleAdaptation;
import com.volmit.adapt.content.item.ItemListings;
import com.volmit.adapt.content.item.multiItems.MultiArmor;
import com.volmit.adapt.util.C;
import com.volmit.adapt.util.Element;
import com.volmit.adapt.util.J;
import com.volmit.adapt.util.Localizer;
import com.volmit.adapt.util.manifold.rt.api.IBootstrap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.InventoryAction;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.player.PlayerDropItemEvent;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.Damageable;
import org.bukkit.inventory.meta.ItemMeta;

public class BlockingMultiArmor
extends SimpleAdaptation<Config> {
    private static final MultiArmor multiarmor;
    private final Map<Player, Long> cooldowns;

    public BlockingMultiArmor() {
        super("blocking-multiarmor");
        this.registerConfiguration(Config.class);
        this.setDisplayName(Localizer.dLocalize("blocking", "multiarmor", "name"));
        this.setDescription(Localizer.dLocalize("blocking", "multiarmor", "description"));
        this.setIcon(Material.ELYTRA);
        this.setInterval(20202L);
        this.setBaseCost(((Config)this.getConfig()).baseCost);
        this.setMaxLevel(((Config)this.getConfig()).maxLevel);
        this.setInitialCost(((Config)this.getConfig()).initialCost);
        this.setCostFactor(((Config)this.getConfig()).costFactor);
        this.cooldowns = new HashMap<Player, Long>();
    }

    @Override
    public void addStats(int n, Element element) {
        element.addLore(C.GRAY + Localizer.dLocalize("blocking", "multiarmor", "lore1"));
        element.addLore(C.GRAY + n + C.GRAY + Localizer.dLocalize("blocking", "multiarmor", "lore2"));
        element.addLore(C.GREEN + Localizer.dLocalize("blocking", "multiarmor", "lore3"));
        element.addLore(C.RED + Localizer.dLocalize("blocking", "multiarmor", "lore4"));
        element.addLore(C.GRAY + Localizer.dLocalize("blocking", "multiarmor", "lore5"));
        element.addLore(C.UNDERLINE + Localizer.dLocalize("blocking", "multiarmor", "lore6"));
    }

    @Override
    public boolean isEnabled() {
        return ((Config)this.getConfig()).enabled;
    }

    @Override
    public void onTick() {
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void on(PlayerMoveEvent playerMoveEvent) {
        if (playerMoveEvent.isCancelled()) {
            return;
        }
        Player player = playerMoveEvent.getPlayer();
        ItemStack itemStack = player.getInventory().getChestplate();
        if (itemStack != null && this.hasAdaptation(player) && this.validateArmor(itemStack)) {
            if (this.cooldowns.containsKey(player)) {
                if (this.cooldowns.get(player) + 3000L > System.currentTimeMillis()) {
                    return;
                }
                this.cooldowns.remove(player);
            }
            if (player.isOnGround() && !player.isFlying()) {
                if (this.isChestplate(itemStack)) {
                    return;
                }
                J.s(() -> player.getInventory().setChestplate(multiarmor.nextChestplate(itemStack)));
                this.cooldowns.put(player, System.currentTimeMillis());
                player.getWorld().playSound(player.getLocation(), Sound.ITEM_ARMOR_EQUIP_ELYTRA, 1.0f, 0.77f);
                player.getWorld().playSound(player.getLocation(), Sound.BLOCK_BEEHIVE_SHEAR, 0.5f, 0.77f);
            } else if (player.getFallDistance() > 4.0f) {
                if (this.isElytra(itemStack)) {
                    return;
                }
                J.s(() -> player.getInventory().setChestplate(multiarmor.nextElytra(itemStack)));
                this.cooldowns.put(player, System.currentTimeMillis());
                player.getWorld().playSound(player.getLocation(), Sound.ITEM_ARMOR_EQUIP_ELYTRA, 1.0f, 0.77f);
                player.getWorld().playSound(player.getLocation(), Sound.ENTITY_IRON_GOLEM_STEP, 0.5f, 0.77f);
            }
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void on(PlayerDropItemEvent playerDropItemEvent) {
        Player player = playerDropItemEvent.getPlayer();
        if (!this.hasAdaptation(player)) {
            return;
        }
        if (player.isSneaking() && this.validateArmor(playerDropItemEvent.getItemDrop().getItemStack())) {
            List<ItemStack> list = multiarmor.explode(playerDropItemEvent.getItemDrop().getItemStack());
            for (ItemStack itemStack : list) {
                Damageable damageable = (Damageable)itemStack.getItemMeta();
                if (itemStack.hasItemMeta()) {
                    ItemMeta itemMeta;
                    ItemMeta itemMeta2 = itemMeta = itemStack.getItemMeta().clone();
                    if (itemMeta.hasDisplayName()) {
                        itemMeta2.setDisplayName(itemMeta.getDisplayName());
                    }
                    if (itemMeta.hasEnchants()) {
                        Map map = itemMeta.getEnchants();
                        for (Enchantment enchantment : map.keySet()) {
                            itemMeta2.addEnchant(enchantment, ((Integer)map.get(enchantment)).intValue(), true);
                        }
                    }
                    if (damageable != null && damageable.hasDamage()) {
                        ((Damageable)itemMeta2).setDamage(damageable.getDamage());
                    }
                    itemMeta2.setLore(null);
                    itemStack.setItemMeta(itemMeta2);
                }
                list.set(list.indexOf(itemStack), itemStack);
            }
            J.s(() -> {
                player.playSound(player.getLocation(), Sound.ENTITY_IRON_GOLEM_DEATH, 0.25f, 0.77f);
                for (ItemStack itemStack : list) {
                    player.getWorld().dropItem(player.getLocation(), itemStack);
                }
            });
            playerDropItemEvent.getItemDrop().setItemStack(new ItemStack(Material.AIR));
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void on(InventoryClickEvent inventoryClickEvent) {
        if (!this.hasAdaptation((Player)inventoryClickEvent.getWhoClicked())) {
            return;
        }
        if (inventoryClickEvent.getClickedInventory() != null && inventoryClickEvent.getClick().equals((Object)ClickType.SHIFT_LEFT) && inventoryClickEvent.getClickedInventory().getItem(inventoryClickEvent.getSlot()) != null && inventoryClickEvent.getAction().equals((Object)InventoryAction.MOVE_TO_OTHER_INVENTORY)) {
            ItemStack itemStack = inventoryClickEvent.getWhoClicked().getItemOnCursor().clone();
            ItemStack itemStack2 = inventoryClickEvent.getClickedInventory().getItem(inventoryClickEvent.getSlot()).clone();
            if (itemStack.getType().equals((Object)Material.ELYTRA) || itemStack2.getType().equals((Object)Material.ELYTRA)) {
                if ((multiarmor.explode(itemStack).size() > 1 || multiarmor.explode(itemStack2).size() > 1) && ((double)multiarmor.explode(itemStack).size() >= this.getSlots(this.getLevel((Player)inventoryClickEvent.getWhoClicked())) || (double)multiarmor.explode(itemStack2).size() >= this.getSlots(this.getLevel((Player)inventoryClickEvent.getWhoClicked())))) {
                    inventoryClickEvent.setCancelled(true);
                    ((Player)inventoryClickEvent.getWhoClicked()).playSound(inventoryClickEvent.getWhoClicked().getLocation(), Sound.BLOCK_BEACON_DEACTIVATE, 1.0f, 0.77f);
                    return;
                }
                if (ItemListings.getMultiArmorable().contains(itemStack.getType()) && ItemListings.getMultiArmorable().contains(itemStack2.getType()) && !itemStack.getType().isAir() && !itemStack2.getType().isAir() && multiarmor.supportsItem(itemStack) && multiarmor.supportsItem(itemStack2)) {
                    inventoryClickEvent.setCancelled(true);
                    inventoryClickEvent.getWhoClicked().setItemOnCursor(new ItemStack(Material.AIR));
                    inventoryClickEvent.getClickedInventory().setItem(inventoryClickEvent.getSlot(), multiarmor.build(itemStack, itemStack2));
                    inventoryClickEvent.getWhoClicked().getWorld().playSound(inventoryClickEvent.getWhoClicked().getLocation(), Sound.ITEM_ARMOR_EQUIP_ELYTRA, 1.0f, 0.77f);
                }
            }
        }
    }

    private boolean validateArmor(ItemStack itemStack) {
        if (itemStack.getItemMeta() != null && itemStack.getItemMeta().getLore() != null && itemStack.getItemMeta().getLore().get(0) != null) {
            return ((String)itemStack.getItemMeta().getLore().get(0)).contains("MultiArmor");
        }
        return false;
    }

    private double getSlots(double d) {
        return (double)((Config)this.getConfig()).startingSlots + d;
    }

    @Override
    public boolean isPermanent() {
        return ((Config)this.getConfig()).permanent;
    }

    static {
        IBootstrap.dasBoot();
        multiarmor = new MultiArmor();
    }

    protected static class Config {
        boolean permanent = false;
        boolean enabled = true;
        int baseCost = 1;
        int initialCost = 3;
        double costFactor = 1.0;
        int maxLevel = 1;
        int startingSlots = 1;

        static {
            IBootstrap.dasBoot();
        }
    }
}

