/*
 * Decompiled with CFR 0.152.
 */
package com.volmit.adapt.content.adaptation.brewing;

import com.volmit.adapt.Adapt;
import com.volmit.adapt.api.adaptation.SimpleAdaptation;
import com.volmit.adapt.api.data.WorldData;
import com.volmit.adapt.api.world.PlayerAdaptation;
import com.volmit.adapt.api.world.PlayerData;
import com.volmit.adapt.content.matter.BrewingStandOwner;
import com.volmit.adapt.util.C;
import com.volmit.adapt.util.Element;
import com.volmit.adapt.util.Form;
import com.volmit.adapt.util.J;
import com.volmit.adapt.util.Localizer;
import com.volmit.adapt.util.manifold.rt.api.IBootstrap;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.block.BrewingStand;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.inventory.BrewEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.PotionMeta;
import org.bukkit.potion.PotionEffect;

public class BrewingLingering
extends SimpleAdaptation<Config> {
    public BrewingLingering() {
        super("brewing-lingering");
        this.registerConfiguration(Config.class);
        this.setDescription(Localizer.dLocalize("brewing", "lingering", "description"));
        this.setDisplayName(Localizer.dLocalize("brewing", "lingering", "name"));
        this.setIcon(Material.CLOCK);
        this.setBaseCost(((Config)this.getConfig()).baseCost);
        this.setCostFactor(((Config)this.getConfig()).costFactor);
        this.setMaxLevel(((Config)this.getConfig()).maxLevel);
        this.setInitialCost(((Config)this.getConfig()).initialCost);
        this.setInterval(4788L);
    }

    @Override
    public void addStats(int n, Element element) {
        element.addLore(C.GREEN + "+ " + Form.duration((long)this.getDurationBoost(this.getLevelPercent(n)), 0) + C.GRAY + " " + Localizer.dLocalize("brewing", "lingering", "lore1"));
        element.addLore(C.GREEN + "+ " + Form.pc(this.getPercentBoost(this.getLevelPercent(n)), 0) + C.GRAY + " " + Localizer.dLocalize("brewing", "lingering", "lore2"));
    }

    public double getDurationBoost(double d) {
        return ((Config)this.getConfig()).durationBoostFactorTicks * d + ((Config)this.getConfig()).baseDurationBoostTicks;
    }

    public double getPercentBoost(double d) {
        return 1.0 + (d * d * ((Config)this.getConfig()).durationMultiplierFactor + ((Config)this.getConfig()).baseDurationMultiplier);
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void on(BrewEvent brewEvent) {
        if (brewEvent.isCancelled()) {
            return;
        }
        if (brewEvent.getBlock().getType().equals((Object)Material.BREWING_STAND)) {
            BrewingStandOwner brewingStandOwner = WorldData.of(brewEvent.getBlock().getWorld()).getMantle().get(brewEvent.getBlock().getX(), brewEvent.getBlock().getY(), brewEvent.getBlock().getZ(), BrewingStandOwner.class);
            if (brewingStandOwner != null) {
                J.s(() -> {
                    PlayerData playerData = null;
                    ItemStack[] itemStackArray = ((BrewingStand)brewEvent.getBlock().getState()).getInventory().getStorageContents();
                    boolean bl = false;
                    for (int i = 0; i < itemStackArray.length; ++i) {
                        Object object;
                        ItemStack itemStack = itemStackArray[i];
                        if (itemStack == null || itemStack.getItemMeta() == null || !((object = itemStack.getItemMeta()) instanceof PotionMeta)) continue;
                        PotionMeta potionMeta = (PotionMeta)object;
                        itemStack = itemStack.clone();
                        PlayerData playerData2 = playerData = playerData == null ? this.getServer().peekData(brewingStandOwner.getOwner()) : playerData;
                        if (!playerData.getSkillLines().containsKey(this.getSkill().getName()) || !playerData.getSkillLine(this.getSkill().getName()).getAdaptations().containsKey(this.getName()) || ((PlayerAdaptation)(object = playerData.getSkillLine(this.getSkill().getName()).getAdaptations().get(this.getName()))).getLevel() <= 0) continue;
                        double d = this.getLevelPercent(((PlayerAdaptation)object).getLevel());
                        bl = this.enhance(d, itemStack, potionMeta) || bl;
                        itemStackArray[i] = itemStack;
                    }
                    if (bl) {
                        ((BrewingStand)brewEvent.getBlock().getState()).getInventory().setStorageContents(itemStackArray);
                        brewEvent.getBlock().getWorld().playSound(brewEvent.getBlock().getLocation(), Sound.BLOCK_BREWING_STAND_BREW, 1.0f, 0.75f);
                        brewEvent.getBlock().getWorld().playSound(brewEvent.getBlock().getLocation(), Sound.BLOCK_BREWING_STAND_BREW, 1.0f, 1.75f);
                    }
                });
            } else {
                Adapt.verbose("No Owner");
            }
        }
    }

    private boolean enhance(double d, ItemStack itemStack, PotionMeta potionMeta) {
        PotionEffect potionEffect;
        if (!potionMeta.getBasePotionData().getType().isInstant() && (potionEffect = this.getRawPotionEffect(itemStack)) != null) {
            potionMeta.addCustomEffect(new PotionEffect(potionEffect.getType(), (int)(this.getDurationBoost(d) + (double)potionEffect.getDuration() * this.getPercentBoost(d)), potionEffect.getAmplifier()), true);
            itemStack.setItemMeta((ItemMeta)potionMeta);
            return true;
        }
        return false;
    }

    @Override
    public void onTick() {
    }

    @Override
    public boolean isEnabled() {
        return ((Config)this.getConfig()).enabled;
    }

    @Override
    public boolean isPermanent() {
        return ((Config)this.getConfig()).permanent;
    }

    static {
        IBootstrap.dasBoot();
    }

    protected static class Config {
        boolean permanent = false;
        boolean enabled = true;
        int baseCost = 3;
        double costFactor = 0.75;
        int maxLevel = 5;
        int initialCost = 5;
        double baseDurationBoostTicks = 100.0;
        double durationBoostFactorTicks = 500.0;
        double durationMultiplierFactor = 0.45;
        double baseDurationMultiplier = 0.05;

        static {
            IBootstrap.dasBoot();
        }
    }
}

