/*
 * Decompiled with CFR 0.152.
 */
package com.volmit.adapt.content.adaptation.brewing;

import com.volmit.adapt.api.adaptation.SimpleAdaptation;
import com.volmit.adapt.api.data.WorldData;
import com.volmit.adapt.api.world.PlayerData;
import com.volmit.adapt.content.matter.BrewingStandOwner;
import com.volmit.adapt.util.C;
import com.volmit.adapt.util.Element;
import com.volmit.adapt.util.Form;
import com.volmit.adapt.util.J;
import com.volmit.adapt.util.Localizer;
import com.volmit.adapt.util.M;
import com.volmit.adapt.util.RNG;
import com.volmit.adapt.util.manifold.rt.api.IBootstrap;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.BlockState;
import org.bukkit.block.BrewingStand;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.inventory.BrewEvent;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryMoveItemEvent;
import org.bukkit.event.inventory.InventoryType;

public class BrewingSuperHeated
extends SimpleAdaptation<Config> {
    private static final int MAX_CHECKS_BEFORE_REMOVE = 20;
    private final Map<Block, Integer> activeStands = new HashMap<Block, Integer>();

    public BrewingSuperHeated() {
        super("brewing-super-heated");
        this.registerConfiguration(Config.class);
        this.setDescription(Localizer.dLocalize("brewing", "superheated", "description"));
        this.setDisplayName(Localizer.dLocalize("brewing", "superheated", "name"));
        this.setIcon(Material.LAVA_BUCKET);
        this.setBaseCost(((Config)this.getConfig()).baseCost);
        this.setCostFactor(((Config)this.getConfig()).costFactor);
        this.setMaxLevel(((Config)this.getConfig()).maxLevel);
        this.setInitialCost(((Config)this.getConfig()).initialCost);
        this.setInterval(253L);
    }

    @Override
    public void addStats(int n, Element element) {
        element.addLore(C.GREEN + "+ " + Form.pc(this.getFireBoost(this.getLevelPercent(n)), 0) + C.GRAY + " " + Localizer.dLocalize("brewing", "superheated", "lore1"));
        element.addLore(C.GREEN + "+ " + Form.pc(this.getLavaBoost(this.getLevelPercent(n)), 0) + C.GRAY + " " + Localizer.dLocalize("brewing", "superheated", "lore2"));
    }

    public double getLavaBoost(double d) {
        return ((Config)this.getConfig()).lavaMultiplier * (((Config)this.getConfig()).multiplierFactor * d);
    }

    public double getFireBoost(double d) {
        return ((Config)this.getConfig()).fireMultiplier * (((Config)this.getConfig()).multiplierFactor * d);
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void on(InventoryMoveItemEvent inventoryMoveItemEvent) {
        if (inventoryMoveItemEvent.isCancelled()) {
            return;
        }
        J.s(() -> {
            if (inventoryMoveItemEvent.getDestination().getType().equals((Object)InventoryType.BREWING)) {
                this.activeStands.put(inventoryMoveItemEvent.getDestination().getLocation().getBlock(), 20);
            }
        });
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void on(BrewEvent brewEvent) {
        if (brewEvent.isCancelled()) {
            return;
        }
        J.s(() -> {
            if (((BrewingStand)brewEvent.getBlock().getState()).getBrewingTime() > 0) {
                this.activeStands.put(brewEvent.getBlock(), 20);
            }
        });
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void on(InventoryClickEvent inventoryClickEvent) {
        if (inventoryClickEvent.getClickedInventory() == null || inventoryClickEvent.isCancelled()) {
            return;
        }
        if (inventoryClickEvent.getView().getTopInventory().getType().equals((Object)InventoryType.BREWING)) {
            this.activeStands.put(inventoryClickEvent.getView().getTopInventory().getLocation().getBlock(), 20);
        }
    }

    @Override
    public void onTick() {
        if (this.activeStands.isEmpty()) {
            return;
        }
        Iterator<Block> iterator = this.activeStands.keySet().iterator();
        J.s(() -> {
            while (iterator.hasNext()) {
                BlockState blockState = ((Block)iterator.next()).getState();
                if (blockState instanceof BrewingStand) {
                    BrewingStand brewingStand = (BrewingStand)blockState;
                    if (brewingStand.getBrewingTime() <= 0) {
                        J.s(() -> {
                            BrewingStand brewingStand2 = (BrewingStand)blockState.getBlock().getState();
                            if (brewingStand2.getBrewingTime() <= 0) {
                                if (this.activeStands.get(brewingStand.getBlock()) == 0) {
                                    this.activeStands.remove(brewingStand.getBlock());
                                }
                                if (this.activeStands.containsKey(brewingStand.getBlock())) {
                                    this.activeStands.put(brewingStand.getBlock(), this.activeStands.get(brewingStand.getBlock()) - 1);
                                }
                            }
                        });
                        continue;
                    }
                    BrewingStandOwner brewingStandOwner = WorldData.of(brewingStand.getWorld()).getMantle().get(brewingStand.getX(), brewingStand.getY(), brewingStand.getZ(), BrewingStandOwner.class);
                    if (brewingStandOwner == null) {
                        iterator.remove();
                        continue;
                    }
                    PlayerData playerData = this.getServer().peekData(brewingStandOwner.getOwner());
                    if (playerData.getSkillLines().get(this.getSkill().getName()) != null && playerData.getSkillLines().get(this.getSkill().getName()).getAdaptations().containsKey(this.getName()) && playerData.getSkillLines().get(this.getSkill().getName()).getAdaptations().get(this.getName()).getLevel() > 0) {
                        this.updateHeat(brewingStand, this.getLevelPercent(playerData.getSkillLines().get(this.getSkill().getName()).getAdaptations().get(this.getName()).getLevel()));
                        continue;
                    }
                    iterator.remove();
                    continue;
                }
                iterator.remove();
            }
        });
    }

    private void updateHeat(BrewingStand brewingStand, double d) {
        double d2 = 0.0;
        double d3 = 0.0;
        switch (brewingStand.getBlock().getRelative(BlockFace.DOWN).getType()) {
            case LAVA: {
                d2 += 1.0;
                break;
            }
            case FIRE: {
                d3 += 1.0;
            }
        }
        switch (brewingStand.getBlock().getRelative(BlockFace.NORTH).getType()) {
            case LAVA: {
                d2 += 1.0;
                break;
            }
            case FIRE: {
                d3 += 1.0;
            }
        }
        switch (brewingStand.getBlock().getRelative(BlockFace.SOUTH).getType()) {
            case LAVA: {
                d2 += 1.0;
                break;
            }
            case FIRE: {
                d3 += 1.0;
            }
        }
        switch (brewingStand.getBlock().getRelative(BlockFace.EAST).getType()) {
            case LAVA: {
                d2 += 1.0;
                break;
            }
            case FIRE: {
                d3 += 1.0;
            }
        }
        switch (brewingStand.getBlock().getRelative(BlockFace.WEST).getType()) {
            case LAVA: {
                d2 += 1.0;
                break;
            }
            case FIRE: {
                d3 += 1.0;
            }
        }
        double d4 = this.getFireBoost(d) * d3 + this.getLavaBoost(d) * d2 + 1.0;
        int n = (int)((double)this.getInterval() / 50.0 * d4);
        brewingStand.setBrewingTime(Math.max(1, brewingStand.getBrewingTime() - n));
        brewingStand.update();
        if (M.r(1.0 / (333.0 / (double)this.getInterval()))) {
            brewingStand.getBlock().getWorld().playSound(brewingStand.getBlock().getLocation(), Sound.BLOCK_FIRE_AMBIENT, 1.0f, 1.0f + RNG.r.f(0.3f, 0.6f));
        }
    }

    @Override
    public boolean isEnabled() {
        return ((Config)this.getConfig()).enabled;
    }

    @Override
    public boolean isPermanent() {
        return ((Config)this.getConfig()).permanent;
    }

    static {
        IBootstrap.dasBoot();
    }

    protected static class Config {
        boolean permanent = false;
        boolean enabled = true;
        int baseCost = 3;
        double costFactor = 0.75;
        int maxLevel = 5;
        int initialCost = 5;
        double multiplierFactor = 1.33;
        double fireMultiplier = 0.14;
        double lavaMultiplier = 0.69;

        static {
            IBootstrap.dasBoot();
        }
    }
}

