/*
 * Decompiled with CFR 0.152.
 */
package com.volmit.adapt.content.adaptation.crafting;

import com.volmit.adapt.api.adaptation.SimpleAdaptation;
import com.volmit.adapt.util.C;
import com.volmit.adapt.util.Element;
import com.volmit.adapt.util.J;
import com.volmit.adapt.util.Localizer;
import com.volmit.adapt.util.manifold.rt.api.IBootstrap;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.Recipe;
import org.bukkit.inventory.ShapedRecipe;
import org.bukkit.inventory.ShapelessRecipe;
import org.bukkit.inventory.SmithingInventory;

public class CraftingDeconstruction
extends SimpleAdaptation<Config> {
    private final List<Integer> holds = new ArrayList<Integer>();

    public CraftingDeconstruction() {
        super("crafting-deconstruction");
        this.registerConfiguration(Config.class);
        this.setDescription(Localizer.dLocalize("crafting", "deconstruction", "description"));
        this.setDisplayName(Localizer.dLocalize("crafting", "deconstruction", "name"));
        this.setIcon(Material.SHEARS);
        this.setBaseCost(((Config)this.getConfig()).baseCost);
        this.setMaxLevel(1);
        this.setInterval(5590L);
        this.setInitialCost(((Config)this.getConfig()).initialCost);
        this.setCostFactor(((Config)this.getConfig()).costFactor);
    }

    @Override
    public void addStats(int n, Element element) {
        element.addLore(C.GREEN + Localizer.dLocalize("crafting", "deconstruction", "lore1"));
        element.addLore(C.GREEN + Localizer.dLocalize("crafting", "deconstruction", "lore2"));
    }

    public ItemStack getDeconstructionOffering(ItemStack itemStack2) {
        ShapedRecipe shapedRecipe;
        ShapelessRecipe shapelessRecipe;
        if (itemStack2 == null) {
            return null;
        }
        int n = 0;
        Recipe recipe = null;
        for (Recipe recipe2 : Bukkit.getRecipesFor((ItemStack)itemStack2)) {
            int n2;
            if (recipe2 instanceof ShapelessRecipe) {
                shapelessRecipe = (ShapelessRecipe)recipe2;
                n2 = shapelessRecipe.getIngredientList().stream().mapToInt(itemStack -> itemStack.getAmount()).sum();
                if (n2 <= n) continue;
                recipe = recipe2;
                n = n2;
                continue;
            }
            if (!(recipe2 instanceof ShapedRecipe) || (n2 = (shapedRecipe = (ShapedRecipe)recipe2).getIngredientMap().values().stream().mapToInt(itemStack -> itemStack == null ? 0 : itemStack.getAmount()).sum()) <= n) continue;
            recipe = recipe2;
            n = n2;
        }
        if (recipe == null) {
            return null;
        }
        int n3 = 0;
        int n4 = 1;
        shapelessRecipe = null;
        if (recipe instanceof ShapelessRecipe) {
            shapedRecipe = (ShapelessRecipe)recipe;
            for (ItemStack itemStack3 : shapedRecipe.getIngredientList()) {
                if (itemStack3.getAmount() * itemStack2.getAmount() <= n3) continue;
                n3 = itemStack3.getAmount() * itemStack2.getAmount();
                shapelessRecipe = itemStack3;
                n4 = shapedRecipe.getResult().getAmount();
            }
        } else {
            ShapedRecipe shapedRecipe2 = (ShapedRecipe)recipe;
            ArrayList arrayList = new ArrayList();
            shapedRecipe2.getIngredientMap().forEach((c, itemStack) -> {
                if (itemStack == null) {
                    return;
                }
                for (ItemStack itemStack2 : arrayList) {
                    if (!itemStack.getType().equals((Object)itemStack2.getType())) continue;
                    itemStack2.setAmount(itemStack2.getAmount() + 1);
                    return;
                }
                arrayList.add(itemStack);
            });
            for (ItemStack itemStack4 : arrayList) {
                if (itemStack4 == null || itemStack4.getAmount() * itemStack2.getAmount() <= n3) continue;
                n3 = itemStack4.getAmount() * itemStack2.getAmount();
                shapelessRecipe = itemStack4;
                n4 = shapedRecipe2.getResult().getAmount();
            }
        }
        if (shapelessRecipe != null && shapelessRecipe.getAmount() * itemStack2.getAmount() > 1) {
            int n5 = (shapelessRecipe = shapelessRecipe.clone()).getAmount() * itemStack2.getAmount() / n4 / 2;
            if (n5 > shapelessRecipe.getMaxStackSize()) {
                return null;
            }
            shapelessRecipe.setAmount(n5);
            if (this.getValue((ItemStack)shapelessRecipe) >= this.getValue(itemStack2)) {
                return null;
            }
            return shapelessRecipe;
        }
        return null;
    }

    public int getShearDamage(ItemStack itemStack) {
        return itemStack.getAmount() * 8;
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void on(InventoryClickEvent inventoryClickEvent) {
        SmithingInventory smithingInventory;
        if (inventoryClickEvent.getClickedInventory() == null || inventoryClickEvent.isCancelled()) {
            return;
        }
        if (!this.hasAdaptation((Player)inventoryClickEvent.getWhoClicked())) {
            return;
        }
        if (inventoryClickEvent.getView().getTopInventory().getType().equals((Object)InventoryType.SMITHING)) {
            smithingInventory = (SmithingInventory)inventoryClickEvent.getView().getTopInventory();
            J.s(() -> {
                if (smithingInventory.getItem(1) != null && smithingInventory.getItem(1).getType().equals((Object)Material.SHEARS) && smithingInventory.getItem(0) != null) {
                    smithingInventory.setResult(this.getDeconstructionOffering(smithingInventory.getItem(0)));
                }
            });
        }
        if (inventoryClickEvent.getClickedInventory() != null && inventoryClickEvent.getClickedInventory().getType().equals((Object)InventoryType.SMITHING)) {
            ItemStack itemStack;
            smithingInventory = (SmithingInventory)inventoryClickEvent.getClickedInventory();
            if (inventoryClickEvent.getSlotType().equals((Object)InventoryType.SlotType.CRAFTING)) {
                J.s(() -> {
                    if (smithingInventory.getItem(1) != null && smithingInventory.getItem(1).getType().equals((Object)Material.SHEARS) && smithingInventory.getItem(0) != null) {
                        smithingInventory.setResult(this.getDeconstructionOffering(smithingInventory.getItem(0)));
                    }
                });
            } else if (inventoryClickEvent.getSlotType().equals((Object)InventoryType.SlotType.RESULT) && smithingInventory.getItem(1) != null && smithingInventory.getItem(1).getType().equals((Object)Material.SHEARS) && smithingInventory.getItem(0) != null && (itemStack = this.getDeconstructionOffering(smithingInventory.getItem(0))) != null) {
                smithingInventory.setItem(1, this.damage(smithingInventory.getItem(1), smithingInventory.getItem(0).getAmount()));
                inventoryClickEvent.setCursor(itemStack);
                inventoryClickEvent.getClickedInventory().setItem(0, null);
                inventoryClickEvent.getWhoClicked().getWorld().playSound(inventoryClickEvent.getClickedInventory().getLocation(), Sound.BLOCK_BASALT_BREAK, 1.0f, 0.2f);
                inventoryClickEvent.getWhoClicked().getWorld().playSound(inventoryClickEvent.getClickedInventory().getLocation(), Sound.BLOCK_BEEHIVE_SHEAR, 1.0f, 0.7f);
                this.getSkill().xp((Player)inventoryClickEvent.getWhoClicked(), this.getValue(itemStack));
            }
        }
    }

    private void updateOffering(Inventory inventory) {
        SmithingInventory smithingInventory = (SmithingInventory)inventory;
        if (smithingInventory.getItem(1) != null && smithingInventory.getItem(1).getType().equals((Object)Material.SHEARS) && smithingInventory.getItem(0) != null) {
            ItemStack itemStack = this.getDeconstructionOffering(smithingInventory.getItem(0));
            smithingInventory.setResult(itemStack);
        }
    }

    @Override
    public void onTick() {
    }

    @Override
    public boolean isEnabled() {
        return ((Config)this.getConfig()).enabled;
    }

    @Override
    public boolean isPermanent() {
        return ((Config)this.getConfig()).permanent;
    }

    static {
        IBootstrap.dasBoot();
    }

    protected static class Config {
        boolean permanent = false;
        boolean enabled = true;
        int baseCost = 9;
        int initialCost = 8;
        double costFactor = 1.355;

        static {
            IBootstrap.dasBoot();
        }
    }
}

