/*
 * Decompiled with CFR 0.152.
 */
package com.volmit.adapt.content.adaptation.excavation;

import com.volmit.adapt.Adapt;
import com.volmit.adapt.api.adaptation.SimpleAdaptation;
import com.volmit.adapt.content.item.ItemListings;
import com.volmit.adapt.content.item.multiItems.OmniTool;
import com.volmit.adapt.util.C;
import com.volmit.adapt.util.Element;
import com.volmit.adapt.util.J;
import com.volmit.adapt.util.Localizer;
import com.volmit.adapt.util.manifold.rt.api.IBootstrap;
import java.util.List;
import java.util.Map;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.block.Block;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.block.Action;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockDamageEvent;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.InventoryAction;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.player.PlayerDropItemEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.Damageable;
import org.bukkit.inventory.meta.ItemMeta;

public class ExcavationOmniTool
extends SimpleAdaptation<Config> {
    private static final OmniTool omniTool;

    public ExcavationOmniTool() {
        super("excavation-omnitool");
        this.registerConfiguration(Config.class);
        this.setDisplayName(Localizer.dLocalize("excavation", "omnitool", "name"));
        this.setDescription(Localizer.dLocalize("excavation", "omnitool", "description"));
        this.setIcon(Material.DISC_FRAGMENT_5);
        this.setInterval(20202L);
        this.setBaseCost(((Config)this.getConfig()).baseCost);
        this.setMaxLevel(((Config)this.getConfig()).maxLevel);
        this.setInitialCost(((Config)this.getConfig()).initialCost);
        this.setCostFactor(((Config)this.getConfig()).costFactor);
    }

    @Override
    public void addStats(int n, Element element) {
        element.addLore(C.GRAY + Localizer.dLocalize("excavation", "omnitool", "lore1"));
        element.addLore(C.GRAY + Localizer.dLocalize("excavation", "omnitool", "lore2"));
        element.addLore(C.GREEN + Localizer.dLocalize("excavation", "omnitool", "lore3"));
        element.addLore(C.RED + Localizer.dLocalize("excavation", "omnitool", "lore4"));
        element.addLore(C.GRAY + Localizer.dLocalize("excavation", "omnitool", "lore5"));
        element.addLore(C.GREEN + (n + ((Config)this.getConfig()).startingSlots) + C.GRAY + " " + Localizer.dLocalize("excavation", "omnitool", "lore6"));
        element.addLore(C.UNDERLINE + Localizer.dLocalize("excavation", "omnitool", "lore7"));
    }

    @Override
    public boolean isEnabled() {
        return ((Config)this.getConfig()).enabled;
    }

    @Override
    public void onTick() {
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void on(EntityDamageByEntityEvent entityDamageByEntityEvent) {
        Player player;
        Entity entity = entityDamageByEntityEvent.getDamager();
        if (entity instanceof Player && this.validateTool((player = (Player)entity).getInventory().getItemInMainHand())) {
            if (player.getInventory().getItemInMainHand().getType().getMaxDurability() - player.getInventory().getItemInMainHand().getDurability() <= 2) {
                entityDamageByEntityEvent.setCancelled(true);
                return;
            }
            if (entityDamageByEntityEvent.isCancelled()) {
                return;
            }
            if (!this.hasAdaptation(player) && this.validateTool(player.getInventory().getItemInMainHand())) {
                entityDamageByEntityEvent.setCancelled(true);
                return;
            }
            if (!this.hasAdaptation(player)) {
                if (this.validateTool(player.getInventory().getItemInMainHand())) {
                    entityDamageByEntityEvent.setCancelled(true);
                }
                return;
            }
            entity = player.getInventory().getItemInMainHand();
            Damageable damageable = (Damageable)entity.getItemMeta();
            if (!this.validateTool((ItemStack)entity)) {
                return;
            }
            J.s(() -> ExcavationOmniTool.lambda$on$0(player, (ItemStack)entity));
            player.getWorld().playSound(player.getLocation(), Sound.ITEM_ARMOR_EQUIP_ELYTRA, 1.0f, 0.77f);
            if (damageable != null && damageable.hasDamage() && entity.getType().getMaxDurability() - damageable.getDamage() - 2 <= 2) {
                entityDamageByEntityEvent.setCancelled(true);
                player.playSound(player.getLocation(), Sound.ENTITY_IRON_GOLEM_STEP, 0.25f, 0.77f);
            }
        }
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void on(BlockBreakEvent blockBreakEvent) {
        Player player = blockBreakEvent.getPlayer();
        if (this.validateTool(player.getInventory().getItemInMainHand())) {
            if (player.getInventory().getItemInMainHand().getType().getMaxDurability() - player.getInventory().getItemInMainHand().getDurability() <= 2) {
                blockBreakEvent.setCancelled(true);
                return;
            }
            if (!this.hasAdaptation(player)) {
                blockBreakEvent.setCancelled(true);
                return;
            }
        }
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void on(PlayerInteractEvent playerInteractEvent) {
        Player player = playerInteractEvent.getPlayer();
        if (this.validateTool(player.getInventory().getItemInMainHand())) {
            if (player.getInventory().getItemInMainHand().getType().getMaxDurability() - player.getInventory().getItemInMainHand().getDurability() <= 2) {
                playerInteractEvent.setCancelled(true);
                return;
            }
            if (!this.hasAdaptation(player)) {
                return;
            }
            if (playerInteractEvent.getAction().equals((Object)Action.RIGHT_CLICK_BLOCK)) {
                ItemStack itemStack = player.getInventory().getItemInMainHand();
                Damageable damageable = (Damageable)itemStack.getItemMeta();
                Block block = playerInteractEvent.getClickedBlock();
                if (block != null) {
                    if (ItemListings.farmable.contains(block.getType())) {
                        if (this.isShovel(itemStack)) {
                            J.s(() -> player.getInventory().setItemInMainHand(omniTool.nextHoe(itemStack)));
                            player.getWorld().playSound(player.getLocation(), Sound.ITEM_ARMOR_EQUIP_ELYTRA, 1.0f, 0.77f);
                        } else {
                            J.s(() -> player.getInventory().setItemInMainHand(omniTool.nextShovel(itemStack)));
                            player.getWorld().playSound(player.getLocation(), Sound.ITEM_ARMOR_EQUIP_ELYTRA, 1.0f, 0.77f);
                        }
                        if (damageable != null && damageable.hasDamage() && itemStack.getType().getMaxDurability() - damageable.getDamage() - 2 <= 2) {
                            playerInteractEvent.setCancelled(true);
                            player.playSound(player.getLocation(), Sound.ENTITY_IRON_GOLEM_STEP, 0.25f, 0.77f);
                        }
                    } else if (ItemListings.burnable.contains(block.getType())) {
                        J.s(() -> player.getInventory().setItemInMainHand(omniTool.nextFnS(itemStack)));
                        player.getWorld().playSound(player.getLocation(), Sound.ITEM_ARMOR_EQUIP_ELYTRA, 1.0f, 0.77f);
                        if (damageable != null && damageable.hasDamage() && itemStack.getType().getMaxDurability() - damageable.getDamage() - 2 <= 2) {
                            playerInteractEvent.setCancelled(true);
                            player.playSound(player.getLocation(), Sound.ENTITY_IRON_GOLEM_STEP, 0.25f, 0.77f);
                        }
                    }
                }
            }
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void on(PlayerDropItemEvent playerDropItemEvent) {
        Player player = playerDropItemEvent.getPlayer();
        if (!this.hasAdaptation(player)) {
            return;
        }
        if (player.isSneaking() && this.validateTool(playerDropItemEvent.getItemDrop().getItemStack())) {
            List<ItemStack> list = omniTool.explode(playerDropItemEvent.getItemDrop().getItemStack());
            for (ItemStack itemStack : list) {
                Damageable damageable = (Damageable)itemStack.getItemMeta();
                if (itemStack.hasItemMeta()) {
                    ItemMeta itemMeta;
                    ItemMeta itemMeta2 = itemMeta = itemStack.getItemMeta().clone();
                    if (itemMeta.hasDisplayName()) {
                        itemMeta2.setDisplayName(itemMeta.getDisplayName());
                    }
                    if (itemMeta.hasEnchants()) {
                        Map map = itemMeta.getEnchants();
                        for (Enchantment enchantment : map.keySet()) {
                            itemMeta2.addEnchant(enchantment, ((Integer)map.get(enchantment)).intValue(), true);
                        }
                    }
                    if (damageable != null && damageable.hasDamage()) {
                        ((Damageable)itemMeta2).setDamage(damageable.getDamage());
                    }
                    itemMeta2.setLore(null);
                    itemStack.setItemMeta(itemMeta2);
                }
                list.set(list.indexOf(itemStack), itemStack);
            }
            J.s(() -> {
                player.playSound(player.getLocation(), Sound.ENTITY_IRON_GOLEM_DEATH, 0.25f, 0.77f);
                for (ItemStack itemStack : list) {
                    player.getWorld().dropItem(player.getLocation(), itemStack);
                }
            });
            playerDropItemEvent.getItemDrop().setItemStack(new ItemStack(Material.AIR));
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void on(BlockDamageEvent blockDamageEvent) {
        Player player = blockDamageEvent.getPlayer();
        Block block = blockDamageEvent.getBlock();
        ItemStack itemStack = player.getInventory().getItemInMainHand();
        if (this.validateTool(itemStack)) {
            if (blockDamageEvent.isCancelled()) {
                return;
            }
            if (!this.hasAdaptation(player)) {
                return;
            }
            Damageable damageable = (Damageable)itemStack.getItemMeta();
            if (ItemListings.getAxePreference().contains(block.getType())) {
                if (!this.isAxe(itemStack)) {
                    Adapt.verbose("Omnitool for " + player.getName() + " changed to axe");
                    J.s(() -> player.getInventory().setItemInMainHand(omniTool.nextAxe(itemStack)));
                    this.itemDelegate(blockDamageEvent, itemStack, damageable);
                } else {
                    Adapt.verbose("Omnitool for " + player.getName() + " is already axe");
                }
            } else if (ItemListings.getShovelPreference().contains(block.getType())) {
                if (!this.isShovel(itemStack)) {
                    Adapt.verbose("Omnitool for " + player.getName() + " changed to shovel");
                    J.s(() -> player.getInventory().setItemInMainHand(omniTool.nextShovel(itemStack)));
                    this.itemDelegate(blockDamageEvent, itemStack, damageable);
                } else {
                    Adapt.verbose("Omnitool for " + player.getName() + " is already shovel");
                }
            } else if (ItemListings.getSwordPreference().contains(block.getType())) {
                if (!this.isSword(itemStack)) {
                    Adapt.verbose("Omnitool for " + player.getName() + " changed to sword");
                    J.s(() -> player.getInventory().setItemInMainHand(omniTool.nextSword(itemStack)));
                    this.itemDelegate(blockDamageEvent, itemStack, damageable);
                } else {
                    Adapt.verbose("Omnitool for " + player.getName() + " is already sword");
                }
            } else if (!this.isPickaxe(itemStack)) {
                Adapt.verbose("Omnitool for " + player.getName() + " changed to pickaxe");
                J.s(() -> player.getInventory().setItemInMainHand(omniTool.nextPickaxe(itemStack)));
                this.itemDelegate(blockDamageEvent, itemStack, damageable);
            }
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void on(InventoryClickEvent inventoryClickEvent) {
        if (!this.hasAdaptation((Player)inventoryClickEvent.getWhoClicked())) {
            return;
        }
        if (inventoryClickEvent.getClickedInventory() != null && inventoryClickEvent.getClick().equals((Object)ClickType.SHIFT_LEFT) && inventoryClickEvent.getAction().equals((Object)InventoryAction.MOVE_TO_OTHER_INVENTORY)) {
            ItemStack itemStack = inventoryClickEvent.getWhoClicked().getItemOnCursor().clone();
            ItemStack itemStack2 = inventoryClickEvent.getClickedInventory().getItem(inventoryClickEvent.getSlot()).clone();
            if ((omniTool.explode(itemStack).size() > 1 || omniTool.explode(itemStack2).size() > 1) && ((double)omniTool.explode(itemStack).size() >= this.getSlots(this.getLevel((Player)inventoryClickEvent.getWhoClicked())) || (double)omniTool.explode(itemStack2).size() >= this.getSlots(this.getLevel((Player)inventoryClickEvent.getWhoClicked())))) {
                inventoryClickEvent.setCancelled(true);
                ((Player)inventoryClickEvent.getWhoClicked()).playSound(inventoryClickEvent.getWhoClicked().getLocation(), Sound.BLOCK_BEACON_DEACTIVATE, 1.0f, 0.77f);
                return;
            }
            if (ItemListings.tool.contains(itemStack.getType()) && ItemListings.tool.contains(itemStack2.getType()) && !itemStack.getType().isAir() && !itemStack2.getType().isAir() && omniTool.supportsItem(itemStack) && omniTool.supportsItem(itemStack2)) {
                inventoryClickEvent.setCancelled(true);
                inventoryClickEvent.getWhoClicked().setItemOnCursor(new ItemStack(Material.AIR));
                inventoryClickEvent.getClickedInventory().setItem(inventoryClickEvent.getSlot(), omniTool.build(itemStack, itemStack2));
                inventoryClickEvent.getWhoClicked().getWorld().playSound(inventoryClickEvent.getWhoClicked().getLocation(), Sound.ITEM_ARMOR_EQUIP_ELYTRA, 1.0f, 0.77f);
            }
        }
    }

    private void itemDelegate(BlockDamageEvent blockDamageEvent, ItemStack itemStack, Damageable damageable) {
        Player player = blockDamageEvent.getPlayer();
        player.getWorld().playSound(player.getLocation(), Sound.ITEM_ARMOR_EQUIP_ELYTRA, 1.0f, 0.77f);
        if (damageable != null && damageable.hasDamage() && itemStack.getType().getMaxDurability() - damageable.getDamage() - 2 <= 2) {
            blockDamageEvent.setCancelled(true);
            player.playSound(player.getLocation(), Sound.ENTITY_IRON_GOLEM_STEP, 0.25f, 0.77f);
        }
    }

    private boolean validateTool(ItemStack itemStack) {
        return itemStack.getItemMeta() != null && itemStack.getItemMeta().getLore() != null && itemStack.getItemMeta().getLore().toString().contains("Leatherman");
    }

    private double getSlots(double d) {
        return (double)((Config)this.getConfig()).startingSlots + d;
    }

    @Override
    public boolean isPermanent() {
        return ((Config)this.getConfig()).permanent;
    }

    private static /* synthetic */ void lambda$on$0(Player player, ItemStack itemStack) {
        player.getInventory().setItemInMainHand(omniTool.nextSword(itemStack));
    }

    static {
        IBootstrap.dasBoot();
        omniTool = new OmniTool();
    }

    protected static class Config {
        boolean permanent = false;
        boolean enabled = true;
        int baseCost = 10;
        int initialCost = 3;
        double costFactor = 0.2;
        int maxLevel = 5;
        int startingSlots = 1;

        static {
            IBootstrap.dasBoot();
        }
    }
}

