/*
 * Decompiled with CFR 0.152.
 */
package com.volmit.adapt.content.adaptation.herbalism;

import com.volmit.adapt.api.adaptation.SimpleAdaptation;
import com.volmit.adapt.content.item.ItemListings;
import com.volmit.adapt.util.C;
import com.volmit.adapt.util.Element;
import com.volmit.adapt.util.Localizer;
import com.volmit.adapt.util.manifold.rt.api.IBootstrap;
import org.bukkit.Color;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.player.PlayerItemConsumeEvent;

public class HerbalismHungryHippo
extends SimpleAdaptation<Config> {
    public HerbalismHungryHippo() {
        super("herbalism-hippo");
        this.registerConfiguration(Config.class);
        this.setDescription(Localizer.dLocalize("herbalism", "hippo", "description"));
        this.setDisplayName(Localizer.dLocalize("herbalism", "hippo", "name"));
        this.setIcon(Material.POTATO);
        this.setBaseCost(((Config)this.getConfig()).baseCost);
        this.setMaxLevel(((Config)this.getConfig()).maxLevel);
        this.setInterval(8111L);
        this.setInitialCost(((Config)this.getConfig()).initialCost);
        this.setCostFactor(((Config)this.getConfig()).costFactor);
    }

    @Override
    public void addStats(int n, Element element) {
        element.addLore(C.GREEN + "+ (" + (2 + n) + C.GRAY + " + " + Localizer.dLocalize("herbalism", "hippo", "lore1"));
    }

    @EventHandler(priority=EventPriority.NORMAL)
    public void on(PlayerItemConsumeEvent playerItemConsumeEvent) {
        if (playerItemConsumeEvent.isCancelled()) {
            return;
        }
        Player player = playerItemConsumeEvent.getPlayer();
        if (!this.hasAdaptation(player)) {
            return;
        }
        if (ItemListings.getFood().contains(playerItemConsumeEvent.getItem().getType())) {
            player.setFoodLevel(player.getFoodLevel() + 2 + this.getLevel(player));
            player.playSound(player.getLocation(), Sound.BLOCK_POINTED_DRIPSTONE_LAND, 1.0f, 0.25f);
            this.vfxFastRing(player.getLocation().add(0.0, 0.25, 0.0), 2.0, Color.GREEN);
            this.xp(player, 5.0);
        }
    }

    @Override
    public void onTick() {
    }

    @Override
    public boolean isEnabled() {
        return ((Config)this.getConfig()).enabled;
    }

    @Override
    public boolean isPermanent() {
        return ((Config)this.getConfig()).permanent;
    }

    static {
        IBootstrap.dasBoot();
    }

    protected static class Config {
        boolean permanent = false;
        boolean enabled = true;
        int baseCost = 8;
        int maxLevel = 7;
        int initialCost = 3;
        double costFactor = 0.75;

        static {
            IBootstrap.dasBoot();
        }
    }
}

