/*
 * Decompiled with CFR 0.152.
 */
package com.volmit.adapt.content.adaptation.hunter;

import com.volmit.adapt.api.adaptation.SimpleAdaptation;
import com.volmit.adapt.util.C;
import com.volmit.adapt.util.Element;
import com.volmit.adapt.util.Form;
import com.volmit.adapt.util.Localizer;
import com.volmit.adapt.util.manifold.rt.api.IBootstrap;
import org.bukkit.Material;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.entity.EntityDamageByEntityEvent;

public class HunterAdrenaline
extends SimpleAdaptation<Config> {
    public HunterAdrenaline() {
        super("hunter-adrenaline");
        this.registerConfiguration(Config.class);
        this.setDescription(Localizer.dLocalize("hunter", "adrenaline", "description"));
        this.setDisplayName(Localizer.dLocalize("hunter", "adrenaline", "name"));
        this.setIcon(Material.LEATHER_HELMET);
        this.setBaseCost(((Config)this.getConfig()).baseCost);
        this.setMaxLevel(((Config)this.getConfig()).maxLevel);
        this.setInitialCost(((Config)this.getConfig()).initialCost);
        this.setCostFactor(((Config)this.getConfig()).costFactor);
        this.setInterval(1911L);
    }

    @Override
    public void addStats(int n, Element element) {
        element.addLore(C.GREEN + "+ " + Form.pc(this.getDamage(n), 0) + C.GRAY + " " + Localizer.dLocalize("hunter", "adrenaline", "lore1"));
    }

    private double getDamage(int n) {
        return this.getLevelPercent(n) * ((Config)this.getConfig()).damageFactor + ((Config)this.getConfig()).damageBase;
    }

    @EventHandler
    public void on(EntityDamageByEntityEvent entityDamageByEntityEvent) {
        Player player;
        if (entityDamageByEntityEvent.isCancelled()) {
            return;
        }
        Entity entity = entityDamageByEntityEvent.getDamager();
        if (entity instanceof Player && this.hasAdaptation(player = (Player)entity) && this.getLevel((Player)entityDamageByEntityEvent.getDamager()) > 0) {
            double d = this.getDamage(this.getLevel(player));
            double d2 = ((Player)entityDamageByEntityEvent.getDamager()).getHealth() / ((Player)entityDamageByEntityEvent.getDamager()).getMaxHealth();
            if (d2 >= 1.0) {
                return;
            }
            entityDamageByEntityEvent.setDamage(entityDamageByEntityEvent.getDamage() * ((d *= 1.0 - d2) + 1.0));
        }
    }

    @Override
    public void onTick() {
    }

    @Override
    public boolean isEnabled() {
        return ((Config)this.getConfig()).enabled;
    }

    @Override
    public boolean isPermanent() {
        return ((Config)this.getConfig()).permanent;
    }

    static {
        IBootstrap.dasBoot();
    }

    protected static class Config {
        boolean permanent = false;
        boolean enabled = true;
        int baseCost = 4;
        int maxLevel = 5;
        int initialCost = 8;
        double costFactor = 0.4;
        double damageBase = 0.12;
        double damageFactor = 0.21;

        static {
            IBootstrap.dasBoot();
        }
    }
}

