/*
 * Decompiled with CFR 0.152.
 */
package com.volmit.adapt.content.adaptation.hunter;

import com.volmit.adapt.AdaptConfig;
import com.volmit.adapt.api.adaptation.SimpleAdaptation;
import com.volmit.adapt.util.C;
import com.volmit.adapt.util.Element;
import com.volmit.adapt.util.Localizer;
import com.volmit.adapt.util.manifold.rt.api.IBootstrap;
import org.bukkit.Material;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.potion.PotionEffectType;

public class HunterRegen
extends SimpleAdaptation<Config> {
    public HunterRegen() {
        super("hunter-regen");
        this.registerConfiguration(Config.class);
        this.setDescription(Localizer.dLocalize("hunter", "regen", "description"));
        this.setDisplayName(Localizer.dLocalize("hunter", "regen", "name"));
        this.setIcon(Material.AXOLOTL_BUCKET);
        this.setBaseCost(((Config)this.getConfig()).baseCost);
        this.setMaxLevel(((Config)this.getConfig()).maxLevel);
        this.setInitialCost(((Config)this.getConfig()).initialCost);
        this.setCostFactor(((Config)this.getConfig()).costFactor);
        this.setInterval(9744L);
    }

    @Override
    public void addStats(int n, Element element) {
        element.addLore(C.GRAY + Localizer.dLocalize("hunter", "regen", "lore1"));
        element.addLore(C.GREEN + "+ " + n + C.GRAY + Localizer.dLocalize("hunter", "regen", "lore2"));
        element.addLore(C.RED + "- " + (5 + n) + C.GRAY + Localizer.dLocalize("hunter", "regen", "lore3"));
        element.addLore(C.GRAY + "* " + n + C.GRAY + " " + Localizer.dLocalize("hunter", "regen", "lore4"));
        element.addLore(C.GRAY + "* " + n + C.GRAY + " " + Localizer.dLocalize("hunter", "regen", "lore5"));
        element.addLore(C.GRAY + "- " + n + C.RED + " " + Localizer.dLocalize("hunter", "penalty", "lore1"));
    }

    @EventHandler
    public void on(EntityDamageEvent entityDamageEvent) {
        if (entityDamageEvent.isCancelled()) {
            return;
        }
        Entity entity = entityDamageEvent.getEntity();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (this.isAdaptableDamageCause(entityDamageEvent) && this.hasAdaptation(player)) {
                if (AdaptConfig.get().isPreventHunterSkillsWhenHungerApplied() && player.hasPotionEffect(PotionEffectType.HUNGER)) {
                    return;
                }
                if (!((Config)this.getConfig()).useConsumable) {
                    if (player.getFoodLevel() == 0) {
                        if (((Config)this.getConfig()).poisonPenalty) {
                            this.addPotionStacks(player, PotionEffectType.POISON, ((Config)this.getConfig()).basePoisonFromLevel - this.getLevel(player), ((Config)this.getConfig()).baseHungerDuration, ((Config)this.getConfig()).stackPoisonPenalty);
                        }
                    } else {
                        this.addPotionStacks(player, PotionEffectType.HUNGER, ((Config)this.getConfig()).baseHungerFromLevel - this.getLevel(player), ((Config)this.getConfig()).baseHungerDuration * this.getLevel(player), ((Config)this.getConfig()).stackHungerPenalty);
                        this.addPotionStacks(player, PotionEffectType.REGENERATION, this.getLevel(player), ((Config)this.getConfig()).baseEffectbyLevel * this.getLevel(player), ((Config)this.getConfig()).stackBuff);
                    }
                } else if (((Config)this.getConfig()).consumable != null && Material.getMaterial((String)((Config)this.getConfig()).consumable) != null) {
                    entity = Material.getMaterial((String)((Config)this.getConfig()).consumable);
                    if (entity != null && player.getInventory().contains((Material)entity)) {
                        player.getInventory().removeItem(new ItemStack[]{new ItemStack((Material)entity, 1)});
                        this.addPotionStacks(player, PotionEffectType.REGENERATION, this.getLevel(player), ((Config)this.getConfig()).baseEffectbyLevel * this.getLevel(player), ((Config)this.getConfig()).stackBuff);
                    } else if (((Config)this.getConfig()).poisonPenalty) {
                        this.addPotionStacks(player, PotionEffectType.POISON, ((Config)this.getConfig()).basePoisonFromLevel - this.getLevel(player), ((Config)this.getConfig()).baseHungerDuration, ((Config)this.getConfig()).stackPoisonPenalty);
                    }
                }
            }
        }
    }

    @Override
    public void onTick() {
    }

    @Override
    public boolean isEnabled() {
        return ((Config)this.getConfig()).enabled;
    }

    @Override
    public boolean isPermanent() {
        return ((Config)this.getConfig()).permanent;
    }

    static {
        IBootstrap.dasBoot();
    }

    protected static class Config {
        boolean permanent = false;
        boolean enabled = true;
        boolean useConsumable = false;
        boolean poisonPenalty = true;
        boolean stackHungerPenalty = false;
        boolean stackPoisonPenalty = false;
        boolean stackBuff = false;
        int baseEffectbyLevel = 5;
        int baseHungerFromLevel = 10;
        int baseHungerDuration = 50;
        int basePoisonFromLevel = 6;
        String consumable = "ROTTEN_FLESH";
        int baseCost = 4;
        int maxLevel = 5;
        int initialCost = 8;
        double costFactor = 0.4;

        static {
            IBootstrap.dasBoot();
        }
    }
}

