/*
 * Decompiled with CFR 0.152.
 */
package com.volmit.adapt.content.adaptation.nether;

import com.volmit.adapt.api.adaptation.SimpleAdaptation;
import com.volmit.adapt.nms.NMS;
import com.volmit.adapt.util.C;
import com.volmit.adapt.util.Element;
import com.volmit.adapt.util.Localizer;
import com.volmit.adapt.util.M;
import com.volmit.adapt.util.manifold.rt.api.IBootstrap;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.entity.WitherSkull;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.block.Action;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.projectiles.ProjectileSource;
import org.bukkit.util.Vector;

public class NetherSkullYeet
extends SimpleAdaptation<Config> {
    private final Map<Player, Long> lastJump = new HashMap<Player, Long>();

    public NetherSkullYeet() {
        super("nether-skull-toss");
        this.registerConfiguration(Config.class);
        this.setDescription(Localizer.dLocalize("nether", "skulltoss", "description1") + C.ITALIC + " " + Localizer.dLocalize("nether", "skulltoss", "description2") + " " + C.GRAY + Localizer.dLocalize("nether", "skulltoss", "description3"));
        this.setDisplayName(Localizer.dLocalize("nether", "skulltoss", "name"));
        this.setIcon(Material.WITHER_SKELETON_SKULL);
        this.setBaseCost(((Config)this.getConfig()).baseCost);
        this.setCostFactor(((Config)this.getConfig()).costFactor);
        this.setMaxLevel(((Config)this.getConfig()).maxLevel);
        this.setInitialCost(((Config)this.getConfig()).initialCost);
        this.setInterval(2314L);
    }

    @Override
    public void addStats(int n, Element element) {
        int n2 = ((Config)this.getConfig()).getBaseCooldown() - ((Config)this.getConfig()).getLevelCooldown() * n;
        element.addLore(C.GREEN + String.valueOf(n2) + C.GRAY + " " + Localizer.dLocalize("nether", "skulltoss", "lore1"));
        element.addLore(C.GRAY + Localizer.dLocalize("nether", "skulltoss", "lore2") + C.DARK_GRAY + Localizer.dLocalize("nether", "skulltoss", "lore3") + C.GRAY + ", " + Localizer.dLocalize("nether", "skulltoss", "lore4"));
    }

    private int getCooldownDuration(Player player) {
        return (((Config)this.getConfig()).getBaseCooldown() - ((Config)this.getConfig()).getLevelCooldown() * this.getLevel(player)) * 20;
    }

    @EventHandler
    public void on(PlayerQuitEvent playerQuitEvent) {
        Player player = playerQuitEvent.getPlayer();
        this.lastJump.remove(player);
    }

    @EventHandler
    public void onRightClick(PlayerInteractEvent playerInteractEvent) {
        if (!this.hasAdaptation(playerInteractEvent.getPlayer())) {
            return;
        }
        if (playerInteractEvent.useItemInHand() == Event.Result.DENY) {
            return;
        }
        if (playerInteractEvent.getAction() != Action.LEFT_CLICK_AIR && playerInteractEvent.getAction() != Action.LEFT_CLICK_BLOCK) {
            return;
        }
        if (playerInteractEvent.getHand() != EquipmentSlot.HAND || playerInteractEvent.getItem() == null || playerInteractEvent.getMaterial() != Material.WITHER_SKELETON_SKULL) {
            return;
        }
        Player player = playerInteractEvent.getPlayer();
        if (this.lastJump.get(player) != null && M.ms() - this.lastJump.get(player) <= (long)this.getCooldownDuration(player)) {
            player.playSound((Entity)player, Sound.BLOCK_CONDUIT_DEACTIVATE, 1.0f, 1.0f);
            return;
        }
        if (this.lastJump.get(player) != null && M.ms() - this.lastJump.get(player) <= (long)this.getCooldownDuration(player)) {
            return;
        }
        if (player.hasCooldown(player.getInventory().getItemInMainHand().getType())) {
            playerInteractEvent.setCancelled(true);
            player.playSound((Entity)player, Sound.BLOCK_CONDUIT_DEACTIVATE, 1.0f, 1.0f);
            return;
        }
        NMS.get().sendCooldown(player, Material.WITHER_SKELETON_SKULL, this.getCooldownDuration(player));
        player.setCooldown(Material.WITHER_SKELETON_SKULL, this.getCooldownDuration(player));
        if (player.getGameMode() != GameMode.CREATIVE) {
            playerInteractEvent.getItem().setAmount(playerInteractEvent.getItem().getAmount() - 1);
            this.lastJump.put(player, M.ms());
        }
        Vector vector = player.getEyeLocation().getDirection();
        Location location = player.getEyeLocation().add(new Vector(0.5, -0.5, 0.5)).add(vector);
        player.getWorld().spawn(location, WitherSkull.class, witherSkull -> {
            player.playSound((Entity)witherSkull, Sound.ENTITY_WITHER_SHOOT, 1.0f, 1.0f);
            witherSkull.setRotation(player.getEyeLocation().getYaw(), player.getEyeLocation().getPitch());
            witherSkull.setCharged(false);
            witherSkull.setBounce(false);
            witherSkull.setDirection(vector);
            witherSkull.setShooter((ProjectileSource)player);
            this.xp(player, 100.0);
        });
    }

    @Override
    public boolean isEnabled() {
        return ((Config)this.getConfig()).isEnabled();
    }

    @Override
    public void onTick() {
    }

    @Override
    public boolean isPermanent() {
        return ((Config)this.getConfig()).permanent;
    }

    static {
        IBootstrap.dasBoot();
    }

    public static class Config {
        public boolean permanent = false;
        private boolean enabled = true;
        private int baseCooldown = 15;
        private int levelCooldown = 5;
        private int baseCost = 10;
        private double costFactor = 1.5;
        private int maxLevel = 3;
        private int initialCost = 5;

        public boolean isPermanent() {
            return this.permanent;
        }

        public boolean isEnabled() {
            return this.enabled;
        }

        public int getBaseCooldown() {
            return this.baseCooldown;
        }

        public int getLevelCooldown() {
            return this.levelCooldown;
        }

        public int getBaseCost() {
            return this.baseCost;
        }

        public double getCostFactor() {
            return this.costFactor;
        }

        public int getMaxLevel() {
            return this.maxLevel;
        }

        public int getInitialCost() {
            return this.initialCost;
        }

        public void setPermanent(boolean bl) {
            this.permanent = bl;
        }

        public void setEnabled(boolean bl) {
            this.enabled = bl;
        }

        public void setBaseCooldown(int n) {
            this.baseCooldown = n;
        }

        public void setLevelCooldown(int n) {
            this.levelCooldown = n;
        }

        public void setBaseCost(int n) {
            this.baseCost = n;
        }

        public void setCostFactor(double d) {
            this.costFactor = d;
        }

        public void setMaxLevel(int n) {
            this.maxLevel = n;
        }

        public void setInitialCost(int n) {
            this.initialCost = n;
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (!(object instanceof Config)) {
                return false;
            }
            Config config = (Config)object;
            if (!config.canEqual(this)) {
                return false;
            }
            if (this.isPermanent() != config.isPermanent()) {
                return false;
            }
            if (this.isEnabled() != config.isEnabled()) {
                return false;
            }
            if (this.getBaseCooldown() != config.getBaseCooldown()) {
                return false;
            }
            if (this.getLevelCooldown() != config.getLevelCooldown()) {
                return false;
            }
            if (this.getBaseCost() != config.getBaseCost()) {
                return false;
            }
            if (Double.compare(this.getCostFactor(), config.getCostFactor()) != 0) {
                return false;
            }
            if (this.getMaxLevel() != config.getMaxLevel()) {
                return false;
            }
            return this.getInitialCost() == config.getInitialCost();
        }

        protected boolean canEqual(Object object) {
            return object instanceof Config;
        }

        public int hashCode() {
            int n = 59;
            int n2 = 1;
            n2 = n2 * 59 + (this.isPermanent() ? 79 : 97);
            n2 = n2 * 59 + (this.isEnabled() ? 79 : 97);
            n2 = n2 * 59 + this.getBaseCooldown();
            n2 = n2 * 59 + this.getLevelCooldown();
            n2 = n2 * 59 + this.getBaseCost();
            long l = Double.doubleToLongBits(this.getCostFactor());
            n2 = n2 * 59 + (int)(l >>> 32 ^ l);
            n2 = n2 * 59 + this.getMaxLevel();
            n2 = n2 * 59 + this.getInitialCost();
            return n2;
        }

        public String toString() {
            return "NetherSkullYeet.Config(permanent=" + this.isPermanent() + ", enabled=" + this.isEnabled() + ", baseCooldown=" + this.getBaseCooldown() + ", levelCooldown=" + this.getLevelCooldown() + ", baseCost=" + this.getBaseCost() + ", costFactor=" + this.getCostFactor() + ", maxLevel=" + this.getMaxLevel() + ", initialCost=" + this.getInitialCost() + ")";
        }

        static {
            IBootstrap.dasBoot();
        }
    }
}

