/*
 * Decompiled with CFR 0.152.
 */
package com.volmit.adapt.content.adaptation.nether;

import com.volmit.adapt.api.adaptation.SimpleAdaptation;
import com.volmit.adapt.util.C;
import com.volmit.adapt.util.Element;
import com.volmit.adapt.util.Localizer;
import com.volmit.adapt.util.manifold.rt.api.IBootstrap;
import java.util.Random;
import org.bukkit.Material;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;

public class NetherWitherResist
extends SimpleAdaptation<Config> {
    private static final Random RANDOM;

    public NetherWitherResist() {
        super("nether-wither-resist");
        this.registerConfiguration(Config.class);
        this.setDescription(Localizer.dLocalize("nether", "witherresist", "description"));
        this.setDisplayName(Localizer.dLocalize("nether", "witherresist", "name"));
        this.setIcon(Material.NETHERITE_CHESTPLATE);
        this.setBaseCost(((Config)this.getConfig()).baseCost);
        this.setCostFactor(((Config)this.getConfig()).costFactor);
        this.setMaxLevel(((Config)this.getConfig()).maxLevel);
        this.setInitialCost(((Config)this.getConfig()).initialCost);
        this.setInterval(9283L);
    }

    @Override
    public void addStats(int n, Element element) {
        int n2 = (int)(((Config)this.getConfig()).basePieceChance + ((Config)this.getConfig()).getChanceAddition() * (double)n);
        element.addLore(C.GREEN + "+ " + n2 + "%" + C.GRAY + Localizer.dLocalize("nether", "witherresist", "lore1"));
        element.addLore(C.GRAY + " " + Localizer.dLocalize("nether", "witherresist", "lore1") + C.DARK_GRAY + Localizer.dLocalize("nether", "witherresist", "lore2"));
    }

    @EventHandler
    public void onEntityDamage(EntityDamageEvent entityDamageEvent) {
        Entity entity;
        if (entityDamageEvent.isCancelled()) {
            return;
        }
        if (entityDamageEvent.getCause() == EntityDamageEvent.DamageCause.WITHER && (entity = entityDamageEvent.getEntity()) instanceof Player) {
            Player player = (Player)entity;
            if (!this.hasAdaptation(player)) {
                return;
            }
            double d = this.getTotalChange(player);
            if ((double)RANDOM.nextInt(0, 101) <= d) {
                entityDamageEvent.setCancelled(true);
            }
        }
    }

    @Override
    public boolean isEnabled() {
        return ((Config)this.getConfig()).isEnabled();
    }

    @Override
    public void onTick() {
    }

    private double getTotalChange(Player player) {
        return this.getChance(player, EquipmentSlot.HEAD) + this.getChance(player, EquipmentSlot.CHEST) + this.getChance(player, EquipmentSlot.LEGS) + this.getChance(player, EquipmentSlot.FEET);
    }

    private double getChance(Player player, EquipmentSlot equipmentSlot) {
        if (player.getEquipment() == null) {
            return 0.0;
        }
        ItemStack itemStack = player.getEquipment().getItem(equipmentSlot);
        if (itemStack.getType() == Material.NETHERITE_HELMET || itemStack.getType() == Material.NETHERITE_CHESTPLATE || itemStack.getType() == Material.NETHERITE_LEGGINGS || itemStack.getType() == Material.NETHERITE_BOOTS) {
            return ((Config)this.getConfig()).basePieceChance + ((Config)this.getConfig()).chanceAddition * (double)this.getLevel(player);
        }
        return 0.0;
    }

    @Override
    public boolean isPermanent() {
        return ((Config)this.getConfig()).permanent;
    }

    static {
        IBootstrap.dasBoot();
        RANDOM = new Random();
    }

    public static class Config {
        public boolean permanent = false;
        private boolean enabled = true;
        private int baseCost = 3;
        private double costFactor = 1.0;
        private int maxLevel = 3;
        private int initialCost = 5;
        private double basePieceChance = 10.0;
        private double chanceAddition = 5.0;

        public boolean isPermanent() {
            return this.permanent;
        }

        public boolean isEnabled() {
            return this.enabled;
        }

        public int getBaseCost() {
            return this.baseCost;
        }

        public double getCostFactor() {
            return this.costFactor;
        }

        public int getMaxLevel() {
            return this.maxLevel;
        }

        public int getInitialCost() {
            return this.initialCost;
        }

        public double getBasePieceChance() {
            return this.basePieceChance;
        }

        public double getChanceAddition() {
            return this.chanceAddition;
        }

        public void setPermanent(boolean bl) {
            this.permanent = bl;
        }

        public void setEnabled(boolean bl) {
            this.enabled = bl;
        }

        public void setBaseCost(int n) {
            this.baseCost = n;
        }

        public void setCostFactor(double d) {
            this.costFactor = d;
        }

        public void setMaxLevel(int n) {
            this.maxLevel = n;
        }

        public void setInitialCost(int n) {
            this.initialCost = n;
        }

        public void setBasePieceChance(double d) {
            this.basePieceChance = d;
        }

        public void setChanceAddition(double d) {
            this.chanceAddition = d;
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (!(object instanceof Config)) {
                return false;
            }
            Config config = (Config)object;
            if (!config.canEqual(this)) {
                return false;
            }
            if (this.isPermanent() != config.isPermanent()) {
                return false;
            }
            if (this.isEnabled() != config.isEnabled()) {
                return false;
            }
            if (this.getBaseCost() != config.getBaseCost()) {
                return false;
            }
            if (Double.compare(this.getCostFactor(), config.getCostFactor()) != 0) {
                return false;
            }
            if (this.getMaxLevel() != config.getMaxLevel()) {
                return false;
            }
            if (this.getInitialCost() != config.getInitialCost()) {
                return false;
            }
            if (Double.compare(this.getBasePieceChance(), config.getBasePieceChance()) != 0) {
                return false;
            }
            return Double.compare(this.getChanceAddition(), config.getChanceAddition()) == 0;
        }

        protected boolean canEqual(Object object) {
            return object instanceof Config;
        }

        public int hashCode() {
            int n = 59;
            int n2 = 1;
            n2 = n2 * 59 + (this.isPermanent() ? 79 : 97);
            n2 = n2 * 59 + (this.isEnabled() ? 79 : 97);
            n2 = n2 * 59 + this.getBaseCost();
            long l = Double.doubleToLongBits(this.getCostFactor());
            n2 = n2 * 59 + (int)(l >>> 32 ^ l);
            n2 = n2 * 59 + this.getMaxLevel();
            n2 = n2 * 59 + this.getInitialCost();
            long l2 = Double.doubleToLongBits(this.getBasePieceChance());
            n2 = n2 * 59 + (int)(l2 >>> 32 ^ l2);
            long l3 = Double.doubleToLongBits(this.getChanceAddition());
            n2 = n2 * 59 + (int)(l3 >>> 32 ^ l3);
            return n2;
        }

        public String toString() {
            return "NetherWitherResist.Config(permanent=" + this.isPermanent() + ", enabled=" + this.isEnabled() + ", baseCost=" + this.getBaseCost() + ", costFactor=" + this.getCostFactor() + ", maxLevel=" + this.getMaxLevel() + ", initialCost=" + this.getInitialCost() + ", basePieceChance=" + this.getBasePieceChance() + ", chanceAddition=" + this.getChanceAddition() + ")";
        }

        static {
            IBootstrap.dasBoot();
        }
    }
}

