/*
 * Decompiled with CFR 0.152.
 */
package com.volmit.adapt.content.adaptation.pickaxe;

import com.volmit.adapt.api.adaptation.SimpleAdaptation;
import com.volmit.adapt.content.item.ItemListings;
import com.volmit.adapt.util.C;
import com.volmit.adapt.util.Element;
import com.volmit.adapt.util.Localizer;
import com.volmit.adapt.util.extensions.java.util.List.XList;
import com.volmit.adapt.util.manifold.rt.api.IBootstrap;
import java.util.List;
import org.bukkit.GameMode;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.entity.Item;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.block.BlockDropItemEvent;
import org.bukkit.inventory.ItemStack;

public class PickaxeDropToInventory
extends SimpleAdaptation<Config> {
    public PickaxeDropToInventory() {
        super("pickaxe-drop-to-inventory");
        this.registerConfiguration(Config.class);
        this.setDescription(Localizer.dLocalize("pickaxe", "droptoinventory", "description"));
        this.setDisplayName(Localizer.dLocalize("pickaxe", "droptoinventory", "name"));
        this.setIcon(Material.DIRT);
        this.setBaseCost(((Config)this.getConfig()).baseCost);
        this.setMaxLevel(((Config)this.getConfig()).maxLevel);
        this.setInitialCost(((Config)this.getConfig()).initialCost);
        this.setCostFactor(((Config)this.getConfig()).costFactor);
        this.setInterval(7944L);
    }

    @Override
    public boolean isEnabled() {
        return ((Config)this.getConfig()).enabled;
    }

    @Override
    public void addStats(int n, Element element) {
        element.addLore(C.GRAY + Localizer.dLocalize("pickaxe", "droptoinventory", "lore1"));
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void on(BlockDropItemEvent blockDropItemEvent) {
        if (blockDropItemEvent.isCancelled()) {
            return;
        }
        Player player = blockDropItemEvent.getPlayer();
        if (!this.hasAdaptation(player)) {
            return;
        }
        if (player.getGameMode() != GameMode.SURVIVAL) {
            return;
        }
        if (!this.canBlockBreak(player, blockDropItemEvent.getBlock().getLocation())) {
            return;
        }
        if (ItemListings.toolPickaxes.contains(player.getInventory().getItemInMainHand().getType())) {
            List<Item> list = XList.copy(blockDropItemEvent.getItems());
            blockDropItemEvent.getItems().clear();
            for (Item item : list) {
                player.playSound(player.getLocation(), Sound.BLOCK_CALCITE_HIT, 0.05f, 0.01f);
                if (player.getInventory().addItem(new ItemStack[]{item.getItemStack()}).isEmpty()) continue;
                player.getWorld().dropItem(player.getLocation(), item.getItemStack());
            }
        }
    }

    @Override
    public void onTick() {
    }

    @Override
    public boolean isPermanent() {
        return ((Config)this.getConfig()).permanent;
    }

    static {
        IBootstrap.dasBoot();
    }

    protected static class Config {
        boolean permanent = false;
        boolean enabled = true;
        int baseCost = 1;
        int maxLevel = 1;
        int initialCost = 3;
        double costFactor = 1.0;

        static {
            IBootstrap.dasBoot();
        }
    }
}

