/*
 * Decompiled with CFR 0.152.
 */
package com.volmit.adapt.content.adaptation.ranged;

import com.volmit.adapt.AdaptConfig;
import com.volmit.adapt.api.adaptation.SimpleAdaptation;
import com.volmit.adapt.api.advancement.AdaptAdvancement;
import com.volmit.adapt.util.C;
import com.volmit.adapt.util.Element;
import com.volmit.adapt.util.Form;
import com.volmit.adapt.util.Localizer;
import com.volmit.adapt.util.advancements.advancement.AdvancementDisplay;
import com.volmit.adapt.util.advancements.advancement.AdvancementVisibility;
import com.volmit.adapt.util.manifold.rt.api.IBootstrap;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.event.EventHandler;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.ProjectileLaunchEvent;
import org.bukkit.projectiles.ProjectileSource;

public class RangedForce
extends SimpleAdaptation<Config> {
    public RangedForce() {
        super("ranged-force");
        this.registerConfiguration(Config.class);
        this.setDescription(Localizer.dLocalize("ranged", "forceshot", "description"));
        this.setDisplayName(Localizer.dLocalize("ranged", "forceshot", "name"));
        this.setIcon(Material.ARROW);
        this.setBaseCost(((Config)this.getConfig()).baseCost);
        this.setMaxLevel(((Config)this.getConfig()).maxLevel);
        this.setInterval(4900L);
        this.setInitialCost(((Config)this.getConfig()).initialCost);
        this.setCostFactor(((Config)this.getConfig()).costFactor);
        this.registerAdvancement(AdaptAdvancement.builder().icon(Material.SPECTRAL_ARROW).key("challenge_force_30").title(Localizer.dLocalize("ranged", "forceshot", "advancementname")).description(Localizer.dLocalize("ranged", "forceshot", "advancementlore")).frame(AdvancementDisplay.AdvancementFrame.CHALLENGE).visibility(AdvancementVisibility.PARENT_GRANTED).build());
    }

    @Override
    public void addStats(int n, Element element) {
        element.addLore(C.GREEN + "+ " + Form.pc(this.getSpeed(this.getLevelPercent(n)), 0) + C.GRAY + " " + Localizer.dLocalize("ranged", "forceshot", "lore1"));
    }

    private double getSpeed(double d) {
        return d * ((Config)this.getConfig()).speedFactor;
    }

    @EventHandler
    public void on(EntityDamageByEntityEvent entityDamageByEntityEvent) {
        Player player;
        Projectile projectile;
        if (entityDamageByEntityEvent.isCancelled()) {
            return;
        }
        Entity entity = entityDamageByEntityEvent.getDamager();
        if (entity instanceof Projectile && (entity = (projectile = (Projectile)entity).getShooter()) instanceof Player && this.hasAdaptation(player = (Player)entity) && !this.getPlayer(player).getData().isGranted("challenge_force_30")) {
            entity = entityDamageByEntityEvent.getEntity().getLocation().clone();
            Location location = player.getLocation().clone();
            entity.setY(0.0);
            location.setY(0.0);
            this.xp(player, 5.0);
            if (entity.distanceSquared(location) > 10.0 && AdaptConfig.get().isAdvancements()) {
                this.getPlayer(player).getAdvancementHandler().grant("challenge_force_30");
                this.getSkill().xp(player, ((Config)this.getConfig()).challengeRewardLongShotReward);
            }
        }
    }

    @EventHandler
    public void on(ProjectileLaunchEvent projectileLaunchEvent) {
        Player player;
        if (projectileLaunchEvent.isCancelled()) {
            return;
        }
        ProjectileSource projectileSource = projectileLaunchEvent.getEntity().getShooter();
        if (projectileSource instanceof Player && this.hasAdaptation(player = (Player)projectileSource)) {
            double d = this.getLevelPercent(player);
            projectileLaunchEvent.getEntity().setVelocity(projectileLaunchEvent.getEntity().getVelocity().clone().multiply(1.0 + this.getSpeed(d)));
            projectileLaunchEvent.getEntity().getWorld().playSound(projectileLaunchEvent.getEntity().getLocation(), Sound.ENTITY_SNOWBALL_THROW, 0.5f + (float)d * 0.25f, 0.7f + (float)(d / 2.0));
        }
    }

    @Override
    public void onTick() {
    }

    @Override
    public boolean isEnabled() {
        return ((Config)this.getConfig()).enabled;
    }

    @Override
    public boolean isPermanent() {
        return ((Config)this.getConfig()).permanent;
    }

    static {
        IBootstrap.dasBoot();
    }

    protected static class Config {
        boolean permanent = false;
        boolean enabled = true;
        int baseCost = 2;
        int maxLevel = 7;
        int initialCost = 5;
        double costFactor = 0.225;
        double challengeRewardLongShotReward = 2000.0;
        double speedFactor = 1.135;

        static {
            IBootstrap.dasBoot();
        }
    }
}

