/*
 * Decompiled with CFR 0.152.
 */
package com.volmit.adapt.content.adaptation.rift;

import com.volmit.adapt.api.adaptation.SimpleAdaptation;
import com.volmit.adapt.api.world.AdaptPlayer;
import com.volmit.adapt.util.C;
import com.volmit.adapt.util.Element;
import com.volmit.adapt.util.Localizer;
import com.volmit.adapt.util.manifold.rt.api.IBootstrap;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.block.Action;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;

public class RiftResist
extends SimpleAdaptation<Config> {
    public RiftResist() {
        super("rift-resist");
        this.registerConfiguration(Config.class);
        this.setDescription(Localizer.dLocalize("rift", "resist", "description"));
        this.setDisplayName(Localizer.dLocalize("rift", "resist", "name"));
        this.setIcon(Material.SCULK_VEIN);
        this.setBaseCost(((Config)this.getConfig()).baseCost);
        this.setCostFactor(((Config)this.getConfig()).costFactor);
        this.setMaxLevel(((Config)this.getConfig()).maxLevel);
        this.setInitialCost(((Config)this.getConfig()).initialCost);
        this.setInterval(10288L);
    }

    static void riftResistStackAdd(Player player, int n, int n2) {
        if (player.getLocation().getWorld() == null) {
            return;
        }
        player.getWorld().playSound(player.getLocation(), Sound.ITEM_ARMOR_EQUIP_IRON, 1.0f, 1.24f);
        player.getLocation().getWorld().playSound(player.getLocation(), Sound.BLOCK_CONDUIT_AMBIENT_SHORT, 1.0f, 0.01f);
        player.getLocation().getWorld().playSound(player.getLocation(), Sound.BLOCK_RESPAWN_ANCHOR_CHARGE, 1.0f, 0.01f);
        player.addPotionEffect(new PotionEffect(PotionEffectType.DAMAGE_RESISTANCE, n, n2, true, false, false));
    }

    public static boolean hasRiftResistPerk(AdaptPlayer adaptPlayer) {
        return adaptPlayer.getData().getLevel() > 0;
    }

    @Override
    public void addStats(int n, Element element) {
        element.addLore(C.ITALIC + Localizer.dLocalize("rift", "resist", "lore1"));
        element.addLore(C.UNDERLINE + Localizer.dLocalize("rift", "resist", "lore2"));
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void on(PlayerInteractEvent playerInteractEvent) {
        Player player = playerInteractEvent.getPlayer();
        if (!this.hasAdaptation(player)) {
            return;
        }
        ItemStack itemStack = player.getInventory().getItemInMainHand();
        if (playerInteractEvent.getAction() == Action.RIGHT_CLICK_AIR) {
            switch (itemStack.getType()) {
                case ENDER_EYE: 
                case ENDER_PEARL: {
                    this.xp(player, 3.0);
                    RiftResist.riftResistStackAdd(player, 80, 10);
                }
            }
        }
    }

    @Override
    public void onTick() {
    }

    @Override
    public boolean isEnabled() {
        return ((Config)this.getConfig()).enabled;
    }

    @Override
    public boolean isPermanent() {
        return ((Config)this.getConfig()).permanent;
    }

    static {
        IBootstrap.dasBoot();
    }

    protected static class Config {
        boolean permanent = false;
        boolean enabled = true;
        int baseCost = 3;
        double costFactor = 1.0;
        int maxLevel = 1;
        int initialCost = 5;

        static {
            IBootstrap.dasBoot();
        }
    }
}

