/*
 * Decompiled with CFR 0.152.
 */
package com.volmit.adapt.content.adaptation.stealth;

import com.volmit.adapt.api.adaptation.SimpleAdaptation;
import com.volmit.adapt.util.C;
import com.volmit.adapt.util.Element;
import com.volmit.adapt.util.Localizer;
import com.volmit.adapt.util.manifold.rt.api.IBootstrap;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.player.PlayerToggleSneakEvent;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;

public class StealthSight
extends SimpleAdaptation<Config> {
    public StealthSight() {
        super("stealth-vision");
        this.registerConfiguration(Config.class);
        this.setDescription(Localizer.dLocalize("stealth", "nightvision", "description"));
        this.setDisplayName(Localizer.dLocalize("stealth", "nightvision", "name"));
        this.setIcon(Material.POTION);
        this.setBaseCost(((Config)this.getConfig()).baseCost);
        this.setInterval(5252L);
        this.setInitialCost(((Config)this.getConfig()).initialCost);
        this.setCostFactor(((Config)this.getConfig()).costFactor);
        this.setMaxLevel(((Config)this.getConfig()).maxLevel);
    }

    @Override
    public void addStats(int n, Element element) {
        element.addLore(C.GRAY + Localizer.dLocalize("stealth", "nightvision", "lore1") + C.GREEN + Localizer.dLocalize("stealth", "nightvision", "lore2") + C.GRAY + Localizer.dLocalize("stealth", "nightvision", "lore3"));
    }

    @EventHandler
    public void on(PlayerToggleSneakEvent playerToggleSneakEvent) {
        if (playerToggleSneakEvent.isCancelled()) {
            return;
        }
        Player player = playerToggleSneakEvent.getPlayer();
        if (!this.hasAdaptation(player)) {
            return;
        }
        if (!player.isSneaking()) {
            player.playSound(player.getLocation(), Sound.BLOCK_FUNGUS_BREAK, 1.0f, 0.99f);
            player.addPotionEffect(new PotionEffect(PotionEffectType.NIGHT_VISION, 20000, 0, false, false));
        } else {
            player.removePotionEffect(PotionEffectType.NIGHT_VISION);
        }
    }

    @Override
    public void onTick() {
    }

    @Override
    public boolean isEnabled() {
        return ((Config)this.getConfig()).enabled;
    }

    @Override
    public boolean isPermanent() {
        return ((Config)this.getConfig()).permanent;
    }

    static {
        IBootstrap.dasBoot();
    }

    protected static class Config {
        boolean permanent = false;
        boolean enabled = true;
        int baseCost = 2;
        int initialCost = 5;
        double costFactor = 0.6;
        int maxLevel = 1;

        static {
            IBootstrap.dasBoot();
        }
    }
}

