/*
 * Decompiled with CFR 0.152.
 */
package com.volmit.adapt.content.adaptation.sword;

import com.volmit.adapt.Adapt;
import com.volmit.adapt.api.adaptation.SimpleAdaptation;
import com.volmit.adapt.content.adaptation.sword.effects.DamagingBleedEffect;
import com.volmit.adapt.content.item.ItemListings;
import com.volmit.adapt.util.C;
import com.volmit.adapt.util.Element;
import com.volmit.adapt.util.Form;
import com.volmit.adapt.util.Localizer;
import com.volmit.adapt.util.manifold.rt.api.IBootstrap;
import de.slikey.effectlib.effect.BleedEffect;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.Material;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.entity.EntityDamageByEntityEvent;

public class SwordsBloodyBlade
extends SimpleAdaptation<Config> {
    private final Map<Player, Long> cooldowns;

    public SwordsBloodyBlade() {
        super("sword-bloody-blade");
        this.registerConfiguration(Config.class);
        this.setDescription(Localizer.dLocalize("sword", "bloodyblade", "description"));
        this.setDisplayName(Localizer.dLocalize("sword", "bloodyblade", "name"));
        this.setIcon(Material.RED_DYE);
        this.setBaseCost(((Config)this.getConfig()).baseCost);
        this.setMaxLevel(((Config)this.getConfig()).maxLevel);
        this.setInterval(5534L);
        this.setInitialCost(((Config)this.getConfig()).initialCost);
        this.setCostFactor(((Config)this.getConfig()).costFactor);
        this.cooldowns = new HashMap<Player, Long>();
    }

    @Override
    public void addStats(int n, Element element) {
        element.addLore(C.GREEN + "+ " + C.GRAY + " " + Localizer.dLocalize("sword", "bloodyblade", "lore1"));
        element.addLore(C.YELLOW + "* " + Form.duration(this.getDurationOfEffect(n), 1) + C.GRAY + " " + Localizer.dLocalize("sword", "bloodyblade", "lore2"));
        element.addLore(C.RED + "* " + Form.duration(this.getCooldown(n), 1) + C.GRAY + " " + Localizer.dLocalize("sword", "bloodyblade", "lore3"));
    }

    public long getCooldown(int n) {
        return ((Config)this.getConfig()).cooldown * (long)n;
    }

    public long getDurationOfEffect(int n) {
        return ((Config)this.getConfig()).effectDuration * (long)n;
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void on(EntityDamageByEntityEvent entityDamageByEntityEvent) {
        Player player;
        if (entityDamageByEntityEvent.isCancelled()) {
            return;
        }
        Entity entity = entityDamageByEntityEvent.getDamager();
        if (entity instanceof Player && this.hasAdaptation(player = (Player)entity) && ItemListings.getToolSwords().contains(player.getInventory().getItemInMainHand().getType())) {
            Player player2;
            if (this.cooldowns.containsKey(player)) {
                if (this.cooldowns.get(player).compareTo(System.currentTimeMillis()) > 0) {
                    return;
                }
                this.cooldowns.remove(player);
            }
            entity = entityDamageByEntityEvent.getEntity();
            this.cooldowns.put(player, System.currentTimeMillis() + this.getCooldown(this.getLevel(player)));
            if (entity instanceof Player ? !this.canPVP(player, (player2 = (Player)entity).getLocation()) : !this.canPVE(player, entity.getLocation())) {
                return;
            }
            if (((Config)this.getConfig()).showParticles) {
                BleedEffect bleedEffect;
                if (entity instanceof LivingEntity) {
                    LivingEntity livingEntity = (LivingEntity)entity;
                    bleedEffect = new DamagingBleedEffect(Adapt.instance.adaptEffectManager, ((Config)this.getConfig()).damagePerBleedProc, livingEntity);
                } else {
                    bleedEffect = new BleedEffect(Adapt.instance.adaptEffectManager);
                }
                player2 = bleedEffect;
                player2.setEntity(entity);
                player2.material = Material.CRIMSON_ROOTS;
                player2.height = -1.0;
                player2.iterations = Math.toIntExact(2L * (3L + this.getDurationOfEffect(this.getLevel(player)) / 1000L));
                player2.period = 5;
                player2.hurt = false;
                player2.start();
            } else {
                BleedEffect bleedEffect;
                if (entity instanceof LivingEntity) {
                    LivingEntity livingEntity = (LivingEntity)entity;
                    bleedEffect = new DamagingBleedEffect(Adapt.instance.adaptEffectManager, ((Config)this.getConfig()).damagePerBleedProc, livingEntity);
                } else {
                    bleedEffect = new BleedEffect(Adapt.instance.adaptEffectManager);
                }
                player2 = bleedEffect;
                player2.setEntity(entity);
                player2.material = Material.VOID_AIR;
                player2.height = -1.0;
                player2.iterations = Math.toIntExact(2L * (3L + this.getDurationOfEffect(this.getLevel(player)) / 1000L));
                player2.period = 5;
                player2.hurt = false;
                player2.start();
            }
        }
    }

    @Override
    public void onTick() {
    }

    @Override
    public boolean isEnabled() {
        return ((Config)this.getConfig()).enabled;
    }

    @Override
    public boolean isPermanent() {
        return ((Config)this.getConfig()).permanent;
    }

    static {
        IBootstrap.dasBoot();
    }

    protected static class Config {
        public long cooldown = 5000L;
        public double damagePerBleedProc = 0.5;
        public long effectDuration = 1000L;
        boolean permanent = false;
        boolean enabled = true;
        boolean showParticles = true;
        int baseCost = 7;
        int maxLevel = 7;
        int initialCost = 7;
        double costFactor = 0.325;

        static {
            IBootstrap.dasBoot();
        }
    }
}

