/*
 * Decompiled with CFR 0.152.
 */
package com.volmit.adapt.content.adaptation.taming;

import com.volmit.adapt.api.adaptation.SimpleAdaptation;
import com.volmit.adapt.util.C;
import com.volmit.adapt.util.Element;
import com.volmit.adapt.util.Form;
import com.volmit.adapt.util.J;
import com.volmit.adapt.util.Localizer;
import com.volmit.adapt.util.manifold.rt.api.IBootstrap;
import java.util.Collection;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.attribute.Attribute;
import org.bukkit.attribute.AttributeModifier;
import org.bukkit.entity.AnimalTamer;
import org.bukkit.entity.Player;
import org.bukkit.entity.Tameable;

public class TamingDamage
extends SimpleAdaptation<Config> {
    private final UUID attUUID = UUID.nameUUIDFromBytes("tame-damage-boost".getBytes());
    private final String attid = "att-tame-damage-boost";

    public TamingDamage() {
        super("tame-damage");
        this.registerConfiguration(Config.class);
        this.setDescription(Localizer.dLocalize("taming", "damage", "description"));
        this.setDisplayName(Localizer.dLocalize("taming", "damage", "name"));
        this.setIcon(Material.FLINT);
        this.setBaseCost(((Config)this.getConfig()).baseCost);
        this.setMaxLevel(((Config)this.getConfig()).maxLevel);
        this.setInitialCost(((Config)this.getConfig()).initialCost);
        this.setInterval(6119L);
        this.setCostFactor(((Config)this.getConfig()).costFactor);
    }

    @Override
    public void addStats(int n, Element element) {
        element.addLore(C.GREEN + "+ " + Form.pc(this.getDamageBoost(n), 0) + C.GRAY + " " + Localizer.dLocalize("taming", "damage", "lore1"));
    }

    private double getDamageBoost(int n) {
        return this.getLevelPercent(n) * ((Config)this.getConfig()).damageFactor + ((Config)this.getConfig()).baseDamage;
    }

    @Override
    public void onTick() {
        for (World world : Bukkit.getServer().getWorlds()) {
            J.s(() -> {
                Collection collection = world.getEntitiesByClass(Tameable.class);
                J.a(() -> {
                    for (Tameable tameable : collection) {
                        AnimalTamer animalTamer;
                        if (!tameable.isTamed() || !((animalTamer = tameable.getOwner()) instanceof Player)) continue;
                        Player player = (Player)animalTamer;
                        this.update(tameable, this.getLevel(player));
                    }
                });
            });
        }
    }

    private void update(Tameable tameable, int n) {
        AttributeModifier attributeModifier = new AttributeModifier(this.attUUID, "att-tame-damage-boost", this.getDamageBoost(n), AttributeModifier.Operation.ADD_SCALAR);
        if (tameable.getAttribute(Attribute.GENERIC_ATTACK_DAMAGE) == null) {
            return;
        }
        tameable.getAttribute(Attribute.GENERIC_ATTACK_DAMAGE).removeModifier(attributeModifier);
        if (n > 0) {
            tameable.getAttribute(Attribute.GENERIC_ATTACK_DAMAGE).addModifier(attributeModifier);
        }
    }

    @Override
    public boolean isEnabled() {
        return ((Config)this.getConfig()).enabled;
    }

    @Override
    public boolean isPermanent() {
        return ((Config)this.getConfig()).permanent;
    }

    static {
        IBootstrap.dasBoot();
    }

    protected static class Config {
        boolean permanent = false;
        boolean enabled = true;
        int baseCost = 6;
        int maxLevel = 5;
        int initialCost = 5;
        double costFactor = 0.4;
        double baseDamage = 0.08;
        double damageFactor = 0.65;

        static {
            IBootstrap.dasBoot();
        }
    }
}

