/*
 * Decompiled with CFR 0.152.
 */
package com.volmit.adapt.content.block;

import com.volmit.adapt.util.arcane.spatial.matter.slices.RawMatter;
import com.volmit.adapt.util.manifold.rt.api.IBootstrap;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.util.UUID;

public class ScaffoldMatter
extends RawMatter<ScaffoldData> {
    public ScaffoldMatter(int n, int n2, int n3) {
        super(n, n2, n3, ScaffoldData.class);
    }

    @Override
    public void writeNode(ScaffoldData scaffoldData, DataOutputStream dataOutputStream) {
        dataOutputStream.writeLong(scaffoldData.getUuid().getMostSignificantBits());
        dataOutputStream.writeLong(scaffoldData.getUuid().getLeastSignificantBits());
        dataOutputStream.writeLong(scaffoldData.getTime());
    }

    @Override
    public ScaffoldData readNode(DataInputStream dataInputStream) {
        return ScaffoldData.builder().uuid(new UUID(dataInputStream.readLong(), dataInputStream.readLong())).time(dataInputStream.readLong()).build();
    }

    static {
        IBootstrap.dasBoot();
    }

    public static class ScaffoldData {
        private UUID uuid;
        private long time;

        private static long $default$time() {
            return 0L;
        }

        public static ScaffoldDataBuilder builder() {
            return new ScaffoldDataBuilder();
        }

        public UUID getUuid() {
            return this.uuid;
        }

        public long getTime() {
            return this.time;
        }

        public void setUuid(UUID uUID) {
            this.uuid = uUID;
        }

        public void setTime(long l) {
            this.time = l;
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (!(object instanceof ScaffoldData)) {
                return false;
            }
            ScaffoldData scaffoldData = (ScaffoldData)object;
            if (!scaffoldData.canEqual(this)) {
                return false;
            }
            if (this.getTime() != scaffoldData.getTime()) {
                return false;
            }
            UUID uUID = this.getUuid();
            UUID uUID2 = scaffoldData.getUuid();
            return !(uUID == null ? uUID2 != null : !((Object)uUID).equals(uUID2));
        }

        protected boolean canEqual(Object object) {
            return object instanceof ScaffoldData;
        }

        public int hashCode() {
            int n = 59;
            int n2 = 1;
            long l = this.getTime();
            n2 = n2 * 59 + (int)(l >>> 32 ^ l);
            UUID uUID = this.getUuid();
            n2 = n2 * 59 + (uUID == null ? 43 : ((Object)uUID).hashCode());
            return n2;
        }

        public String toString() {
            return "ScaffoldMatter.ScaffoldData(uuid=" + this.getUuid() + ", time=" + this.getTime() + ")";
        }

        public ScaffoldData(UUID uUID, long l) {
            this.uuid = uUID;
            this.time = l;
        }

        public ScaffoldData() {
            this.time = ScaffoldData.$default$time();
        }

        static {
            IBootstrap.dasBoot();
        }

        public static class ScaffoldDataBuilder {
            private UUID uuid;
            private boolean time$set;
            private long time$value;

            ScaffoldDataBuilder() {
            }

            public ScaffoldDataBuilder uuid(UUID uUID) {
                this.uuid = uUID;
                return this;
            }

            public ScaffoldDataBuilder time(long l) {
                this.time$value = l;
                this.time$set = true;
                return this;
            }

            public ScaffoldData build() {
                long l = this.time$value;
                if (!this.time$set) {
                    l = ScaffoldData.$default$time();
                }
                return new ScaffoldData(this.uuid, l);
            }

            public String toString() {
                return "ScaffoldMatter.ScaffoldData.ScaffoldDataBuilder(uuid=" + this.uuid + ", time$value=" + this.time$value + ")";
            }

            static {
                IBootstrap.dasBoot();
            }
        }
    }
}

