/*
 * Decompiled with CFR 0.152.
 */
package com.volmit.adapt.content.skill;

import com.volmit.adapt.api.advancement.AdaptAdvancement;
import com.volmit.adapt.api.skill.SimpleSkill;
import com.volmit.adapt.api.world.AdaptStatTracker;
import com.volmit.adapt.content.adaptation.crafting.CraftingBackpacks;
import com.volmit.adapt.content.adaptation.crafting.CraftingDeconstruction;
import com.volmit.adapt.content.adaptation.crafting.CraftingLeather;
import com.volmit.adapt.content.adaptation.crafting.CraftingReconstruction;
import com.volmit.adapt.content.adaptation.crafting.CraftingSkulls;
import com.volmit.adapt.content.adaptation.crafting.CraftingStations;
import com.volmit.adapt.content.adaptation.crafting.CraftingXP;
import com.volmit.adapt.util.C;
import com.volmit.adapt.util.Localizer;
import com.volmit.adapt.util.advancements.advancement.AdvancementDisplay;
import com.volmit.adapt.util.advancements.advancement.AdvancementVisibility;
import com.volmit.adapt.util.manifold.rt.api.IBootstrap;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.Cancellable;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.inventory.CraftItemEvent;
import org.bukkit.event.inventory.FurnaceSmeltEvent;
import org.bukkit.inventory.CraftingInventory;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;

public class SkillCrafting
extends SimpleSkill<Config> {
    private final Map<Player, Long> cooldowns;

    public SkillCrafting() {
        super("crafting", Localizer.dLocalize("skill", "crafting", "icon"));
        this.registerConfiguration(Config.class);
        this.setColor(C.YELLOW);
        this.setDescription(Localizer.dLocalize("skill", "crafting", "description"));
        this.setDisplayName(Localizer.dLocalize("skill", "crafting", "name"));
        this.setInterval(3789L);
        this.setIcon(Material.CRAFTING_TABLE);
        this.registerAdaptation(new CraftingDeconstruction());
        this.registerAdaptation(new CraftingXP());
        this.registerAdaptation(new CraftingLeather());
        this.registerAdaptation(new CraftingSkulls());
        this.registerAdaptation(new CraftingBackpacks());
        this.registerAdaptation(new CraftingStations());
        this.registerAdaptation(new CraftingReconstruction());
        this.registerAdvancement(AdaptAdvancement.builder().icon(Material.CRAFTING_TABLE).key("challenge_craft_1k").title(Localizer.dLocalize("advancement", "challenge_craft_1k", "title")).description(Localizer.dLocalize("advancement", "challenge_craft_1k", "description")).frame(AdvancementDisplay.AdvancementFrame.CHALLENGE).visibility(AdvancementVisibility.PARENT_GRANTED).child(AdaptAdvancement.builder().icon(Material.CRAFTING_TABLE).key("challenge_craft_5k").title(Localizer.dLocalize("advancement", "challenge_craft_5k", "title")).description(Localizer.dLocalize("advancement", "challenge_craft_5k", "description")).frame(AdvancementDisplay.AdvancementFrame.CHALLENGE).visibility(AdvancementVisibility.PARENT_GRANTED).child(AdaptAdvancement.builder().icon(Material.CRAFTING_TABLE).key("challenge_craft_50k").title(Localizer.dLocalize("advancement", "challenge_craft_50k", "title")).description(Localizer.dLocalize("advancement", "challenge_craft_50k", "description")).frame(AdvancementDisplay.AdvancementFrame.CHALLENGE).visibility(AdvancementVisibility.PARENT_GRANTED).child(AdaptAdvancement.builder().icon(Material.CRAFTING_TABLE).key("challenge_craft_500k").title(Localizer.dLocalize("advancement", "challenge_craft_500k", "title")).description(Localizer.dLocalize("advancement", "challenge_craft_500k", "description")).frame(AdvancementDisplay.AdvancementFrame.CHALLENGE).visibility(AdvancementVisibility.PARENT_GRANTED).child(AdaptAdvancement.builder().icon(Material.CRAFTING_TABLE).key("challenge_craft_5m").title(Localizer.dLocalize("advancement", "challenge_craft_5m", "title")).description(Localizer.dLocalize("advancement", "challenge_craft_5m", "description")).frame(AdvancementDisplay.AdvancementFrame.CHALLENGE).visibility(AdvancementVisibility.PARENT_GRANTED).build()).build()).build()).build()).build());
        this.registerStatTracker(AdaptStatTracker.builder().advancement("challenge_block_1k").goal(1000.0).stat("blocked.hits").reward(((Config)this.getConfig()).challengeCraft1kReward).build());
        this.registerStatTracker(AdaptStatTracker.builder().advancement("challenge_block_5k").goal(5000.0).stat("blocked.hits").reward(((Config)this.getConfig()).challengeCraft1kReward).build());
        this.registerStatTracker(AdaptStatTracker.builder().advancement("challenge_block_50k").goal(50000.0).stat("blocked.hits").reward(((Config)this.getConfig()).challengeCraft1kReward).build());
        this.registerStatTracker(AdaptStatTracker.builder().advancement("challenge_block_500k").goal(500000.0).stat("blocked.hits").reward(((Config)this.getConfig()).challengeCraft1kReward).build());
        this.registerStatTracker(AdaptStatTracker.builder().advancement("challenge_block_5m").goal(5000000.0).stat("blocked.hits").reward(((Config)this.getConfig()).challengeCraft1kReward).build());
        this.cooldowns = new HashMap<Player, Long>();
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void on(CraftItemEvent craftItemEvent) {
        Player player = (Player)craftItemEvent.getWhoClicked();
        this.shouldReturnForPlayer(player, (Cancellable)craftItemEvent, () -> {
            if (!this.isValidCraftEvent(craftItemEvent)) {
                return;
            }
            int n = this.calculateRecipeAmount(craftItemEvent);
            if (n > 0 && !craftItemEvent.isCancelled()) {
                double d = (double)n * this.getValue(craftItemEvent.getRecipe().getResult()) * ((Config)this.getConfig()).craftingValueXPMultiplier;
                this.getPlayer(player).getData().addStat("crafted.items", n);
                this.getPlayer(player).getData().addStat("crafted.value", d);
                this.xp(player, d + ((Config)this.getConfig()).baseCraftingXP);
            }
        });
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void on(FurnaceSmeltEvent furnaceSmeltEvent) {
        if (this.shouldReturnForWorld(furnaceSmeltEvent.getBlock().getWorld(), this)) {
            return;
        }
        this.xp(furnaceSmeltEvent.getBlock().getLocation(), ((Config)this.getConfig()).furnaceBaseXP + this.getValue(furnaceSmeltEvent.getResult()) * ((Config)this.getConfig()).furnaceValueXPMultiplier, ((Config)this.getConfig()).furnaceXPRadius, ((Config)this.getConfig()).furnaceXPDuration);
    }

    @Override
    public void onTick() {
        for (Player player : Bukkit.getOnlinePlayers()) {
            if (this.shouldReturnForPlayer(player)) continue;
            this.checkStatTrackers(this.getPlayer(player));
        }
    }

    private boolean isValidCraftEvent(CraftItemEvent craftItemEvent) {
        if (this.cooldowns.containsKey(craftItemEvent.getWhoClicked())) {
            if (this.cooldowns.get(craftItemEvent.getWhoClicked()) + ((Config)this.getConfig()).cooldownDelay > System.currentTimeMillis()) {
                return false;
            }
            this.cooldowns.remove(craftItemEvent.getWhoClicked());
        }
        this.cooldowns.put((Player)craftItemEvent.getWhoClicked(), System.currentTimeMillis());
        ItemStack itemStack = craftItemEvent.getInventory().getResult();
        ItemStack itemStack2 = craftItemEvent.getCursor();
        return itemStack != null && itemStack.getAmount() > 0 && (itemStack2 == null || itemStack2.getAmount() < 64);
    }

    private int calculateRecipeAmount(CraftItemEvent craftItemEvent) {
        ItemStack itemStack = craftItemEvent.getRecipe().getResult().clone();
        int n = craftItemEvent.getInventory().getResult().getAmount();
        switch (craftItemEvent.getClick()) {
            case NUMBER_KEY: {
                if (craftItemEvent.getWhoClicked().getInventory().getItem(craftItemEvent.getHotbarButton()) == null) break;
                n = 0;
                break;
            }
            case DROP: 
            case CONTROL_DROP: {
                ItemStack itemStack2 = craftItemEvent.getCursor();
                if (itemStack2 == null || itemStack2.getType().isAir()) break;
                n = 0;
                break;
            }
            case SHIFT_RIGHT: 
            case SHIFT_LEFT: {
                if (n == 0) break;
                int n2 = this.getMaxCraftAmount(craftItemEvent.getInventory());
                int n3 = this.fits(itemStack, craftItemEvent.getView().getBottomInventory());
                if (n3 < n2) {
                    n2 = (n3 + n - 1) / n * n;
                }
                n = n2;
                break;
            }
        }
        return n;
    }

    private int fits(ItemStack itemStack, Inventory inventory) {
        ItemStack[] itemStackArray = inventory.getContents();
        int n = 0;
        for (ItemStack itemStack2 : itemStackArray) {
            if (itemStack2 == null) {
                n += itemStack.getMaxStackSize();
                continue;
            }
            if (!itemStack2.isSimilar(itemStack)) continue;
            n += Math.max(itemStack.getMaxStackSize() - itemStack2.getAmount(), 0);
        }
        return n;
    }

    private int getMaxCraftAmount(CraftingInventory craftingInventory) {
        if (craftingInventory.getResult() == null) {
            return 0;
        }
        int n = craftingInventory.getResult().getAmount();
        int n2 = Integer.MAX_VALUE;
        for (ItemStack itemStack : craftingInventory.getMatrix()) {
            if (itemStack == null || itemStack.getAmount() >= n2) continue;
            n2 = itemStack.getAmount();
        }
        return n * n2;
    }

    @Override
    public boolean isEnabled() {
        return ((Config)this.getConfig()).enabled;
    }

    static {
        IBootstrap.dasBoot();
    }

    protected static class Config {
        boolean enabled = true;
        double furnaceBaseXP = 24.0;
        double furnaceValueXPMultiplier = 4.0;
        int furnaceXPRadius = 32;
        long cooldownDelay = 10000L;
        long furnaceXPDuration = 10000L;
        double craftingValueXPMultiplier = 1.0;
        double baseCraftingXP = 0.25;
        double challengeCraft1kReward = 1200.0;

        static {
            IBootstrap.dasBoot();
        }
    }
}

