/*
 * Decompiled with CFR 0.152.
 */
package com.volmit.adapt.content.skill;

import com.volmit.adapt.Adapt;
import com.volmit.adapt.api.skill.SimpleSkill;
import com.volmit.adapt.api.world.Discovery;
import com.volmit.adapt.content.adaptation.discovery.DiscoveryArmor;
import com.volmit.adapt.content.adaptation.discovery.DiscoveryUnity;
import com.volmit.adapt.content.adaptation.discovery.DiscoveryVillagerAtt;
import com.volmit.adapt.content.adaptation.discovery.DiscoveryXpResist;
import com.volmit.adapt.util.C;
import com.volmit.adapt.util.Form;
import com.volmit.adapt.util.J;
import com.volmit.adapt.util.Localizer;
import com.volmit.adapt.util.manifold.rt.api.IBootstrap;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.FluidCollisionMode;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.Particle;
import org.bukkit.World;
import org.bukkit.block.Biome;
import org.bukkit.block.Block;
import org.bukkit.block.data.BlockData;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.Cancellable;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.entity.EntityPickupItemEvent;
import org.bukkit.event.inventory.CraftItemEvent;
import org.bukkit.event.player.PlayerChangedWorldEvent;
import org.bukkit.event.player.PlayerExpChangeEvent;
import org.bukkit.event.player.PlayerInteractAtEntityEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerItemConsumeEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.Recipe;
import org.bukkit.potion.PotionEffect;

public class SkillDiscovery
extends SimpleSkill<Config> {
    public SkillDiscovery() {
        super("discovery", Localizer.dLocalize("skill", "discovery", "icon"));
        this.registerConfiguration(Config.class);
        this.setColor(C.AQUA);
        this.setDescription(Localizer.dLocalize("skill", "discovery", "description"));
        this.setDisplayName(Localizer.dLocalize("skill", "discovery", "name"));
        this.setInterval(500L);
        this.setIcon(Material.FILLED_MAP);
        this.registerAdaptation(new DiscoveryUnity());
        this.registerAdaptation(new DiscoveryArmor());
        this.registerAdaptation(new DiscoveryXpResist());
        this.registerAdaptation(new DiscoveryVillagerAtt());
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void on(PlayerChangedWorldEvent playerChangedWorldEvent) {
        this.shouldReturnForPlayer(playerChangedWorldEvent.getPlayer(), () -> this.scheduleSeeWorld(playerChangedWorldEvent.getPlayer()));
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void on(PlayerInteractAtEntityEvent playerInteractAtEntityEvent) {
        this.shouldReturnForPlayer(playerInteractAtEntityEvent.getPlayer(), (Cancellable)playerInteractAtEntityEvent, () -> this.seeEntity(playerInteractAtEntityEvent.getPlayer(), playerInteractAtEntityEvent.getRightClicked()));
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void on(EntityPickupItemEvent entityPickupItemEvent) {
        LivingEntity livingEntity = entityPickupItemEvent.getEntity();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            this.shouldReturnForPlayer(player, (Cancellable)entityPickupItemEvent, () -> this.seeItem(player, entityPickupItemEvent.getItem().getItemStack()));
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void on(CraftItemEvent craftItemEvent) {
        HumanEntity humanEntity = craftItemEvent.getWhoClicked();
        if (!(humanEntity instanceof Player)) {
            return;
        }
        Player player = (Player)humanEntity;
        this.shouldReturnForPlayer(player, (Cancellable)craftItemEvent, () -> {
            try {
                NamespacedKey namespacedKey = (NamespacedKey)Recipe.class.getDeclaredMethod("getKey()", new Class[0]).invoke((Object)craftItemEvent.getRecipe(), new Object[0]);
                if (namespacedKey != null) {
                    this.seeCraftedRecipe(player, namespacedKey.toString());
                }
            }
            catch (Throwable throwable) {
                Adapt.verbose("No recipe key found for " + craftItemEvent.getRecipe().getResult().getType().name());
            }
        });
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void on(PlayerItemConsumeEvent playerItemConsumeEvent) {
        this.shouldReturnForPlayer(playerItemConsumeEvent.getPlayer(), (Cancellable)playerItemConsumeEvent, () -> {
            this.seeItem(playerItemConsumeEvent.getPlayer(), playerItemConsumeEvent.getItem());
            this.seeFood(playerItemConsumeEvent.getPlayer(), playerItemConsumeEvent.getItem().getType());
        });
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void on(PlayerInteractEvent playerInteractEvent) {
        this.shouldReturnForPlayer(playerInteractEvent.getPlayer(), (Cancellable)playerInteractEvent, () -> {
            if (playerInteractEvent.getClickedBlock() != null) {
                this.seeBlock(playerInteractEvent.getPlayer(), playerInteractEvent.getClickedBlock().getBlockData(), playerInteractEvent.getClickedBlock().getLocation());
            }
        });
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void on(PlayerExpChangeEvent playerExpChangeEvent) {
        this.shouldReturnForPlayer(playerExpChangeEvent.getPlayer(), () -> {
            if (playerExpChangeEvent.getAmount() > 0 && this.getLevel(playerExpChangeEvent.getPlayer()) > 0) {
                this.xp(playerExpChangeEvent.getPlayer(), playerExpChangeEvent.getAmount());
            }
        });
    }

    private void scheduleSeeWorld(Player player) {
        try {
            J.a(() -> this.seeWorld(player, player.getWorld()), 15);
        }
        catch (Exception exception) {
            Adapt.error("Failed to discover world " + player.getWorld().getName());
        }
    }

    public void seeBlock(Player player, BlockData blockData, Location location) {
        Discovery<String> discovery = this.getPlayer(player).getData().getSeenBlocks();
        if (discovery.isNewDiscovery(blockData.getAsString())) {
            this.xp(player, ((Config)this.getConfig()).discoverBlockBaseXP + this.getValue(blockData) * ((Config)this.getConfig()).discoverBlockValueXPMultiplier);
            if (((Config)this.getConfig()).showParticles) {
                player.spawnParticle(Particle.TOTEM, location.clone().add(0.5, 0.5, 0.5), 9, 0.0, 0.0, 0.0, 0.3);
            }
        }
        this.seeItem(player, blockData.getMaterial());
    }

    public void seeItem(Player player, Material material) {
        Discovery<Material> discovery = this.getPlayer(player).getData().getSeenItems();
        if (discovery.isNewDiscovery(material)) {
            this.xp(player, ((Config)this.getConfig()).discoverItemBaseXP + this.getValue(material) * ((Config)this.getConfig()).discoverItemValueXPMultiplier);
        }
    }

    public void seeItem(Player player, ItemStack itemStack) {
        this.seeItem(player, itemStack.getType());
        Map map = itemStack.getEnchantments();
        for (Enchantment enchantment : map.keySet()) {
            this.seeEnchant(player, enchantment, (Integer)map.get(enchantment));
        }
    }

    public void seeCraftedRecipe(Player player, String string) {
        Discovery<String> discovery = this.getPlayer(player).getData().getSeenRecipes();
        if (discovery.isNewDiscovery(string)) {
            this.xp(player, ((Config)this.getConfig()).discoverRecipeBaseXP);
        }
    }

    public void seeFood(Player player, Material material) {
        Discovery<Material> discovery = this.getPlayer(player).getData().getSeenFoods();
        if (discovery.isNewDiscovery(material)) {
            this.xp(player, ((Config)this.getConfig()).discoverFoodTypeXP);
        }
    }

    public void seeEntity(Player player, Entity entity) {
        Discovery<EntityType> discovery = this.getPlayer(player).getData().getSeenMobs();
        if (discovery.isNewDiscovery(entity.getType())) {
            this.xp(player, ((Config)this.getConfig()).discoverEntityTypeXP);
        }
        if (entity instanceof Player) {
            this.seePlayer(player, (Player)entity);
        }
        if (entity instanceof LivingEntity) {
            for (PotionEffect potionEffect : ((LivingEntity)entity).getActivePotionEffects()) {
                this.seePotionEffect(player, potionEffect);
            }
        }
    }

    public void seePlayer(Player player, Player player2) {
        Discovery<String> discovery = this.getPlayer(player).getData().getSeenPeople();
        if (discovery.isNewDiscovery(player2.getUniqueId().toString())) {
            this.xp(player, ((Config)this.getConfig()).discoverPlayerXP);
        }
    }

    public void seeEnchant(Player player, Enchantment enchantment, int n) {
        Discovery<String> discovery = this.getPlayer(player).getData().getSeenEnchants();
        if (discovery.isNewDiscovery(enchantment.getName() + " " + Form.toRoman(n))) {
            this.xp(player, ((Config)this.getConfig()).discoverEnchantBaseXP + Math.min(((Config)this.getConfig()).discoverEnchantMaxXP, (double)n * ((Config)this.getConfig()).discoverEnchantLevelXPMultiplier));
        }
    }

    public void seeWorld(Player player, World world) {
        Discovery<String> discovery = this.getPlayer(player).getData().getSeenWorlds();
        if (discovery.isNewDiscovery(world.getName() + "-" + world.getSeed())) {
            this.xp(player, ((Config)this.getConfig()).discoverWorldXP);
        }
        this.seeEnvironment(player, world.getEnvironment());
    }

    public void seeEnvironment(Player player, World.Environment environment) {
        Discovery<World.Environment> discovery = this.getPlayer(player).getData().getSeenEnvironments();
        if (discovery.isNewDiscovery(environment)) {
            this.xp(player, ((Config)this.getConfig()).discoverEnvironmentXP);
        }
    }

    public void seePotionEffect(Player player, PotionEffect potionEffect) {
        Discovery<String> discovery = this.getPlayer(player).getData().getSeenPotionEffects();
        if (discovery.isNewDiscovery(potionEffect.getType().getName() + " " + Form.toRoman(potionEffect.getAmplifier()).trim())) {
            this.xp(player, ((Config)this.getConfig()).discoverPotionXP);
        }
    }

    public void seeBiome(Player player, Biome biome) {
        Discovery<Biome> discovery = this.getPlayer(player).getData().getSeenBiomes();
        if (discovery.isNewDiscovery(biome)) {
            this.xp(player, ((Config)this.getConfig()).discoverBiomeXP);
        }
    }

    @Override
    public void onTick() {
        if (!this.isEnabled()) {
            return;
        }
        for (Player player : Bukkit.getOnlinePlayers()) {
            if (this.shouldReturnForPlayer(player)) continue;
            this.seeTargetBlock(player);
        }
    }

    private void seeTargetBlock(Player player) {
        try {
            Block block = player.getTargetBlockExact(5, FluidCollisionMode.NEVER);
            if (block != null) {
                this.seeBlock(player, block.getBlockData(), block.getLocation());
                this.seeBiome(player, block.getBiome());
            }
        }
        catch (Throwable throwable) {
            Adapt.verbose("Failed to get target block for " + player.getName());
        }
    }

    @Override
    public boolean isEnabled() {
        return ((Config)this.getConfig()).enabled;
    }

    static {
        IBootstrap.dasBoot();
    }

    protected static class Config {
        boolean enabled = true;
        boolean showParticles = true;
        double discoverBiomeXP = 15.0;
        double discoverPotionXP = 36.0;
        double discoverEntityTypeXP = 125.0;
        double discoverFoodTypeXP = 75.0;
        double discoverPlayerXP = 125.0;
        double discoverEnvironmentXP = 750.0;
        double discoverWorldXP = 750.0;
        double discoverEnchantMaxXP = 250.0;
        double discoverEnchantLevelXPMultiplier = 52.0;
        double discoverEnchantBaseXP = 5.0;
        double discoverItemBaseXP = 10.0;
        double discoverRecipeBaseXP = 15.0;
        double discoverItemValueXPMultiplier = 1.0;
        double discoverBlockBaseXP = 3.0;
        double discoverBlockValueXPMultiplier = 0.333;

        static {
            IBootstrap.dasBoot();
        }
    }
}

