/*
 * Decompiled with CFR 0.152.
 */
package com.volmit.adapt.content.skill;

import com.volmit.adapt.api.advancement.AdaptAdvancement;
import com.volmit.adapt.api.skill.SimpleSkill;
import com.volmit.adapt.api.world.AdaptPlayer;
import com.volmit.adapt.api.world.AdaptStatTracker;
import com.volmit.adapt.content.adaptation.enchanting.EnchantingLapisReturn;
import com.volmit.adapt.content.adaptation.enchanting.EnchantingQuickEnchant;
import com.volmit.adapt.content.adaptation.enchanting.EnchantingXPReturn;
import com.volmit.adapt.util.C;
import com.volmit.adapt.util.Localizer;
import com.volmit.adapt.util.advancements.advancement.AdvancementDisplay;
import com.volmit.adapt.util.advancements.advancement.AdvancementVisibility;
import com.volmit.adapt.util.manifold.rt.api.IBootstrap;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.Cancellable;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.enchantment.EnchantItemEvent;

public class SkillEnchanting
extends SimpleSkill<Config> {
    private final Map<Player, Long> cooldowns;

    public SkillEnchanting() {
        super("enchanting", Localizer.dLocalize("skill", "enchanting", "icon"));
        this.registerConfiguration(Config.class);
        this.setColor(C.LIGHT_PURPLE);
        this.setDescription(Localizer.dLocalize("skill", "enchanting", "description"));
        this.setDisplayName(Localizer.dLocalize("skill", "enchanting", "name"));
        this.setInterval(3909L);
        this.setIcon(Material.KNOWLEDGE_BOOK);
        this.cooldowns = new HashMap<Player, Long>();
        this.registerAdaptation(new EnchantingQuickEnchant());
        this.registerAdaptation(new EnchantingLapisReturn());
        this.registerAdaptation(new EnchantingXPReturn());
        this.registerAdvancement(AdaptAdvancement.builder().icon(Material.CRAFTING_TABLE).key("challenge_enchant_1k").title(Localizer.dLocalize("advancement", "challenge_enchant_1k", "title")).description(Localizer.dLocalize("advancement", "challenge_enchant_1k", "description")).frame(AdvancementDisplay.AdvancementFrame.CHALLENGE).visibility(AdvancementVisibility.PARENT_GRANTED).child(AdaptAdvancement.builder().icon(Material.KNOWLEDGE_BOOK).key("challenge_enchant_5k").title(Localizer.dLocalize("advancement", "challenge_enchant_5k", "title")).description(Localizer.dLocalize("advancement", "challenge_enchant_5k", "description")).frame(AdvancementDisplay.AdvancementFrame.CHALLENGE).visibility(AdvancementVisibility.PARENT_GRANTED).child(AdaptAdvancement.builder().icon(Material.KNOWLEDGE_BOOK).key("challenge_enchant_50k").title(Localizer.dLocalize("advancement", "challenge_enchant_50k", "title")).description(Localizer.dLocalize("advancement", "challenge_enchant_50k", "description")).frame(AdvancementDisplay.AdvancementFrame.CHALLENGE).visibility(AdvancementVisibility.PARENT_GRANTED).child(AdaptAdvancement.builder().icon(Material.KNOWLEDGE_BOOK).key("challenge_enchant_500k").title(Localizer.dLocalize("advancement", "challenge_enchant_500k", "title")).description(Localizer.dLocalize("advancement", "challenge_enchant_500k", "description")).frame(AdvancementDisplay.AdvancementFrame.CHALLENGE).visibility(AdvancementVisibility.PARENT_GRANTED).child(AdaptAdvancement.builder().icon(Material.KNOWLEDGE_BOOK).key("challenge_enchant_5m").title(Localizer.dLocalize("advancement", "challenge_enchant_5m", "title")).description(Localizer.dLocalize("advancement", "challenge_enchant_5m", "description")).frame(AdvancementDisplay.AdvancementFrame.CHALLENGE).visibility(AdvancementVisibility.PARENT_GRANTED).build()).build()).build()).build()).build());
        this.registerStatTracker(AdaptStatTracker.builder().advancement("challenge_enchant_1k").goal(1000.0).stat("enchanted.items").reward(((Config)this.getConfig()).challengeEnchantReward).build());
        this.registerStatTracker(AdaptStatTracker.builder().advancement("challenge_enchant_5k").goal(5000.0).stat("enchanted.items").reward(((Config)this.getConfig()).challengeEnchantReward).build());
        this.registerStatTracker(AdaptStatTracker.builder().advancement("challenge_enchant_50k").goal(50000.0).stat("enchanted.items").reward(((Config)this.getConfig()).challengeEnchantReward).build());
        this.registerStatTracker(AdaptStatTracker.builder().advancement("challenge_enchant_500k").goal(500000.0).stat("enchanted.items").reward(((Config)this.getConfig()).challengeEnchantReward).build());
        this.registerStatTracker(AdaptStatTracker.builder().advancement("challenge_enchant_5m").goal(5000000.0).stat("enchanted.items").reward(((Config)this.getConfig()).challengeEnchantReward).build());
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void on(EnchantItemEvent enchantItemEvent) {
        Player player = enchantItemEvent.getEnchanter();
        this.shouldReturnForPlayer(player, (Cancellable)enchantItemEvent, () -> this.handleEnchantItemEvent(player, enchantItemEvent));
    }

    private void handleEnchantItemEvent(Player player, EnchantItemEvent enchantItemEvent) {
        AdaptPlayer adaptPlayer = this.getPlayer(player);
        adaptPlayer.getData().addStat("enchanted.items", 1.0);
        adaptPlayer.getData().addStat("enchanted.power", enchantItemEvent.getEnchantsToAdd().values().stream().mapToInt(n -> n).sum());
        adaptPlayer.getData().addStat("enchanted.levels.spent", enchantItemEvent.getExpLevelCost());
        if (this.cooldowns.containsKey(player)) {
            if (this.cooldowns.get(player) + ((Config)this.getConfig()).cooldownDelay > System.currentTimeMillis()) {
                return;
            }
            this.cooldowns.remove(player);
        }
        this.cooldowns.put(player, System.currentTimeMillis());
        this.xp(player, ((Config)this.getConfig()).enchantPowerXPMultiplier * (double)enchantItemEvent.getEnchantsToAdd().values().stream().mapToInt(n -> n).sum());
    }

    @Override
    public void onTick() {
    }

    @Override
    public boolean isEnabled() {
        return ((Config)this.getConfig()).enabled;
    }

    static {
        IBootstrap.dasBoot();
    }

    protected static class Config {
        boolean enabled = true;
        double enchantPowerXPMultiplier = 70.0;
        long cooldownDelay = 5250L;
        double challengeEnchantReward = 2500.0;

        static {
            IBootstrap.dasBoot();
        }
    }
}

