/*
 * Decompiled with CFR 0.152.
 */
package com.volmit.adapt.content.skill;

import com.volmit.adapt.api.advancement.AdaptAdvancement;
import com.volmit.adapt.api.skill.SimpleSkill;
import com.volmit.adapt.api.world.AdaptPlayer;
import com.volmit.adapt.api.world.AdaptStatTracker;
import com.volmit.adapt.content.adaptation.excavation.ExcavationDropToInventory;
import com.volmit.adapt.content.adaptation.excavation.ExcavationHaste;
import com.volmit.adapt.content.adaptation.excavation.ExcavationOmniTool;
import com.volmit.adapt.content.adaptation.excavation.ExcavationSpelunker;
import com.volmit.adapt.util.C;
import com.volmit.adapt.util.Localizer;
import com.volmit.adapt.util.advancements.advancement.AdvancementDisplay;
import com.volmit.adapt.util.advancements.advancement.AdvancementVisibility;
import com.volmit.adapt.util.manifold.rt.api.IBootstrap;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.Material;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.Cancellable;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.inventory.ItemStack;

public class SkillExcavation
extends SimpleSkill<Config> {
    private final Map<Player, Long> cooldowns;

    public SkillExcavation() {
        super("excavation", Localizer.dLocalize("skill", "excavation", "icon"));
        this.registerConfiguration(Config.class);
        this.setDescription(Localizer.dLocalize("skill", "excavation", "description"));
        this.setDisplayName(Localizer.dLocalize("skill", "excavation", "name"));
        this.setColor(C.YELLOW);
        this.setInterval(5953L);
        this.setIcon(Material.DIAMOND_SHOVEL);
        this.cooldowns = new HashMap<Player, Long>();
        this.registerAdaptation(new ExcavationHaste());
        this.registerAdaptation(new ExcavationSpelunker());
        this.registerAdaptation(new ExcavationOmniTool());
        this.registerAdaptation(new ExcavationDropToInventory());
        this.registerAdvancement(AdaptAdvancement.builder().icon(Material.WOODEN_SHOVEL).key("challenge_excavate_1k").title(Localizer.dLocalize("advancement", "challenge_excavate_1k", "title")).description(Localizer.dLocalize("advancement", "challenge_excavate_1k", "description")).frame(AdvancementDisplay.AdvancementFrame.CHALLENGE).visibility(AdvancementVisibility.PARENT_GRANTED).child(AdaptAdvancement.builder().icon(Material.KNOWLEDGE_BOOK).key("challenge_excavate_5k").title(Localizer.dLocalize("advancement", "challenge_excavate_5k", "title")).description(Localizer.dLocalize("advancement", "challenge_excavate_5k", "description")).frame(AdvancementDisplay.AdvancementFrame.CHALLENGE).visibility(AdvancementVisibility.PARENT_GRANTED).child(AdaptAdvancement.builder().icon(Material.STONE_SHOVEL).key("challenge_excavate_50k").title(Localizer.dLocalize("advancement", "challenge_excavate_50k", "title")).description(Localizer.dLocalize("advancement", "challenge_excavate_50k", "description")).frame(AdvancementDisplay.AdvancementFrame.CHALLENGE).visibility(AdvancementVisibility.PARENT_GRANTED).child(AdaptAdvancement.builder().icon(Material.IRON_SHOVEL).key("challenge_excavate_500k").title(Localizer.dLocalize("advancement", "challenge_excavate_500k", "title")).description(Localizer.dLocalize("advancement", "challenge_excavate_500k", "description")).frame(AdvancementDisplay.AdvancementFrame.CHALLENGE).visibility(AdvancementVisibility.PARENT_GRANTED).child(AdaptAdvancement.builder().icon(Material.DIAMOND_SHOVEL).key("challenge_excavate_5m").title(Localizer.dLocalize("advancement", "challenge_excavate_5m", "title")).description(Localizer.dLocalize("advancement", "challenge_excavate_5m", "description")).frame(AdvancementDisplay.AdvancementFrame.CHALLENGE).visibility(AdvancementVisibility.PARENT_GRANTED).build()).build()).build()).build()).build());
        this.registerStatTracker(AdaptStatTracker.builder().advancement("challenge_excavate_1k").goal(1000.0).stat("excavation.blocks.broken").reward(((Config)this.getConfig()).challengeExcavationReward).build());
        this.registerStatTracker(AdaptStatTracker.builder().advancement("challenge_excavate_5k").goal(5000.0).stat("excavation.blocks.broken").reward(((Config)this.getConfig()).challengeExcavationReward).build());
        this.registerStatTracker(AdaptStatTracker.builder().advancement("challenge_excavate_50k").goal(50000.0).stat("excavation.blocks.broken").reward(((Config)this.getConfig()).challengeExcavationReward).build());
        this.registerStatTracker(AdaptStatTracker.builder().advancement("challenge_enchant_500k").goal(500000.0).stat("excavation.blocks.broken").reward(((Config)this.getConfig()).challengeExcavationReward).build());
        this.registerStatTracker(AdaptStatTracker.builder().advancement("challenge_excavate_5m").goal(5000000.0).stat("excavation.blocks.broken").reward(((Config)this.getConfig()).challengeExcavationReward).build());
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void on(EntityDamageByEntityEvent entityDamageByEntityEvent) {
        Entity entity = entityDamageByEntityEvent.getDamager();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (this.checkValidEntity(entityDamageByEntityEvent.getEntity().getType())) {
                if (!((Config)this.getConfig()).getXpForAttackingWithTools) {
                    return;
                }
                this.shouldReturnForPlayer(player, (Cancellable)entityDamageByEntityEvent, () -> this.handleEntityDamageByPlayer(player, entityDamageByEntityEvent));
            }
        }
    }

    private void handleEntityDamageByPlayer(Player player, EntityDamageByEntityEvent entityDamageByEntityEvent) {
        AdaptPlayer adaptPlayer = this.getPlayer(player);
        ItemStack itemStack = adaptPlayer.getPlayer().getInventory().getItemInMainHand();
        if (this.isShovel(itemStack)) {
            if (this.cooldowns.containsKey(player)) {
                if (this.cooldowns.get(player) + ((Config)this.getConfig()).cooldownDelay > System.currentTimeMillis()) {
                    return;
                }
                this.cooldowns.remove(player);
            }
            this.cooldowns.put(player, System.currentTimeMillis());
            this.getPlayer(player).getData().addStat("excavation.swings", 1.0);
            this.getPlayer(player).getData().addStat("excavation.damage", entityDamageByEntityEvent.getDamage());
            this.xp(adaptPlayer.getPlayer(), entityDamageByEntityEvent.getEntity().getLocation(), ((Config)this.getConfig()).axeDamageXPMultiplier * entityDamageByEntityEvent.getDamage());
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void on(BlockBreakEvent blockBreakEvent) {
        Player player = blockBreakEvent.getPlayer();
        this.shouldReturnForPlayer(player, (Cancellable)blockBreakEvent, () -> {
            if (this.isShovel(player.getInventory().getItemInMainHand())) {
                this.handleBlockBreakWithShovel(player, blockBreakEvent);
            }
        });
    }

    private void handleBlockBreakWithShovel(Player player, BlockBreakEvent blockBreakEvent) {
        this.getPlayer(player).getData().addStat("excavation.blocks.broken", 1.0);
        this.getPlayer(player).getData().addStat("excavation.blocks.value", this.getValue(blockBreakEvent.getBlock().getBlockData()));
        if (this.cooldowns.containsKey(player)) {
            if (this.cooldowns.get(player) + ((Config)this.getConfig()).cooldownDelay > System.currentTimeMillis()) {
                return;
            }
            this.cooldowns.remove(player);
        }
        this.cooldowns.put(player, System.currentTimeMillis());
        double d = this.getValue(blockBreakEvent.getBlock().getType());
        this.xp(player, blockBreakEvent.getBlock().getLocation().clone().add(0.5, 0.5, 0.5), this.blockXP(blockBreakEvent.getBlock(), d));
    }

    @Override
    public double getValue(Material material) {
        double d = super.getValue(material) * ((Config)this.getConfig()).valueXPMultiplier;
        d += Math.min(((Config)this.getConfig()).maxHardnessBonus, (double)material.getHardness());
        return d += Math.min(((Config)this.getConfig()).maxBlastResistanceBonus, (double)material.getBlastResistance());
    }

    @Override
    public void onTick() {
    }

    @Override
    public boolean isEnabled() {
        return ((Config)this.getConfig()).enabled;
    }

    static {
        IBootstrap.dasBoot();
    }

    protected static class Config {
        boolean enabled = true;
        boolean getXpForAttackingWithTools = true;
        double maxHardnessBonus = 9.0;
        double maxBlastResistanceBonus = 10.0;
        double challengeExcavationReward = 1200.0;
        double valueXPMultiplier = 0.825;
        long cooldownDelay = 1250L;
        double axeDamageXPMultiplier = 6.5;

        static {
            IBootstrap.dasBoot();
        }
    }
}

