/*
 * Decompiled with CFR 0.152.
 */
package com.volmit.adapt.content.skill;

import com.volmit.adapt.api.skill.SimpleSkill;
import com.volmit.adapt.content.adaptation.nether.NetherFireResist;
import com.volmit.adapt.content.adaptation.nether.NetherSkullYeet;
import com.volmit.adapt.content.adaptation.nether.NetherWitherResist;
import com.volmit.adapt.util.C;
import com.volmit.adapt.util.Localizer;
import com.volmit.adapt.util.manifold.rt.api.IBootstrap;
import org.bukkit.Material;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.event.Cancellable;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.entity.EntityDamageByBlockEvent;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityDeathEvent;

public class SkillNether
extends SimpleSkill<Config> {
    private int witherRoseCooldown;

    public SkillNether() {
        super("nether", Localizer.dLocalize("skill", "nether", "icon"));
        this.registerConfiguration(Config.class);
        this.setDescription(Localizer.dLocalize("skill", "nether", "description"));
        this.setDisplayName(Localizer.dLocalize("skill", "nether", "name"));
        this.setInterval(7425L);
        this.setColor(C.DARK_GRAY);
        this.setIcon(Material.NETHER_STAR);
        this.registerAdaptation(new NetherWitherResist());
        this.registerAdaptation(new NetherSkullYeet());
        this.registerAdaptation(new NetherFireResist());
    }

    private boolean shouldReturnForEventWithCause(Player player, EntityDamageEvent.DamageCause damageCause) {
        return this.shouldReturnForPlayer(player) || damageCause != EntityDamageEvent.DamageCause.WITHER;
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void on(EntityDamageEvent entityDamageEvent) {
        Player player;
        Entity entity;
        if (!this.isEnabled() || entityDamageEvent.isCancelled() || !((entity = entityDamageEvent.getEntity()) instanceof Player) || this.shouldReturnForEventWithCause(player = (Player)entity, entityDamageEvent.getCause()) || entityDamageEvent instanceof EntityDamageByBlockEvent) {
            return;
        }
        this.xp(player, ((Config)this.getConfig()).getWitherDamageXp());
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void on(BlockBreakEvent blockBreakEvent) {
        Player player = blockBreakEvent.getPlayer();
        this.shouldReturnForPlayer(blockBreakEvent.getPlayer(), (Cancellable)blockBreakEvent, () -> {
            if (blockBreakEvent.getBlock().getType() == Material.WITHER_ROSE && this.witherRoseCooldown == 0) {
                this.witherRoseCooldown = ((Config)this.getConfig()).getWitherRoseBreakCooldown();
                this.xp(player, blockBreakEvent.getBlock().getLocation().add(0.5, 0.5, 0.5), ((Config)this.getConfig()).getWitherRoseBreakXp());
            }
        });
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void on(EntityDeathEvent entityDeathEvent) {
        Player player = entityDeathEvent.getEntity().getKiller();
        if (player == null || !player.getClass().getSimpleName().equals("CraftPlayer") || this.shouldReturnForPlayer(player)) {
            return;
        }
        if (entityDeathEvent.getEntityType() == EntityType.WITHER_SKELETON) {
            this.xp(player, ((Config)this.getConfig()).getWitherSkeletonKillXp());
        } else if (entityDeathEvent.getEntityType() == EntityType.WITHER) {
            this.xp(player, ((Config)this.getConfig()).getWitherKillXp());
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void on(EntityDamageByEntityEvent entityDamageByEntityEvent) {
        Player player;
        Entity entity = entityDamageByEntityEvent.getDamager();
        if (!(entity instanceof Player) || this.shouldReturnForEventWithCause(player = (Player)entity, entityDamageByEntityEvent.getCause())) {
            return;
        }
        this.xp(player, ((Config)this.getConfig()).getWitherAttackXp());
    }

    @Override
    public void onTick() {
        if (!this.isEnabled()) {
            return;
        }
        if (this.witherRoseCooldown > 0) {
            --this.witherRoseCooldown;
        }
    }

    @Override
    public boolean isEnabled() {
        return ((Config)this.getConfig()).isEnabled();
    }

    static {
        IBootstrap.dasBoot();
    }

    public static class Config {
        private boolean enabled = true;
        private double witherDamageXp = 26.0;
        private double witherAttackXp = 15.0;
        private double witherSkeletonKillXp = 325.0;
        private double witherKillXp = 1250.0;
        private double witherRoseBreakXp = 125.0;
        private int witherRoseBreakCooldown = 1200;

        public boolean isEnabled() {
            return this.enabled;
        }

        public double getWitherDamageXp() {
            return this.witherDamageXp;
        }

        public double getWitherAttackXp() {
            return this.witherAttackXp;
        }

        public double getWitherSkeletonKillXp() {
            return this.witherSkeletonKillXp;
        }

        public double getWitherKillXp() {
            return this.witherKillXp;
        }

        public double getWitherRoseBreakXp() {
            return this.witherRoseBreakXp;
        }

        public int getWitherRoseBreakCooldown() {
            return this.witherRoseBreakCooldown;
        }

        public void setEnabled(boolean bl) {
            this.enabled = bl;
        }

        public void setWitherDamageXp(double d) {
            this.witherDamageXp = d;
        }

        public void setWitherAttackXp(double d) {
            this.witherAttackXp = d;
        }

        public void setWitherSkeletonKillXp(double d) {
            this.witherSkeletonKillXp = d;
        }

        public void setWitherKillXp(double d) {
            this.witherKillXp = d;
        }

        public void setWitherRoseBreakXp(double d) {
            this.witherRoseBreakXp = d;
        }

        public void setWitherRoseBreakCooldown(int n) {
            this.witherRoseBreakCooldown = n;
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (!(object instanceof Config)) {
                return false;
            }
            Config config = (Config)object;
            if (!config.canEqual(this)) {
                return false;
            }
            if (this.isEnabled() != config.isEnabled()) {
                return false;
            }
            if (Double.compare(this.getWitherDamageXp(), config.getWitherDamageXp()) != 0) {
                return false;
            }
            if (Double.compare(this.getWitherAttackXp(), config.getWitherAttackXp()) != 0) {
                return false;
            }
            if (Double.compare(this.getWitherSkeletonKillXp(), config.getWitherSkeletonKillXp()) != 0) {
                return false;
            }
            if (Double.compare(this.getWitherKillXp(), config.getWitherKillXp()) != 0) {
                return false;
            }
            if (Double.compare(this.getWitherRoseBreakXp(), config.getWitherRoseBreakXp()) != 0) {
                return false;
            }
            return this.getWitherRoseBreakCooldown() == config.getWitherRoseBreakCooldown();
        }

        protected boolean canEqual(Object object) {
            return object instanceof Config;
        }

        public int hashCode() {
            int n = 59;
            int n2 = 1;
            n2 = n2 * 59 + (this.isEnabled() ? 79 : 97);
            long l = Double.doubleToLongBits(this.getWitherDamageXp());
            n2 = n2 * 59 + (int)(l >>> 32 ^ l);
            long l2 = Double.doubleToLongBits(this.getWitherAttackXp());
            n2 = n2 * 59 + (int)(l2 >>> 32 ^ l2);
            long l3 = Double.doubleToLongBits(this.getWitherSkeletonKillXp());
            n2 = n2 * 59 + (int)(l3 >>> 32 ^ l3);
            long l4 = Double.doubleToLongBits(this.getWitherKillXp());
            n2 = n2 * 59 + (int)(l4 >>> 32 ^ l4);
            long l5 = Double.doubleToLongBits(this.getWitherRoseBreakXp());
            n2 = n2 * 59 + (int)(l5 >>> 32 ^ l5);
            n2 = n2 * 59 + this.getWitherRoseBreakCooldown();
            return n2;
        }

        public String toString() {
            return "SkillNether.Config(enabled=" + this.isEnabled() + ", witherDamageXp=" + this.getWitherDamageXp() + ", witherAttackXp=" + this.getWitherAttackXp() + ", witherSkeletonKillXp=" + this.getWitherSkeletonKillXp() + ", witherKillXp=" + this.getWitherKillXp() + ", witherRoseBreakXp=" + this.getWitherRoseBreakXp() + ", witherRoseBreakCooldown=" + this.getWitherRoseBreakCooldown() + ")";
        }

        static {
            IBootstrap.dasBoot();
        }
    }
}

