/*
 * Decompiled with CFR 0.152.
 */
package com.volmit.adapt.content.skill;

import com.volmit.adapt.Adapt;
import com.volmit.adapt.api.advancement.AdaptAdvancement;
import com.volmit.adapt.api.skill.SimpleSkill;
import com.volmit.adapt.api.world.AdaptStatTracker;
import com.volmit.adapt.content.adaptation.seaborrne.SeaborneFishersFantasy;
import com.volmit.adapt.content.adaptation.seaborrne.SeaborneOxygen;
import com.volmit.adapt.content.adaptation.seaborrne.SeaborneSpeed;
import com.volmit.adapt.content.adaptation.seaborrne.SeaborneTurtlesMiningSpeed;
import com.volmit.adapt.content.adaptation.seaborrne.SeaborneTurtlesVision;
import com.volmit.adapt.util.C;
import com.volmit.adapt.util.Localizer;
import com.volmit.adapt.util.advancements.advancement.AdvancementDisplay;
import com.volmit.adapt.util.advancements.advancement.AdvancementVisibility;
import com.volmit.adapt.util.manifold.rt.api.IBootstrap;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.attribute.Attribute;
import org.bukkit.entity.Drowned;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.entity.Trident;
import org.bukkit.event.Cancellable;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.player.PlayerFishEvent;

public class SkillSeaborne
extends SimpleSkill<Config> {
    private final Map<Player, Long> cooldowns;

    public SkillSeaborne() {
        super("seaborne", Localizer.dLocalize("skill", "seaborne", "icon"));
        this.registerConfiguration(Config.class);
        this.setColor(C.BLUE);
        this.setDescription(Localizer.dLocalize("skill", "seaborne", "description"));
        this.setDisplayName(Localizer.dLocalize("skill", "seaborne", "name"));
        this.setInterval(2120L);
        this.setIcon(Material.TRIDENT);
        this.registerAdaptation(new SeaborneOxygen());
        this.registerAdaptation(new SeaborneSpeed());
        this.registerAdaptation(new SeaborneFishersFantasy());
        this.registerAdaptation(new SeaborneTurtlesVision());
        this.registerAdaptation(new SeaborneTurtlesMiningSpeed());
        this.registerAdvancement(AdaptAdvancement.builder().icon(Material.TURTLE_HELMET).key("challenge_swim_1nm").title("Human Submarine!").description("Swim 1 Nautical Mile (1,852 blocks)").frame(AdvancementDisplay.AdvancementFrame.CHALLENGE).visibility(AdvancementVisibility.PARENT_GRANTED).build());
        this.registerStatTracker(AdaptStatTracker.builder().advancement("challenge_swim_1nm").goal(1852.0).stat("move.swim").reward(((Config)this.getConfig()).challengeSwim1nmReward).build());
        this.cooldowns = new HashMap<Player, Long>();
    }

    private boolean isOnCooldown(Player player, long l) {
        if (this.cooldowns.containsKey(player)) {
            if (this.cooldowns.get(player) + l > System.currentTimeMillis()) {
                return true;
            }
            this.cooldowns.remove(player);
        }
        return false;
    }

    private void setCooldown(Player player) {
        this.cooldowns.put(player, System.currentTimeMillis());
    }

    @Override
    public void onTick() {
        if (!this.isEnabled()) {
            return;
        }
        for (Player player : Bukkit.getOnlinePlayers()) {
            this.shouldReturnForPlayer(player, () -> {
                if (player.getWorld().getBlockAt(player.getLocation()).isLiquid() && player.isSwimming() && player.getPlayer() != null && player.getPlayer().getRemainingAir() < player.getMaximumAir()) {
                    Adapt.verbose("seaborne Tick");
                    this.checkStatTrackers(this.getPlayer(player));
                    this.xpSilent(player, ((Config)this.getConfig()).swimXP);
                }
            });
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void on(PlayerFishEvent playerFishEvent) {
        Player player = playerFishEvent.getPlayer();
        this.shouldReturnForPlayer(playerFishEvent.getPlayer(), (Cancellable)playerFishEvent, () -> {
            if (playerFishEvent.getState().equals((Object)PlayerFishEvent.State.CAUGHT_FISH)) {
                this.xp(player, 300.0);
            } else if (playerFishEvent.getState().equals((Object)PlayerFishEvent.State.CAUGHT_ENTITY)) {
                this.xp(player, 10.0);
            }
        });
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void on(BlockBreakEvent blockBreakEvent) {
        Player player = blockBreakEvent.getPlayer();
        this.shouldReturnForPlayer(blockBreakEvent.getPlayer(), (Cancellable)blockBreakEvent, () -> {
            if (this.isOnCooldown(player, ((Config)this.getConfig()).seaPickleCooldown)) {
                return;
            }
            this.setCooldown(player);
            if (blockBreakEvent.getBlock().getType().equals((Object)Material.SEA_PICKLE) && player.isSwimming() && player.getRemainingAir() < player.getMaximumAir()) {
                this.xpSilent(player, 10.0);
            } else {
                this.xpSilent(player, 3.0);
            }
        });
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void on(EntityDamageByEntityEvent entityDamageByEntityEvent) {
        Entity entity;
        Player player;
        Entity entity2;
        if (entityDamageByEntityEvent.getEntity() instanceof Drowned && (entity2 = entityDamageByEntityEvent.getDamager()) instanceof Player) {
            player = (Player)entity2;
            this.shouldReturnForPlayer(player, (Cancellable)entityDamageByEntityEvent, () -> {
                if (this.isOnCooldown(player, ((Config)this.getConfig()).seaPickleCooldown)) {
                    return;
                }
                this.setCooldown(player);
                this.xp(player, ((Config)this.getConfig()).damagedrownxpmultiplier * Math.min(entityDamageByEntityEvent.getDamage(), ((LivingEntity)entityDamageByEntityEvent.getEntity()).getAttribute(Attribute.GENERIC_MAX_HEALTH).getBaseValue()));
            });
        }
        if ((entity = entityDamageByEntityEvent.getDamager()) instanceof Projectile && (player = (Projectile)entity) instanceof Trident && (entity = ((Projectile)entityDamageByEntityEvent.getDamager()).getShooter()) instanceof Player) {
            entity2 = (Player)entity;
            this.shouldReturnForPlayer((Player)entity2, (Cancellable)entityDamageByEntityEvent, () -> this.lambda$on$4((Player)entity2, entityDamageByEntityEvent));
        }
        if ((entity2 = entityDamageByEntityEvent.getDamager()) instanceof Player && (player = (Player)entity2).getInventory().getItemInMainHand().getType().equals((Object)Material.TRIDENT)) {
            this.shouldReturnForPlayer(player, (Cancellable)entityDamageByEntityEvent, () -> this.xp(player, ((Config)this.getConfig()).tridentxpmultiplier * Math.min(entityDamageByEntityEvent.getDamage(), ((LivingEntity)entityDamageByEntityEvent.getEntity()).getAttribute(Attribute.GENERIC_MAX_HEALTH).getBaseValue())));
        }
    }

    @Override
    public boolean isEnabled() {
        return ((Config)this.getConfig()).enabled;
    }

    private /* synthetic */ void lambda$on$4(Player player, EntityDamageByEntityEvent entityDamageByEntityEvent) {
        this.xp(player, ((Config)this.getConfig()).tridentxpmultiplier * Math.min(entityDamageByEntityEvent.getDamage(), ((LivingEntity)entityDamageByEntityEvent.getEntity()).getAttribute(Attribute.GENERIC_MAX_HEALTH).getBaseValue()));
    }

    static {
        IBootstrap.dasBoot();
    }

    protected static class Config {
        public long seaPickleCooldown = 60000L;
        public double tridentxpmultiplier = 2.5;
        double damagedrownxpmultiplier = 3.0;
        boolean enabled = true;
        double challengeSwim1nmReward = 750.0;
        double swimXP = 28.7;

        static {
            IBootstrap.dasBoot();
        }
    }
}

