/*
 * Decompiled with CFR 0.152.
 */
package com.volmit.adapt.content.skill;

import com.volmit.adapt.api.skill.SimpleSkill;
import com.volmit.adapt.content.adaptation.taming.TamingDamage;
import com.volmit.adapt.content.adaptation.taming.TamingHealthBoost;
import com.volmit.adapt.content.adaptation.taming.TamingHealthRegeneration;
import com.volmit.adapt.util.C;
import com.volmit.adapt.util.Localizer;
import com.volmit.adapt.util.manifold.rt.api.IBootstrap;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Tameable;
import org.bukkit.event.Cancellable;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.entity.EntityBreedEvent;
import org.bukkit.event.entity.EntityDamageByEntityEvent;

public class SkillTaming
extends SimpleSkill<Config> {
    private final Map<Player, Long> cooldowns;

    public SkillTaming() {
        super("taming", Localizer.dLocalize("skill", "taming", "icon"));
        this.registerConfiguration(Config.class);
        this.setDescription(Localizer.dLocalize("skill", "taming", "description"));
        this.setDisplayName(Localizer.dLocalize("skill", "taming", "name"));
        this.setColor(C.GOLD);
        this.setInterval(3480L);
        this.setIcon(Material.LEAD);
        this.cooldowns = new HashMap<Player, Long>();
        this.registerAdaptation(new TamingHealthBoost());
        this.registerAdaptation(new TamingDamage());
        this.registerAdaptation(new TamingHealthRegeneration());
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void on(EntityBreedEvent entityBreedEvent) {
        for (Player player : Bukkit.getOnlinePlayers()) {
            this.shouldReturnForPlayer(player, (Cancellable)entityBreedEvent, () -> {
                if (player.getWorld() == entityBreedEvent.getEntity().getWorld() && player.getLocation().distance(entityBreedEvent.getEntity().getLocation()) <= 15.0 && !this.isOnCooldown(player)) {
                    this.setCooldown(player);
                    this.xp(player, ((Config)this.getConfig()).tameXpBase);
                }
            });
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void on(EntityDamageByEntityEvent entityDamageByEntityEvent) {
        Tameable tameable;
        Entity entity = entityDamageByEntityEvent.getDamager();
        if (entity instanceof Tameable && (tameable = (Tameable)entity).isTamed() && (entity = tameable.getOwner()) instanceof Player) {
            Player player = (Player)entity;
            this.shouldReturnForPlayer(player, (Cancellable)entityDamageByEntityEvent, () -> {
                if (!this.isOnCooldown(player)) {
                    this.setCooldown(player);
                    this.xp(player, entityDamageByEntityEvent.getEntity().getLocation(), entityDamageByEntityEvent.getDamage() * ((Config)this.getConfig()).tameDamageXPMultiplier);
                }
            });
        }
    }

    private boolean isOnCooldown(Player player) {
        if (this.cooldowns.containsKey(player)) {
            if (this.cooldowns.get(player) + ((Config)this.getConfig()).cooldownDelay > System.currentTimeMillis()) {
                return true;
            }
            this.cooldowns.remove(player);
        }
        return false;
    }

    private void setCooldown(Player player) {
        this.cooldowns.put(player, System.currentTimeMillis());
    }

    @Override
    public void onTick() {
    }

    @Override
    public boolean isEnabled() {
        return ((Config)this.getConfig()).enabled;
    }

    static {
        IBootstrap.dasBoot();
    }

    protected static class Config {
        boolean enabled = true;
        double tameXpBase = 30.0;
        long cooldownDelay = 2250L;
        double tameDamageXPMultiplier = 7.85;

        static {
            IBootstrap.dasBoot();
        }
    }
}

