/*
 * Decompiled with CFR 0.152.
 */
package com.volmit.adapt.nms;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.volmit.adapt.util.manifold.rt.api.IBootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.plugin.Plugin;

public class GlowingEntities
implements Listener {
    private final Plugin plugin;
    private Map<Player, PlayerData> glowing;
    private boolean enabled = false;
    private int uuid;

    public GlowingEntities(Plugin plugin) {
        if (!Packets.enabled) {
            throw new IllegalStateException("The Glowing Entities API is disabled. An error has occured during initialization.");
        }
        this.plugin = plugin;
        this.enable();
    }

    public void enable() {
        if (this.enabled) {
            throw new IllegalStateException("The Glowing Entities API has already been enabled.");
        }
        this.plugin.getServer().getPluginManager().registerEvents((Listener)this, this.plugin);
        this.glowing = new HashMap<Player, PlayerData>();
        this.uuid = ThreadLocalRandom.current().nextInt(Integer.MAX_VALUE);
        this.enabled = true;
    }

    public void disable() {
        if (!this.enabled) {
            return;
        }
        HandlerList.unregisterAll((Listener)this);
        this.glowing.values().forEach(playerData -> {
            try {
                Packets.removePacketsHandler(playerData);
            }
            catch (ReflectiveOperationException reflectiveOperationException) {
                reflectiveOperationException.printStackTrace();
            }
        });
        this.glowing = null;
        this.uuid = 0;
        this.enabled = false;
    }

    private void ensureEnabled() {
        if (!this.enabled) {
            throw new IllegalStateException("The Glowing Entities API is not enabled.");
        }
    }

    @EventHandler
    public void onQuit(PlayerQuitEvent playerQuitEvent) {
        this.glowing.remove(playerQuitEvent.getPlayer());
    }

    public void setGlowing(Entity entity, Player player) {
        this.setGlowing(entity, player, null);
    }

    public void setGlowing(Entity entity, Player player, ChatColor chatColor) {
        String string = entity instanceof Player ? entity.getName() : entity.getUniqueId().toString();
        this.setGlowing(entity.getEntityId(), string, player, chatColor, Packets.getEntityFlags(entity));
    }

    public void setGlowing(int n, String string, Player player) {
        this.setGlowing(n, string, player, null, (byte)0);
    }

    public void setGlowing(int n, String string, Player player, ChatColor chatColor) {
        this.setGlowing(n, string, player, chatColor, (byte)0);
    }

    public void setGlowing(int n, String string, Player player, ChatColor chatColor, byte by) {
        GlowingData glowingData;
        this.ensureEnabled();
        if (chatColor != null && !chatColor.isColor()) {
            throw new IllegalArgumentException("ChatColor must be a color format");
        }
        PlayerData playerData = this.glowing.get(player);
        if (playerData == null) {
            playerData = new PlayerData(this, player);
            Packets.addPacketsHandler(playerData);
            this.glowing.put(player, playerData);
        }
        if ((glowingData = playerData.glowingDatas.get(n)) == null) {
            glowingData = new GlowingData(playerData, n, string, chatColor, by);
            playerData.glowingDatas.put(n, glowingData);
            Packets.createGlowing(glowingData);
            if (chatColor != null) {
                Packets.setGlowingColor(glowingData);
            }
        } else {
            if (Objects.equals(glowingData.color, chatColor)) {
                return;
            }
            if (chatColor == null) {
                Packets.removeGlowingColor(glowingData);
                glowingData.color = chatColor;
            } else {
                glowingData.color = chatColor;
                Packets.setGlowingColor(glowingData);
            }
        }
    }

    public void unsetGlowing(Entity entity, Player player) {
        this.unsetGlowing(entity.getEntityId(), player);
    }

    public void unsetGlowing(int n, Player player) {
        this.ensureEnabled();
        PlayerData playerData = this.glowing.get(player);
        if (playerData == null) {
            return;
        }
        GlowingData glowingData = playerData.glowingDatas.remove(n);
        if (glowingData == null) {
            return;
        }
        Packets.removeGlowing(glowingData);
        if (glowingData.color != null) {
            Packets.removeGlowingColor(glowingData);
        }
    }

    static {
        IBootstrap.dasBoot();
    }

    private static class Packets {
        private static final byte GLOWING_FLAG = 64;
        private static Cache<Object, Object> packets;
        private static Object dummy;
        private static Logger logger;
        private static int version;
        private static int versionMinor;
        private static String cpack;
        private static ProtocolMappings mappings;
        public static boolean enabled;
        private static Method getHandle;
        private static Method getDataWatcher;
        private static Object watcherObjectFlags;
        private static Object watcherDummy;
        private static Method watcherGet;
        private static Constructor<?> watcherItemConstructor;
        private static Method watcherItemObject;
        private static Method watcherItemDataGet;
        private static Method watcherBCreator;
        private static Method watcherBId;
        private static Method watcherBSerializer;
        private static Method watcherSerializerObject;
        private static Field playerConnection;
        private static Method sendPacket;
        private static Field networkManager;
        private static Field channelField;
        private static Class<?> packetMetadata;
        private static Constructor<?> packetMetadataConstructor;
        private static Field packetMetadataEntity;
        private static Field packetMetadataItems;
        private static Class<?> packetBundle;
        private static Method packetBundlePackets;
        private static EnumMap<ChatColor, TeamData> teams;
        private static Constructor<?> createTeamPacket;
        private static Constructor<?> createTeamPacketData;
        private static Constructor<?> createTeam;
        private static Object scoreboardDummy;
        private static Object pushNever;
        private static Method setTeamPush;
        private static Method setTeamColor;
        private static Method getColorConstant;

        private Packets() {
        }

        public static void sendPackets(Player player, Object ... objectArray) {
            Object object = playerConnection.get(getHandle.invoke((Object)player, new Object[0]));
            for (Object object2 : objectArray) {
                if (object2 == null) continue;
                sendPacket.invoke(object, object2);
            }
        }

        public static byte getEntityFlags(Entity entity) {
            Object object = getHandle.invoke((Object)entity, new Object[0]);
            Object object2 = getDataWatcher.invoke(object, new Object[0]);
            return (Byte)watcherGet.invoke(object2, watcherObjectFlags);
        }

        public static void createGlowing(GlowingData glowingData) {
            Packets.setMetadata(glowingData, Packets.computeFlags(glowingData));
        }

        private static byte computeFlags(GlowingData glowingData) {
            byte by = glowingData.otherFlags;
            by = glowingData.enabled ? (byte)(by | 0x40) : (byte)(by & 0xFFFFFFBF);
            return by;
        }

        public static Object createFlagWatcherItem(byte by) {
            return watcherItemConstructor != null ? watcherItemConstructor.newInstance(watcherObjectFlags, by) : watcherBCreator.invoke(null, watcherObjectFlags, by);
        }

        public static void removeGlowing(GlowingData glowingData) {
            Packets.setMetadata(glowingData, glowingData.otherFlags);
        }

        public static void updateGlowingState(GlowingData glowingData) {
            if (glowingData.enabled) {
                Packets.createGlowing(glowingData);
            } else {
                Packets.removeGlowing(glowingData);
            }
        }

        private static void setMetadata(GlowingData glowingData, byte by) {
            Object obj;
            ArrayList arrayList = new ArrayList(1);
            arrayList.add(watcherItemConstructor != null ? watcherItemConstructor.newInstance(watcherObjectFlags, by) : watcherBCreator.invoke(null, watcherObjectFlags, by));
            if (version < 19 || version == 19 && versionMinor < 3) {
                obj = packetMetadataConstructor.newInstance(glowingData.entityID, watcherDummy, false);
                packetMetadataItems.set(obj, arrayList);
            } else {
                obj = packetMetadataConstructor.newInstance(glowingData.entityID, arrayList);
            }
            packets.put(obj, dummy);
            Packets.sendPackets(glowingData.player.player, obj);
        }

        public static void setGlowingColor(GlowingData glowingData) {
            boolean bl = false;
            if (glowingData.player.sentColors == null) {
                glowingData.player.sentColors = EnumSet.of(glowingData.color);
                bl = true;
            } else if (glowingData.player.sentColors.add(glowingData.color)) {
                bl = true;
            }
            TeamData teamData = teams.get(glowingData.color);
            if (teamData == null) {
                teamData = new TeamData(glowingData.player.instance.uuid, glowingData.color);
                teams.put(glowingData.color, teamData);
            }
            Object object = teamData.getEntityAddPacket(glowingData.teamID);
            if (bl) {
                Packets.sendPackets(glowingData.player.player, teamData.creationPacket, object);
            } else {
                Packets.sendPackets(glowingData.player.player, object);
            }
        }

        public static void removeGlowingColor(GlowingData glowingData) {
            TeamData teamData = teams.get(glowingData.color);
            if (teamData == null) {
                return;
            }
            Packets.sendPackets(glowingData.player.player, teamData.getEntityRemovePacket(glowingData.teamID));
        }

        private static Channel getChannel(Player player) {
            return (Channel)channelField.get(networkManager.get(playerConnection.get(getHandle.invoke((Object)player, new Object[0]))));
        }

        public static void addPacketsHandler(final PlayerData playerData) {
            playerData.packetsHandler = new ChannelDuplexHandler(){

                public void write(ChannelHandlerContext channelHandlerContext, Object object, ChannelPromise channelPromise) {
                    if (object.getClass().equals(packetMetadata) && packets.asMap().remove(object) == null) {
                        ArrayList<Object> arrayList;
                        int n = packetMetadataEntity.getInt(object);
                        GlowingData glowingData = playerData.glowingDatas.get(n);
                        if (glowingData != null && (arrayList = (ArrayList<Object>)packetMetadataItems.get(object)) != null) {
                            byte by;
                            boolean bl = false;
                            boolean bl2 = false;
                            for (by = 0; by < arrayList.size(); ++by) {
                                byte by2;
                                Object object2;
                                Object e = arrayList.get(by);
                                if (watcherItemObject != null) {
                                    object2 = watcherItemObject.invoke(e, new Object[0]);
                                } else {
                                    Object object3 = watcherBSerializer.invoke(e, new Object[0]);
                                    object2 = watcherSerializerObject.invoke(object3, watcherBId.invoke(e, new Object[0]));
                                }
                                if (!object2.equals(watcherObjectFlags)) continue;
                                bl = true;
                                glowingData.otherFlags = by2 = ((Byte)watcherItemDataGet.invoke(e, new Object[0])).byteValue();
                                byte by3 = Packets.computeFlags(glowingData);
                                if (by3 == by2) continue;
                                bl2 = true;
                                arrayList = new ArrayList(arrayList);
                                arrayList.set(by, Packets.createFlagWatcherItem(by3));
                                break;
                            }
                            if (!bl2 && !bl && (by = (byte)Packets.computeFlags(glowingData)) != 0) {
                                bl2 = true;
                                arrayList = new ArrayList<Object>(arrayList);
                                arrayList.add(Packets.createFlagWatcherItem(by));
                            }
                            if (bl2) {
                                Object obj;
                                if (version < 19 || version == 19 && versionMinor < 3) {
                                    obj = packetMetadataConstructor.newInstance(n, watcherDummy, false);
                                    packetMetadataItems.set(obj, arrayList);
                                } else {
                                    obj = packetMetadataConstructor.newInstance(n, arrayList);
                                }
                                packets.put(obj, dummy);
                                Packets.sendPackets(playerData.player, obj);
                                return;
                            }
                        }
                    } else if (packetBundle != null && object.getClass().equals(packetBundle)) {
                        this.handlePacketBundle(object);
                    }
                    super.write(channelHandlerContext, object, channelPromise);
                }

                private void handlePacketBundle(Object object) {
                    Iterable iterable = (Iterable)packetBundlePackets.invoke(object, new Object[0]);
                    for (Object t : iterable) {
                        int n;
                        GlowingData glowingData;
                        if (!t.getClass().equals(packetMetadata) || (glowingData = playerData.glowingDatas.get(n = packetMetadataEntity.getInt(t))) == null) continue;
                        Bukkit.getScheduler().runTaskLaterAsynchronously(playerData.instance.plugin, () -> {
                            try {
                                Packets.updateGlowingState(glowingData);
                            }
                            catch (ReflectiveOperationException reflectiveOperationException) {
                                reflectiveOperationException.printStackTrace();
                            }
                        }, 1L);
                        return;
                    }
                }
            };
            Packets.getChannel(playerData.player).pipeline().addBefore("packet_handler", null, playerData.packetsHandler);
        }

        public static void removePacketsHandler(PlayerData playerData) {
            if (playerData.packetsHandler != null) {
                Packets.getChannel(playerData.player).pipeline().remove(playerData.packetsHandler);
            }
        }

        private static Method getMethod(Class<?> clazz, String string) {
            for (Method method : clazz.getDeclaredMethods()) {
                if (!method.getName().equals(string)) continue;
                return method;
            }
            throw new NoSuchMethodException(string + " in " + clazz.getName());
        }

        @Deprecated
        private static Object getField(Class<?> clazz, String string, Object object) {
            return Packets.getField(clazz, string).get(object);
        }

        private static Field getField(Class<?> clazz, String string) {
            Field field = clazz.getDeclaredField(string);
            field.setAccessible(true);
            return field;
        }

        private static Class<?> getCraftClass(String string, String string2) {
            return Class.forName(cpack + string + "." + string2);
        }

        private static Class<?> getNMSClass(String string) {
            return Class.forName("net.minecraft." + string);
        }

        private static Class<?> getNMSClass(String string, String string2) {
            return Class.forName("net.minecraft." + string + "." + string2);
        }

        static {
            IBootstrap.dasBoot();
            packets = CacheBuilder.newBuilder().expireAfterWrite(5L, TimeUnit.SECONDS).build();
            dummy = new Object();
            cpack = Bukkit.getServer().getClass().getPackage().getName() + ".";
            enabled = false;
            teams = new EnumMap(ChatColor.class);
            try {
                Class<?> clazz;
                logger = new Logger("Adapt-GlowingEntities", null){

                    @Override
                    public void log(LogRecord logRecord) {
                        logRecord.setMessage("[Adapt-GlowingEntities] " + logRecord.getMessage());
                        super.log(logRecord);
                    }
                };
                logger.setParent(Bukkit.getServer().getLogger());
                logger.setLevel(Level.ALL);
                String[] stringArray = Bukkit.getServer().getClass().getPackage().getName().split("\\.")[3].substring(1).split("_");
                version = Integer.parseInt(stringArray[1]);
                stringArray = Bukkit.getBukkitVersion().split("-R")[0].split("\\.");
                versionMinor = stringArray.length <= 2 ? 0 : Integer.parseInt(stringArray[2]);
                logger.info("Found server version 1." + version + "." + versionMinor);
                mappings = ProtocolMappings.getMappings(version);
                if (mappings == null) {
                    mappings = ProtocolMappings.values()[ProtocolMappings.values().length - 1];
                    logger.warning("Loaded not matching version of the mappings for your server version (1." + version + "." + versionMinor + ")");
                }
                logger.info("Loaded mappings " + mappings.name());
                Class<?> clazz2 = Packets.getNMSClass("world.entity", "Entity");
                Class<?> clazz3 = Packets.getNMSClass("world.entity", "EntityTypes");
                Object obj = Packets.getNMSClass("world.entity", "Marker").getDeclaredConstructors()[0].newInstance(Packets.getField(clazz3, mappings.getMarkerTypeId(), null), null);
                getHandle = Packets.getCraftClass("entity", "CraftEntity").getDeclaredMethod("getHandle", new Class[0]);
                getDataWatcher = clazz2.getDeclaredMethod(mappings.getWatcherAccessor(), new Class[0]);
                Class<?> clazz4 = Packets.getNMSClass("network.syncher", "DataWatcher");
                watcherObjectFlags = Packets.getField(clazz2, mappings.getWatcherFlags(), null);
                watcherDummy = clazz4.getDeclaredConstructor(clazz2).newInstance(obj);
                Method method = watcherGet = version >= 18 ? clazz4.getDeclaredMethod("a", watcherObjectFlags.getClass()) : Packets.getMethod(clazz4, "get");
                if (version < 19 || version == 19 && versionMinor < 3) {
                    clazz = Packets.getNMSClass("network.syncher", "DataWatcher$Item");
                    watcherItemConstructor = clazz.getDeclaredConstructor(watcherObjectFlags.getClass(), Object.class);
                    watcherItemObject = clazz.getDeclaredMethod("a", new Class[0]);
                    watcherItemDataGet = clazz.getDeclaredMethod("b", new Class[0]);
                } else {
                    clazz = Packets.getNMSClass("network.syncher", "DataWatcher$b");
                    watcherBCreator = clazz.getDeclaredMethod("a", watcherObjectFlags.getClass(), Object.class);
                    watcherBId = clazz.getDeclaredMethod("a", new Class[0]);
                    watcherBSerializer = clazz.getDeclaredMethod("b", new Class[0]);
                    watcherItemDataGet = clazz.getDeclaredMethod("c", new Class[0]);
                    watcherSerializerObject = Packets.getNMSClass("network.syncher", "DataWatcherSerializer").getDeclaredMethod("a", Integer.TYPE);
                }
                playerConnection = Packets.getNMSClass("server.level", "EntityPlayer").getDeclaredField(mappings.getPlayerConnection());
                sendPacket = Packets.getNMSClass("server.network", "PlayerConnection").getMethod(mappings.getSendPacket(), Packets.getNMSClass("network.protocol", "Packet"));
                networkManager = Packets.getNMSClass("server.network", "PlayerConnection").getDeclaredField(mappings.getNetworkManager());
                networkManager.setAccessible(true);
                channelField = Packets.getNMSClass("network", "NetworkManager").getDeclaredField(mappings.getChannel());
                packetMetadata = Packets.getNMSClass("network.protocol.game", "PacketPlayOutEntityMetadata");
                packetMetadataEntity = Packets.getField(packetMetadata, mappings.getMetadataEntity());
                packetMetadataItems = Packets.getField(packetMetadata, mappings.getMetadataItems());
                packetMetadataConstructor = version < 19 || version == 19 && versionMinor < 3 ? packetMetadata.getDeclaredConstructor(Integer.TYPE, clazz4, Boolean.TYPE) : packetMetadata.getDeclaredConstructor(Integer.TYPE, List.class);
                if (version > 19 || version == 19 && versionMinor >= 4) {
                    packetBundle = Packets.getNMSClass("network.protocol.game", "ClientboundBundlePacket");
                    packetBundlePackets = packetBundle.getMethod("a", new Class[0]);
                }
                clazz = Packets.getNMSClass("world.scores", "Scoreboard");
                Class<?> clazz5 = Packets.getNMSClass("world.scores", "ScoreboardTeam");
                Class<?> clazz6 = Packets.getNMSClass("world.scores", "ScoreboardTeamBase$EnumTeamPush");
                Class<?> clazz7 = Packets.getNMSClass("EnumChatFormat");
                createTeamPacket = Packets.getNMSClass("network.protocol.game", "PacketPlayOutScoreboardTeam").getDeclaredConstructor(String.class, Integer.TYPE, Optional.class, Collection.class);
                createTeamPacket.setAccessible(true);
                createTeamPacketData = Packets.getNMSClass("network.protocol.game", "PacketPlayOutScoreboardTeam$b").getDeclaredConstructor(clazz5);
                createTeam = clazz5.getDeclaredConstructor(clazz, String.class);
                scoreboardDummy = clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                pushNever = clazz6.getDeclaredField("b").get(null);
                setTeamPush = clazz5.getDeclaredMethod(mappings.getTeamSetCollision(), clazz6);
                setTeamColor = clazz5.getDeclaredMethod(mappings.getTeamSetColor(), clazz7);
                getColorConstant = clazz7.getDeclaredMethod("a", Character.TYPE);
                enabled = true;
            }
            catch (Exception exception) {
                String string = "Glowing Entities reflection failed to initialize. The util is disabled. Please ensure your version (" + Bukkit.getServer().getClass().getPackage().getName() + ") is supported.";
                if (logger == null) {
                    exception.printStackTrace();
                    System.err.println(string);
                }
                logger.log(Level.SEVERE, string, exception);
            }
        }

        private static class TeamData {
            private final String id;
            private final Object creationPacket;
            private final Cache<String, Object> addPackets = CacheBuilder.newBuilder().expireAfterAccess(3L, TimeUnit.MINUTES).build();
            private final Cache<String, Object> removePackets = CacheBuilder.newBuilder().expireAfterAccess(3L, TimeUnit.MINUTES).build();

            public TeamData(int n, ChatColor chatColor) {
                if (!chatColor.isColor()) {
                    throw new IllegalArgumentException();
                }
                this.id = "glow-" + n + chatColor.getChar();
                Object obj = createTeam.newInstance(scoreboardDummy, this.id);
                setTeamPush.invoke(obj, pushNever);
                setTeamColor.invoke(obj, getColorConstant.invoke(null, Character.valueOf(chatColor.getChar())));
                Object obj2 = createTeamPacketData.newInstance(obj);
                this.creationPacket = createTeamPacket.newInstance(this.id, 0, Optional.of(obj2), Collections.EMPTY_LIST);
            }

            public Object getEntityAddPacket(String string) {
                Object object = this.addPackets.getIfPresent((Object)string);
                if (object == null) {
                    object = createTeamPacket.newInstance(this.id, 3, Optional.empty(), Arrays.asList(string));
                    this.addPackets.put((Object)string, object);
                }
                return object;
            }

            public Object getEntityRemovePacket(String string) {
                Object object = this.removePackets.getIfPresent((Object)string);
                if (object == null) {
                    object = createTeamPacket.newInstance(this.id, 4, Optional.empty(), Arrays.asList(string));
                    this.removePackets.put((Object)string, object);
                }
                return object;
            }

            static {
                IBootstrap.dasBoot();
            }
        }

        /*
         * Uses 'sealed' constructs - enablewith --sealed true
         */
        private static enum ProtocolMappings {
            V1_17(17, "Z", "Y", "getDataWatcher", "b", "a", "sendPacket", "k", "setCollisionRule", "setColor", "a", "b"),
            V1_18(18, "Z", "Y", "ai", "b", "a", "a", "m", "a", "a", "a", "b"),
            V1_19(19, null, "ab", null, "b", null, "a", "m", "a", "a", null, null){

                @Override
                public String getNetworkManager() {
                    return versionMinor < 4 ? "b" : "h";
                }

                @Override
                public String getWatcherFlags() {
                    return versionMinor < 4 ? "Z" : "an";
                }

                @Override
                public String getWatcherAccessor() {
                    if (versionMinor < 3) {
                        return "ai";
                    }
                    if (versionMinor == 3) {
                        return "al";
                    }
                    return "aj";
                }

                @Override
                public String getMetadataEntity() {
                    return versionMinor < 3 ? "a" : "b";
                }

                @Override
                public String getMetadataItems() {
                    return versionMinor < 3 ? "b" : "c";
                }
            };

            private final int major;
            private final String watcherFlags;
            private final String markerTypeId;
            private final String watcherAccessor;
            private final String playerConnection;
            private final String networkManager;
            private final String sendPacket;
            private final String channel;
            private final String teamSetCollsion;
            private final String teamSetColor;
            private final String metadataEntity;
            private final String metadataItems;

            private ProtocolMappings(int n2, String string2, String string3, String string4, String string5, String string6, String string7, String string8, String string9, String string10, String string11, String string12) {
                this.major = n2;
                this.watcherFlags = string2;
                this.markerTypeId = string3;
                this.watcherAccessor = string4;
                this.playerConnection = string5;
                this.networkManager = string6;
                this.sendPacket = string7;
                this.channel = string8;
                this.teamSetCollsion = string9;
                this.teamSetColor = string10;
                this.metadataEntity = string11;
                this.metadataItems = string12;
            }

            public int getMajor() {
                return this.major;
            }

            public String getWatcherFlags() {
                return this.watcherFlags;
            }

            public String getMarkerTypeId() {
                return this.markerTypeId;
            }

            public String getWatcherAccessor() {
                return this.watcherAccessor;
            }

            public String getPlayerConnection() {
                return this.playerConnection;
            }

            public String getNetworkManager() {
                return this.networkManager;
            }

            public String getSendPacket() {
                return this.sendPacket;
            }

            public String getChannel() {
                return this.channel;
            }

            public String getTeamSetCollision() {
                return this.teamSetCollsion;
            }

            public String getTeamSetColor() {
                return this.teamSetColor;
            }

            public String getMetadataEntity() {
                return this.metadataEntity;
            }

            public String getMetadataItems() {
                return this.metadataItems;
            }

            public static ProtocolMappings getMappings(int n) {
                for (ProtocolMappings protocolMappings : ProtocolMappings.values()) {
                    if (n != protocolMappings.getMajor()) continue;
                    return protocolMappings;
                }
                return null;
            }

            static {
                IBootstrap.dasBoot();
            }
        }
    }

    private static class PlayerData {
        final GlowingEntities instance;
        final Player player;
        final Map<Integer, GlowingData> glowingDatas;
        ChannelHandler packetsHandler;
        EnumSet<ChatColor> sentColors;

        PlayerData(GlowingEntities glowingEntities, Player player) {
            this.instance = glowingEntities;
            this.player = player;
            this.glowingDatas = new HashMap<Integer, GlowingData>();
        }

        static {
            IBootstrap.dasBoot();
        }
    }

    private static class GlowingData {
        final PlayerData player;
        final int entityID;
        final String teamID;
        ChatColor color;
        byte otherFlags;
        boolean enabled;

        GlowingData(PlayerData playerData, int n, String string, ChatColor chatColor, byte by) {
            this.player = playerData;
            this.entityID = n;
            this.teamID = string;
            this.color = chatColor;
            this.otherFlags = by;
            this.enabled = true;
        }

        static {
            IBootstrap.dasBoot();
        }
    }
}

