/*
 * Decompiled with CFR 0.152.
 */
package com.volmit.adapt.util;

import com.volmit.adapt.util.Dictionary;
import com.volmit.adapt.util.JSONArray;
import com.volmit.adapt.util.JSONException;
import com.volmit.adapt.util.JSONObject;
import com.volmit.adapt.util.manifold.rt.api.IBootstrap;
import java.util.zip.DataFormatException;
import java.util.zip.Deflater;
import java.util.zip.Inflater;

public class JsonCompressor {
    private static final String escapeChar = ";";
    private static final int ESCAPED_UPPERCASE = 1;
    private static final int USE_PROTOTYPE = 4;
    String aWalk;
    int pos = 0;
    private String prototypeCompact;

    public JsonCompressor() {
    }

    public JsonCompressor(String string) {
        if (string != null) {
            this.prototypeCompact = this.compact(string);
        }
    }

    public byte[] compressJson(String string) {
        byte[] byArray;
        int n = 0;
        String string2 = this.walkFormat(string);
        String string3 = string2.replaceAll("([A-Z])", ";$1");
        String string4 = string3.toUpperCase();
        string4 = Dictionary.shorten(string4);
        byte[] byArray2 = this.compress6AndDec(string4.getBytes());
        byte[] byArray3 = this.pack(string2.getBytes(), 7);
        byte[] byArray4 = null;
        if (this.prototypeCompact != null) {
            byArray4 = this.deflateWithPrototype(string4);
        }
        if (byArray4 != null && byArray4.length < byArray2.length) {
            byArray = byArray4;
            n |= 1;
            n |= 4;
        } else if (byArray2.length < byArray3.length) {
            byArray = byArray2;
            n |= 1;
        } else {
            byArray = byArray3;
        }
        byte[] byArray5 = new byte[byArray.length + 1];
        byArray5[0] = (byte)n;
        System.arraycopy(byArray, 0, byArray5, 1, byArray.length);
        return byArray5;
    }

    public String expandJson(byte[] byArray) {
        String string;
        byte by = byArray[0];
        byte[] byArray2 = new byte[byArray.length - 1];
        System.arraycopy(byArray, 1, byArray2, 0, byArray.length - 1);
        if ((by & 1) != 0) {
            if ((by & 4) != 0) {
                if (this.prototypeCompact == null) {
                    throw new RuntimeException("Unable to expand. Do not have the prototype.");
                }
                string = this.inflateWithPrototype(byArray2);
            } else {
                string = new String(this.expand6AndInc(byArray2));
            }
            string = Dictionary.lengthen(string);
            string = string.toLowerCase();
            for (char c : "abcdefghijklmnopqrstuvwxyz".toCharArray()) {
                string = string.replaceAll(escapeChar + c, ("" + c).toUpperCase());
            }
        } else {
            string = new String(this.unpack(byArray2, 7));
        }
        return this.unwalkFormat(string);
    }

    void incrementEach(byte[] byArray, int n) {
        for (int i = 0; i < byArray.length; ++i) {
            byArray[i] = (byte)(byArray[i] + n);
        }
    }

    byte[] expand6AndInc(byte[] byArray) {
        byte[] byArray2 = this.unpack(byArray, 6);
        this.incrementEach(byArray2, 32);
        return byArray2;
    }

    byte[] compress6AndDec(byte[] byArray) {
        this.incrementEach(byArray, -32);
        return this.pack(byArray, 6);
    }

    byte[] unpack(byte[] byArray, int n) {
        byte[] byArray2 = new byte[byArray.length * 8 / n];
        int n2 = 0;
        int n3 = 0;
        if (n == 6) {
            n3 = 63;
        } else if (n == 7) {
            n3 = 127;
        } else {
            throw new RuntimeException("Can only unpack 6 or 7 bits");
        }
        int n4 = 8 - n;
        for (int i = 0; i < byArray2.length; ++i) {
            int n5 = n2 & 7;
            int n6 = n2 >> 3;
            int n7 = 0xFF & byArray[n6];
            if (n5 == 0) {
                byArray2[i] = (byte)(n7 >> n4);
            } else if (n5 <= n4) {
                byArray2[i] = (byte)(n3 & n7);
            } else {
                byte by = (byte)(n3 & n7 << n5 - n4);
                byte by2 = (byte)((0xFF & byArray[n6 + 1]) >> 16 - n - n5);
                byArray2[i] = (byte)(by | by2);
            }
            n2 += n;
        }
        if (byArray2.length > 0 && byArray2[byArray2.length - 1] == 0) {
            byte[] byArray3 = new byte[byArray2.length - 1];
            System.arraycopy(byArray2, 0, byArray3, 0, byArray3.length);
            byArray2 = byArray3;
        }
        return byArray2;
    }

    byte[] pack(byte[] byArray, int n) {
        int n2;
        int n3 = byArray.length * n / 8;
        if (n3 * 8 < byArray.length * n) {
            ++n3;
        }
        byte[] byArray2 = new byte[n3];
        int n4 = 0;
        for (n2 = 0; n2 < byArray2.length; ++n2) {
            byArray2[n2] = 0;
        }
        n2 = 8 - n;
        for (int i = 0; i < byArray.length; ++i) {
            byte by = byArray[i];
            int n5 = n4 & 7;
            int n6 = n4 >> 3;
            if (n5 == 0) {
                byArray2[n6] = (byte)(0xFF & by << n2);
            } else if (n5 <= n2) {
                byArray2[n6] = (byte)(byArray2[n6] | by);
            } else {
                byArray2[n6] = (byte)(byArray2[n6] | by >> n5 - n2);
                byArray2[n6 + 1] = (byte)(0xFF & by << 16 - n - n5);
            }
            n4 += n;
        }
        return byArray2;
    }

    byte[] deflateWithPrototype(String string) {
        byte[] byArray = new byte[100];
        Deflater deflater = new Deflater();
        deflater.setDictionary(this.prototypeCompact.getBytes());
        deflater.setInput(string.getBytes());
        deflater.finish();
        int n = deflater.deflate(byArray);
        deflater.end();
        byte[] byArray2 = new byte[n];
        System.arraycopy(byArray, 0, byArray2, 0, n);
        return byArray2;
    }

    String inflateWithPrototype(byte[] byArray) {
        Inflater inflater = new Inflater();
        inflater.setInput(byArray, 0, byArray.length);
        byte[] byArray2 = new byte[400];
        int n = 0;
        try {
            inflater.inflate(byArray2);
            inflater.setDictionary(this.prototypeCompact.getBytes());
            n = inflater.inflate(byArray2);
            if (n == byArray2.length) {
                throw new RuntimeException("Unable to expand. Too little space");
            }
        }
        catch (DataFormatException dataFormatException) {
            throw new RuntimeException("Unable to expand from prototype", dataFormatException);
        }
        inflater.end();
        return new String(byArray2, 0, n);
    }

    private String compact(String string) {
        String string2 = this.normalizeJson(string);
        String string3 = this.walkFormat(string2);
        String string4 = string3.replaceAll("([A-Z])", ";$1");
        String string5 = string4.toUpperCase();
        return Dictionary.shorten(string5);
    }

    private String normalizeJson(String string) {
        return new JSONObject(string).toString();
    }

    String walkFormat(String string) {
        String string2 = string.trim();
        StringBuilder stringBuilder = new StringBuilder();
        char[] cArray = string2.toCharArray();
        boolean bl = false;
        for (int i = 0; i < cArray.length; ++i) {
            char c = cArray[i];
            if (c == '\"') {
                bl = !bl;
                continue;
            }
            if (c == '>' && bl) {
                stringBuilder.append(";>");
                continue;
            }
            if (c == '+' && bl) {
                stringBuilder.append(";+");
                continue;
            }
            if (c == '^' && bl) {
                stringBuilder.append(";^");
                continue;
            }
            if (c == '*' && bl) {
                stringBuilder.append(";*");
                continue;
            }
            if (c == '<' && bl) {
                stringBuilder.append(";<");
                continue;
            }
            if (c == ';' && bl) {
                stringBuilder.append(";;");
                continue;
            }
            if (c == ' ' && !bl || c == '\n' && !bl) continue;
            if (c == '}' && !bl) {
                stringBuilder.append('^');
                continue;
            }
            if (c == ']' && !bl) {
                stringBuilder.append('^');
                continue;
            }
            if (c == '{' && !bl) {
                stringBuilder.append('+');
                continue;
            }
            if (c == '[' && !bl) {
                stringBuilder.append('*');
                continue;
            }
            if (c == ',' && !bl) {
                stringBuilder.append('>');
                continue;
            }
            if (c == ':' && !bl) {
                stringBuilder.append('>');
                continue;
            }
            stringBuilder.append(c);
        }
        String string3 = stringBuilder.toString();
        if (string3.startsWith("+")) {
            string3 = string3.substring(1);
        }
        while (string3.endsWith("^")) {
            string3 = string3.substring(0, string3.length() - 1);
        }
        return string3;
    }

    String unwalkFormat(String string) {
        this.aWalk = string;
        if (!this.aWalk.startsWith("*")) {
            this.aWalk = "+" + this.aWalk + "^";
        }
        this.pos = 0;
        Object object = null;
        try {
            object = this.readWalk();
        }
        catch (JSONException jSONException) {
            throw new RuntimeException("Can't parse walk", jSONException);
        }
        return object.toString();
    }

    Object readWalk() {
        char c = this.aWalk.charAt(this.pos);
        if (c == '+') {
            ++this.pos;
            return this.readMap();
        }
        if (c == '*') {
            ++this.pos;
            return this.readArray();
        }
        return this.readString();
    }

    JSONObject readMap() {
        char c = this.aWalk.charAt(this.pos);
        JSONObject jSONObject = new JSONObject();
        while (this.pos < this.aWalk.length() && c != '^') {
            String string = this.readString();
            if ((c = this.aWalk.charAt(++this.pos)) == '>') {
                ++this.pos;
            }
            Object object = this.readWalk();
            jSONObject.put(string, object);
            if (this.pos == this.aWalk.length() - 1) break;
            if ((c = this.aWalk.charAt(++this.pos)) != '>') continue;
            ++this.pos;
        }
        return jSONObject;
    }

    JSONArray readArray() {
        char c = this.aWalk.charAt(this.pos);
        JSONArray jSONArray = new JSONArray();
        while (this.pos < this.aWalk.length() && c != '^') {
            Object object = this.readWalk();
            jSONArray.put(object);
            if (this.pos == this.aWalk.length() - 1) break;
            if ((c = this.aWalk.charAt(++this.pos)) != '>') continue;
            ++this.pos;
        }
        return jSONArray;
    }

    String readString() {
        StringBuilder stringBuilder = new StringBuilder();
        char c = this.aWalk.charAt(this.pos);
        int n = this.pos;
        boolean bl = false;
        while (bl || c != '^' && c != '>' && c != '+' && c != '*') {
            boolean bl2;
            boolean bl3 = bl2 = c == escapeChar.charAt(0);
            if (!bl && bl2) {
                bl = true;
            } else {
                bl = false;
                stringBuilder.append(c);
            }
            if (this.pos == this.aWalk.length() - 1) {
                ++this.pos;
                break;
            }
            c = this.aWalk.charAt(++this.pos);
        }
        --this.pos;
        return stringBuilder.toString();
    }

    static {
        IBootstrap.dasBoot();
    }
}

