/*
 * Decompiled with CFR 0.152.
 */
package com.volmit.adapt.util;

import com.volmit.adapt.util.C;
import com.volmit.adapt.util.Command;
import com.volmit.adapt.util.ICommand;
import com.volmit.adapt.util.MortarPermission;
import com.volmit.adapt.util.MortarSender;
import com.volmit.adapt.util.extensions.java.util.List.XList;
import com.volmit.adapt.util.manifold.rt.api.IBootstrap;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.Sound;

public abstract class MortarCommand
implements ICommand {
    private final List<MortarCommand> children;
    private final List<String> nodes;
    private final List<String> requiredPermissions;
    private final String node;
    private String category = "";
    private String description;

    public MortarCommand(String string, String ... stringArray) {
        this.node = string;
        this.nodes = new ArrayList<String>();
        XList.add(this.nodes, stringArray);
        this.requiredPermissions = new ArrayList<String>();
        this.children = this.buildChildren();
        this.description = "No Description";
    }

    @Override
    public List<String> handleTab(MortarSender mortarSender, String[] stringArray) {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (stringArray.length == 0) {
            for (MortarCommand mortarCommand : this.getChildren()) {
                arrayList.add(mortarCommand.getNode());
            }
        }
        this.addTabOptions(mortarSender, stringArray, arrayList);
        if (arrayList.isEmpty()) {
            return null;
        }
        if (mortarSender.isPlayer()) {
            mortarSender.player().getWorld().playSound(mortarSender.player().getLocation(), Sound.ENTITY_ITEM_FRAME_ROTATE_ITEM, 0.25f, 1.7f);
        }
        return arrayList;
    }

    public abstract void addTabOptions(MortarSender var1, String[] var2, List<String> var3);

    public void printHelp(MortarSender mortarSender) {
        boolean bl = false;
        for (MortarCommand mortarCommand : this.getChildren()) {
            for (String string : mortarCommand.getRequiredPermissions()) {
                if (mortarSender.hasPermission(string)) continue;
            }
            bl = true;
            mortarSender.sendMessage(C.GREEN + mortarCommand.getNode() + " " + C.WHITE + mortarCommand.getArgsUsage() + C.GRAY + " - " + mortarCommand.getDescription());
        }
        if (!bl) {
            mortarSender.sendMessage("There are either no sub-commands or you do not have permission to use them.");
        }
        if (mortarSender.isPlayer()) {
            mortarSender.player().getWorld().playSound(mortarSender.player().getLocation(), Sound.ITEM_BOOK_PAGE_TURN, 0.28f, 1.4f);
            mortarSender.player().getWorld().playSound(mortarSender.player().getLocation(), Sound.ITEM_AXE_STRIP, 0.35f, 1.7f);
        }
    }

    protected abstract String getArgsUsage();

    public String getDescription() {
        return this.description;
    }

    protected void setDescription(String string) {
        this.description = string;
    }

    protected void requiresPermission(MortarPermission mortarPermission) {
        if (mortarPermission == null) {
            return;
        }
        this.requiresPermission(mortarPermission.toString());
    }

    protected void requiresPermission(String string) {
        if (string == null) {
            return;
        }
        this.requiredPermissions.add(string);
    }

    public void rejectAny(int n, MortarSender mortarSender, String[] stringArray) {
        if (stringArray.length > n) {
            int n2 = n;
            Object object = "";
            for (String string : stringArray) {
                if (--n2 >= 0) continue;
                object = (String)object + string + ", ";
            }
            if (!((String)object).trim().isEmpty()) {
                mortarSender.sendMessage("Parameters Ignored: " + (String)object);
            }
        }
    }

    @Override
    public String getNode() {
        return this.node;
    }

    @Override
    public List<String> getNodes() {
        return this.nodes;
    }

    @Override
    public List<String> getAllNodes() {
        return XList.qadd(XList.copy(this.getNodes()), this.getNode());
    }

    @Override
    public void addNode(String string) {
        this.getNodes().add(string);
    }

    public List<MortarCommand> getChildren() {
        return this.children;
    }

    private List<MortarCommand> buildChildren() {
        ArrayList<MortarCommand> arrayList = new ArrayList<MortarCommand>();
        for (Field field : this.getClass().getDeclaredFields()) {
            if (!field.isAnnotationPresent(Command.class)) continue;
            try {
                field.setAccessible(true);
                MortarCommand mortarCommand = (MortarCommand)field.getType().getConstructor(new Class[0]).newInstance(new Object[0]);
                Command command = field.getAnnotation(Command.class);
                if (!command.value().trim().isEmpty()) {
                    mortarCommand.setCategory(command.value().trim());
                } else {
                    mortarCommand.setCategory(this.getCategory());
                }
                arrayList.add(mortarCommand);
            }
            catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException exception) {
                exception.printStackTrace();
            }
        }
        return arrayList;
    }

    @Override
    public List<String> getRequiredPermissions() {
        return this.requiredPermissions;
    }

    public String getCategory() {
        return this.category;
    }

    public void setCategory(String string) {
        this.category = string;
    }

    static {
        IBootstrap.dasBoot();
    }
}

